/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.strategy.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.dto.dialogue.AgentAssistantDetailVo;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.SkcHelper;
import com.digiwin.athena.ania.service.assistant.strategy.AssistantCollectService;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class EmbeddedServiceImpl
implements AssistantCollectService {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedServiceImpl.class);
    @Autowired
    private SkcHelper skcHelper;
    @Autowired
    private EnvProperties envProperties;

    public Integer getAssistantType() {
        return AssistantType.EMBEDDED_ASSISTANT.getType();
    }

    public FusionAssistantVo assistantBaseInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        JSONObject agentDetail = this.skcHelper.queryAgentDetail(param.getAssistantId(), authoredUser.getToken(), LanguageUtils.processLanguage());
        return AgentAssistantDetailVo.embeddedAssistantMap((String)param.getAssistantId(), (JSONObject)agentDetail, (String)this.envProperties.getDmcUri());
    }

    public FusionAssistantVo assistantDetailsInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        return this.assistantBaseInfo(param, authoredUser);
    }

    public List<FusionAssistantVo> assistantList(AuthoredUser authoredUser, List<String> currentAppCodes, String clientType, Boolean simple) {
        if ("APP".equals(clientType)) {
            return new ArrayList<FusionAssistantVo>();
        }
        StopWatch sw = new StopWatch();
        sw.start();
        List jsonObjectList = this.skcHelper.queryAgentList(20, authoredUser.getToken(), LanguageUtils.processLanguage());
        List fusionAssistantVos = AgentAssistantDetailVo.embeddedAssistantMap((List)jsonObjectList, (String)this.envProperties.getDmcUri());
        sw.stop();
        log.info("EmbeddedServiceImpl.assistantList query end TotalTimeMillis = {}", (Object)sw.getTotalTimeMillis());
        return fusionAssistantVos;
    }
}

