/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ania.common.enums.AssistantSceneTypeEnum;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.dto.AssistantConfig;
import com.digiwin.athena.ania.dto.LanguageTemplateBO;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.dto.dialogue.FusionHistoryAssistantVo;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.mongo.domain.ApplicationAssistantRelation;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.repository.AppAssistantRelationDao;
import com.digiwin.athena.ania.mongo.repository.AssistantMgDao;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.service.AssistantManager;
import com.digiwin.athena.ania.service.assistant.AssistantSceneService;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.service.assistant.FusionAssistantPluginService;
import com.digiwin.athena.ania.service.assistant.strategy.HistoryAssistantService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HistoryAssistantServiceImpl
implements HistoryAssistantService {
    private static final Logger log = LoggerFactory.getLogger(HistoryAssistantServiceImpl.class);
    @Value(value="${assistant.designerLegworkCode}")
    private String legworkCode;
    @Value(value="${assistant.customLegworkCode:asaca}")
    private String customLegworkCode;
    @Resource
    private AssistantManager assistantManager;
    @Resource
    private ConversationService conversationService;
    @Resource
    private CacHelper cacHelper;
    @Resource
    private KmHelper kmHelper;
    @Resource
    private AssistantSceneService assistantSceneService;
    @Resource
    private AssistantService assistantService;
    @Resource
    private AssistantMgDao assistantMgDao;
    @Resource
    private AppAssistantRelationDao appAssistantRelationDao;
    @Resource
    private AssistantSceneDao assistantSceneDao;
    @Resource
    private FusionAssistantPluginService fusionAssistantPluginService;
    @Resource
    private RedisTemplate redisTemplate;

    public Integer getAssistantType() {
        return AssistantType.HISTORY_ASSISTANT.getType();
    }

    public FusionAssistantVo assistantBaseInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        return this.assistantConfig(param, authoredUser, true);
    }

    public FusionAssistantVo assistantDetailsInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        return this.assistantConfig(param, authoredUser, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FusionAssistantVo assistantConfig(FusionAssistantInfoDto param, AuthoredUser authoredUser, boolean simple) {
        List assistantScenes;
        Assistant assistant;
        String language = LanguageUtils.processLanguage();
        String tenantVersion = param.getVersion();
        if (StringUtils.isBlank((CharSequence)tenantVersion)) {
            tenantVersion = this.kmHelper.getTenantVersion(authoredUser.getTenantId());
        }
        if (Objects.isNull(assistant = this.assistantService.getAssistant(param.getAssistantId(), tenantVersion))) return null;
        if (!Objects.equals(1, assistant.getStatus())) {
            return null;
        }
        List assistantConfigList = AssistantManager.generateAssistantConfig((List)Lists.newArrayList((Object[])new Assistant[]{assistant}), (String)language);
        AssistantConfig assistantConfig = (AssistantConfig)assistantConfigList.get(0);
        if (AssistantSubTypeEnum.COMPOSITE.getType().equals(assistant.getAssistantSubType())) {
            List currentAppCodes = this.cacHelper.getCurrentAppCodes(authoredUser);
            if (BooleanUtils.isTrue((Boolean)param.getAuth())) {
                boolean authResult;
                if (CollectionUtils.isEmpty((Collection)assistant.getAssociatedGoods())) {
                    return null;
                }
                if (CollectionUtils.isEmpty((Collection)currentAppCodes)) {
                    return null;
                }
                if (assistant.getAssociatedGoods().contains(assistant.getAssistantCode())) {
                    authResult = currentAppCodes.stream().anyMatch(assistant.getAssociatedGoods()::contains);
                } else {
                    if (!currentAppCodes.contains(assistant.getAssistantCode())) return null;
                    if (!currentAppCodes.stream().anyMatch(assistant.getAssociatedGoods()::contains)) return null;
                    boolean bl = true;
                    authResult = bl;
                }
                if (!authResult) {
                    return null;
                }
            }
            if (simple) return FusionHistoryAssistantVo.hisCovertFusionAssistantVo((AssistantConfig)assistantConfig);
            List assistantScenes2 = this.assistantSceneService.querySkillsByAssistantCode((List)Lists.newArrayList((Object[])new String[]{assistant.getAssistantCode()}), null, assistant.getVersion());
            List filterAuthScene = this.assistantSceneService.filterAuthScene(assistantConfig, assistantScenes2, null, new HashSet(currentAppCodes));
            assistantConfig.setLanguageTemplate(filterAuthScene);
            return FusionHistoryAssistantVo.hisCovertFusionAssistantVo((AssistantConfig)assistantConfig);
        }
        if (BooleanUtils.isTrue((Boolean)param.getAuth())) {
            if (!this.cacHelper.hasApplicationAuth(authoredUser, assistant.getAssistantCode())) {
                return null;
            }
            if (AssistantSubTypeEnum.KNOWLEAGE.getType().equals(assistant.getAssistantSubType()) && "private".equals(assistant.getKnowledgeType()) && !this.cacHelper.hasApplicationAuth(authoredUser, "KCF")) {
                return null;
            }
        }
        if (simple) return FusionHistoryAssistantVo.hisCovertFusionAssistantVo((AssistantConfig)assistantConfig);
        if (AssistantSubTypeEnum.DATA.getType().equals(assistantConfig.getAssistantSubType())) {
            assistantScenes = this.assistantManager.buildAgileDataLanguageTemplate(assistantConfig, authoredUser);
        } else {
            assistantScenes = this.assistantSceneService.querySkillsByAssistantCode((List)Lists.newArrayList((Object[])new String[]{assistant.getAssistantCode()}), null, assistant.getVersion());
            this.sortScene(assistantScenes);
        }
        assistantConfig.setLanguageTemplate(assistantScenes);
        return FusionHistoryAssistantVo.hisCovertFusionAssistantVo((AssistantConfig)assistantConfig);
    }

    public List<FusionAssistantVo> assistantList(AuthoredUser authoredUser, List<String> currentAppCodes, String clientType, Boolean simple) {
        List assistantIds;
        Map plugins;
        List assistants;
        List historyAssistants;
        if (CollectionUtils.isEmpty(currentAppCodes)) {
            return Collections.emptyList();
        }
        currentAppCodes.remove("Athena");
        if (StringUtils.isNotBlank((CharSequence)this.legworkCode) && currentAppCodes.contains(this.legworkCode) && currentAppCodes.contains(this.customLegworkCode)) {
            currentAppCodes.remove(this.customLegworkCode);
        }
        if (CollectionUtils.isEmpty((Collection)(historyAssistants = this.appAssistantRelationDao.queryAssistant(currentAppCodes, AssistantType.HISTORY_ASSISTANT.getType().intValue())))) {
            return Collections.emptyList();
        }
        String tenantVersion = this.kmHelper.getTenantVersion(authoredUser.getTenantId());
        Criteria criteria = Criteria.where((String)"assistantCode").in((Collection)historyAssistants).and("status").is((Object)1).and("version").is((Object)tenantVersion);
        if (StringUtils.isNotBlank((CharSequence)clientType)) {
            criteria.and("clientType").in((Collection)Lists.newArrayList((Object[])new String[]{clientType}));
        }
        if (CollectionUtils.isEmpty((Collection)(assistants = this.assistantMgDao.findList(new Query((CriteriaDefinition)criteria))))) {
            return Collections.emptyList();
        }
        List assistantConfigList = AssistantManager.generateAssistantConfig(assistants = assistants.stream().filter(assistant -> this.authAssistant(assistant, currentAppCodes)).collect(Collectors.toList()), (String)LanguageUtils.processLanguage());
        if (CollectionUtils.isEmpty((Collection)assistantConfigList)) {
            return Collections.emptyList();
        }
        if (!BooleanUtils.isTrue((Boolean)simple)) {
            this.buildLanguageTemplate(authoredUser, assistantConfigList, currentAppCodes);
        }
        List fusionAssistantVos = FusionHistoryAssistantVo.historyAssistantMap((List)assistantConfigList);
        if (!BooleanUtils.isTrue((Boolean)simple) && MapUtils.isNotEmpty((Map)(plugins = this.fusionAssistantPluginService.findPlugins(assistantIds = assistantConfigList.stream().map(assistantConfig -> assistantConfig.getAssistantCode()).collect(Collectors.toList()), tenantVersion)))) {
            fusionAssistantVos.forEach(fusionAssistant -> {
                List maps = (List)plugins.get(fusionAssistant.getAssistantId());
                fusionAssistant.setPluginCustoms(maps);
            });
        }
        return fusionAssistantVos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean authAssistant(Assistant assistant, List<String> currentAppCodes) {
        if (AssistantSubTypeEnum.KNOWLEAGE.getType().equals(assistant.getAssistantSubType()) && "private".equals(assistant.getKnowledgeType())) {
            if (!currentAppCodes.contains(assistant.getAssistantCode())) return false;
            if (!currentAppCodes.contains("KCF")) return false;
            return true;
        }
        if (!AssistantSubTypeEnum.COMPOSITE.getType().equals(assistant.getAssistantSubType())) return true;
        List associatedGoods = assistant.getAssociatedGoods();
        if (CollectionUtils.isEmpty((Collection)associatedGoods)) {
            return false;
        }
        if (associatedGoods.contains(assistant.getAssistantCode())) {
            return currentAppCodes.stream().anyMatch(associatedGoods::contains);
        }
        if (!currentAppCodes.contains(assistant.getAssistantCode())) return false;
        if (!currentAppCodes.stream().anyMatch(associatedGoods::contains)) return false;
        return true;
    }

    private void buildLanguageTemplate(AuthoredUser authoredUser, List<AssistantConfig> assistantList, List<String> currentAppCodes) {
        String tenantVersion;
        List assistantScenesList;
        List assistantCodes = assistantList.stream().filter(item -> (!AssistantSubTypeEnum.KNOWLEAGE.getType().equals(item.getAssistantSubType()) || !"private".equals(item.getKnowledgeType())) && !AssistantSubTypeEnum.DATA.getType().equals(item.getAssistantSubType())).map(AssistantConfig::getAssistantCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(assistantCodes) && CollUtil.isNotEmpty((Collection)(assistantScenesList = this.assistantSceneService.querySkillsByAssistantCode(assistantCodes, null, tenantVersion = assistantList.get(0).getVersion())))) {
            HashSet<String> authAppCodes = new HashSet<String>(currentAppCodes);
            Map<String, List<LanguageTemplateBO>> assistantSceneMap = assistantScenesList.stream().collect(Collectors.groupingBy(LanguageTemplateBO::getAssistantCode));
            for (AssistantConfig assistantConfig : assistantList) {
                List<LanguageTemplateBO> assistantScenes = assistantSceneMap.get(assistantConfig.getAssistantCode());
                if (CollectionUtils.isNotEmpty(assistantScenes)) {
                    List filterAuthScene = this.assistantSceneService.filterAuthScene(assistantConfig, assistantScenes, null, authAppCodes);
                    assistantConfig.setLanguageTemplate(filterAuthScene);
                }
                if (!Objects.nonNull(assistantConfig.getAssistantSubType()) || assistantConfig.getAssistantSubType() != 5 || !StringUtils.isNotBlank((CharSequence)assistantConfig.getSkillId())) continue;
                String webUrl = RedisUtils.getCacheStrData((String)("last_webUrl_key:" + authoredUser.getUserId() + authoredUser.getTenantId() + assistantConfig.getSkillId()));
                if (StringUtils.isBlank((CharSequence)webUrl) && StringUtils.isNotBlank((CharSequence)(webUrl = this.kmHelper.getWebUrl(assistantConfig.getSkillId(), authoredUser.getToken())))) {
                    RedisUtils.cacheStrData((String)("last_webUrl_key:" + authoredUser.getUserId() + authoredUser.getTenantId() + assistantConfig.getSkillId()), (String)webUrl, (long)30L, (TimeUnit)TimeUnit.MINUTES);
                }
                assistantConfig.setWebUrl(webUrl);
            }
        }
    }

    private List<LanguageTemplateBO> sortScene(List<LanguageTemplateBO> assistantScenes) {
        if (CollectionUtils.isNotEmpty(assistantScenes)) {
            return assistantScenes;
        }
        ArrayList noSort = new ArrayList();
        ArrayList sort = new ArrayList();
        assistantScenes.forEach(item -> {
            if (Objects.nonNull(item.getSort())) {
                sort.add(item);
            } else {
                noSort.add(item);
            }
        });
        List sortedWithSort = sort.stream().sorted(Comparator.comparingInt(LanguageTemplateBO::getSort)).collect(Collectors.toList());
        ArrayList<LanguageTemplateBO> result = new ArrayList<LanguageTemplateBO>(sortedWithSort);
        result.addAll(noSort);
        return result;
    }

    public void publish(String assistantId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId));
        this.appAssistantRelationDao.delete(query);
        List assistants = this.assistantMgDao.findList(new Query((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)assistantId)));
        if (CollectionUtils.isEmpty((Collection)assistants)) {
            return;
        }
        if (AssistantSubTypeEnum.COMPOSITE.getType().equals(((Assistant)assistants.get(0)).getAssistantSubType())) {
            HashSet associatedAllGoods = new HashSet();
            for (Assistant assistant : assistants) {
                List assistantScenes = this.assistantSceneDao.findAllByAssistantCodeAndVersion(assistant.getAssistantCode(), assistant.getVersion());
                assistant.setAssociatedGoods(null);
                if (CollectionUtils.isNotEmpty((Collection)assistantScenes)) {
                    HashSet<String> associatedGoods = new HashSet<String>();
                    for (AssistantScene assistantScene : assistantScenes) {
                        if (Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_KNOWLEDGE.getType(), assistantScene.getType())) {
                            if ("private".equals(assistantScene.getKnowledgeBase().get((Object)"type"))) {
                                associatedGoods.add("KCF");
                                continue;
                            }
                            if (!"public".equals(assistantScene.getKnowledgeBase().get((Object)"type"))) continue;
                            associatedGoods.add(assistantScene.getCode());
                            continue;
                        }
                        if (Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_DATA.getType(), assistantScene.getType())) {
                            String application = MapUtils.getString((Map)assistantScene.getDataMetric(), (Object)"application");
                            associatedGoods.add(application);
                            continue;
                        }
                        if (!Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_BUSINESS.getType(), assistantScene.getType())) continue;
                        associatedGoods.add(assistantScene.getAssistantCode());
                    }
                    if (CollectionUtils.isNotEmpty(associatedGoods)) {
                        associatedAllGoods.addAll(associatedGoods);
                        assistant.setAssociatedGoods(new ArrayList(associatedGoods));
                    }
                }
                this.assistantMgDao.save((Object)assistant);
                this.redisTemplate.opsForValue().set((Object)("ANIA:HIS:ASSISTANT:" + assistant.getVersion() + assistant.getAssistantCode()), (Object)JSON.toJSONString((Object)assistant));
            }
            if (CollectionUtils.isNotEmpty(associatedAllGoods)) {
                List assistantRelations = associatedAllGoods.stream().map(appCode -> ApplicationAssistantRelation.builder().appCode(appCode).assistantId(assistantId).assistantType(AssistantType.HISTORY_ASSISTANT.getType()).build()).collect(Collectors.toList());
                this.appAssistantRelationDao.insertAll(assistantRelations);
            }
        } else {
            for (Assistant assistant : assistants) {
                this.redisTemplate.opsForValue().set((Object)("ANIA:HIS:ASSISTANT:" + assistant.getVersion() + assistant.getAssistantCode()), (Object)JSON.toJSONString((Object)assistant));
            }
            this.appAssistantRelationDao.save((Object)ApplicationAssistantRelation.builder().appCode(assistantId).assistantId(assistantId).assistantType(AssistantType.HISTORY_ASSISTANT.getType()).build());
        }
    }
}

