/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.brush;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.dto.skc.command.AgentBaseInfoDto;
import com.digiwin.athena.ania.helper.dto.skc.command.CreateCommandSetsBrushDto;
import com.digiwin.athena.ania.helper.dto.skc.command.UserInfos;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantQuestionItem;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantQuestionItemMgDao;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantSubMgDao;
import com.digiwin.athena.ania.service.assistant.SkcService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class BrushAssistantQuestionComponent {
    private static final Logger log = LoggerFactory.getLogger(BrushAssistantQuestionComponent.class);
    @Autowired
    private IamHelper iamHelper;
    @Autowired
    private SkcService skcService;
    @Autowired
    private FusionAssistantSubMgDao fusionAssistantSubMgDao;
    @Autowired
    private FusionAssistantQuestionItemMgDao fusionAssistantQuestionItemMgDao;

    public void brush(String assistantId, String userId) {
        List brushQuestAssistants = this.findBrushQuestAssistant(assistantId);
        for (int i = 0; i < brushQuestAssistants.size(); ++i) {
            FusionAssistantSub fusionAssistant = (FusionAssistantSub)brushQuestAssistants.get(i);
            try {
                int pageNum = 1;
                long totalMigrated = 0L;
                boolean hasMoreData = true;
                while (hasMoreData) {
                    List questionItems = this.fusionAssistantQuestionItemMgDao.findSkcListByAssistantId(fusionAssistant.getAssistantId(), userId, pageNum, 100);
                    if (CollUtil.isEmpty((Collection)questionItems)) {
                        hasMoreData = false;
                        continue;
                    }
                    for (int k = questionItems.size() - 1; k >= 0; --k) {
                        FusionAssistantQuestionItem item = (FusionAssistantQuestionItem)questionItems.get(k);
                        JSONObject tenantInfo = this.iamHelper.getRealTimeTenantToken(item.getTenantId());
                        Long tenantIdSid = tenantInfo.getLong("tenantSid");
                        String tenantName = tenantInfo.getString("tenantName");
                        if (null == tenantIdSid) continue;
                        AgentBaseInfoDto agentBaseInfoDto = new AgentBaseInfoDto();
                        agentBaseInfoDto.setSkillId(item.getAssistantId());
                        agentBaseInfoDto.setAgentName(fusionAssistant.getAssistantName());
                        CreateCommandSetsBrushDto createCommandSetsDto = new CreateCommandSetsBrushDto();
                        createCommandSetsDto.setName(StrUtil.sub((CharSequence)item.getQuestion(), (int)0, (int)50));
                        createCommandSetsDto.setContent(item.getQuestion());
                        createCommandSetsDto.setAgents((List)ListUtil.toList((Object[])new AgentBaseInfoDto[]{agentBaseInfoDto}));
                        UserInfos userInfos = new UserInfos();
                        userInfos.setTenantId(item.getTenantId());
                        userInfos.setTenantsid(tenantIdSid);
                        userInfos.setTenantName(tenantName);
                        userInfos.setUserId(item.getUserId());
                        userInfos.setUserName(item.getUserId());
                        createCommandSetsDto.setUserInfos((List)ListUtil.toList((Object[])new UserInfos[]{userInfos}));
                        this.skcService.createCommandBrush(createCommandSetsDto);
                    }
                    ++pageNum;
                    log.info("\u5df2\u8fc1\u79fb{}\u6761\u6570\u636e", (Object)(totalMigrated += (long)questionItems.size()));
                }
            }
            catch (Exception e) {
                log.error("BrushAssistantQuestionComponent.question.brush.error,assistant={}", (Object)JSONUtil.toJsonStr((Object)fusionAssistant), (Object)e);
            }
            log.info("assistantId={},\u5e38\u7528\u8bed\u5df2\u540c\u6b65\u5b8c\u6210", (Object)fusionAssistant.getAssistantId());
        }
        log.info("BrushAssistantQuestionComponent.question.finished");
    }

    private List<FusionAssistantSub> findBrushQuestAssistant(String assistantId) {
        Criteria criteria = new Criteria();
        if (StrUtil.isNotBlank((CharSequence)assistantId)) {
            criteria.and("assistantId").is((Object)assistantId);
        }
        criteria.and("version").is((Object)"1.0");
        return this.fusionAssistantSubMgDao.findList(new Query((CriteriaDefinition)criteria));
    }
}

