/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.brush;

import com.digiwin.athena.ania.aspect.Lock;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.mongo.domain.ApplicationAssistantRelation;
import com.digiwin.athena.ania.mongo.repository.AppAssistantRelationDao;
import com.digiwin.athena.ania.mongo.repository.AssistantMgDao;
import com.digiwin.athena.ania.mongo.repository.ConversationDao;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantMgDao;
import com.mongodb.client.result.UpdateResult;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class RemoveOrRestoreAssistantComponent {
    private static final Logger log = LoggerFactory.getLogger(RemoveOrRestoreAssistantComponent.class);
    @Resource
    private FusionAssistantMgDao fusionAssistantMgDao;
    @Resource
    private AssistantMgDao assistantMgDao;
    @Resource
    private ConversationDao conversationDao;
    @Resource
    private AppAssistantRelationDao appAssistantRelationDao;

    @Lock(key="", expire=30000L)
    public void remove(String assistantId) {
        UpdateResult updateResult;
        ApplicationAssistantRelation assistantRelation = (ApplicationAssistantRelation)this.appAssistantRelationDao.findOne(new Query((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId)));
        if (Objects.isNull(assistantRelation)) {
            return;
        }
        Integer assistantType = assistantRelation.getAssistantType();
        if (Objects.equals(AssistantType.HISTORY_ASSISTANT.getType(), assistantType)) {
            UpdateResult updateResult2 = this.assistantMgDao.update(new Query((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)assistantId).and("status").is((Object)1)), new Update().set("status", (Object)0));
            if (updateResult2.getMatchedCount() > 0L) {
                this.conversationDao.update(new Query((CriteriaDefinition)Criteria.where((String)"agentId").is((Object)assistantId).and("status").is((Object)1)), new Update().set("isAvailable", (Object)false));
            }
        } else if (Objects.equals(AssistantType.PUBLISH_ASSISTANT.getType(), assistantType) && (updateResult = this.fusionAssistantMgDao.update(new Query((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId).and("isAvailable").is((Object)true)), new Update().set("isAvailable", (Object)false))).getMatchedCount() > 0L) {
            this.conversationDao.update(new Query((CriteriaDefinition)Criteria.where((String)"agentId").is((Object)assistantId).and("status").is((Object)1)), new Update().set("isAvailable", (Object)false));
        }
    }

    @Lock(key="", expire=30000L)
    public void restore(String assistantId) {
        UpdateResult updateResult;
        ApplicationAssistantRelation assistantRelation = (ApplicationAssistantRelation)this.appAssistantRelationDao.findOne(new Query((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId)));
        if (Objects.isNull(assistantRelation)) {
            return;
        }
        Integer assistantType = assistantRelation.getAssistantType();
        if (Objects.equals(AssistantType.HISTORY_ASSISTANT.getType(), assistantType)) {
            UpdateResult updateResult2 = this.assistantMgDao.update(new Query((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)assistantId).and("status").is((Object)0)), new Update().set("status", (Object)1));
            if (updateResult2.getMatchedCount() > 0L) {
                this.conversationDao.update(new Query((CriteriaDefinition)Criteria.where((String)"agentId").is((Object)assistantId)), new Update().set("isAvailable", (Object)true));
            }
        } else if (Objects.equals(AssistantType.PUBLISH_ASSISTANT.getType(), assistantType) && (updateResult = this.fusionAssistantMgDao.update(new Query((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId).and("isAvailable").is((Object)false)), new Update().set("isAvailable", (Object)true))).getMatchedCount() > 0L) {
            this.conversationDao.update(new Query((CriteriaDefinition)Criteria.where((String)"agentId").is((Object)assistantId)), new Update().set("isAvailable", (Object)true));
        }
    }
}

