/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.gmc.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.SceneTypeEnum;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.dto.dialogue.FusionHistoryAssistantVo;
import com.digiwin.athena.ania.dto.gmc.GmcBulletinResultDTO;
import com.digiwin.athena.ania.dto.gmc.GmcBulletinUnReadResultDTO;
import com.digiwin.athena.ania.dto.gmc.GmcBulletinUnReadSaveDTO;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.GmcHelper;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.mapper.mysql.EchoBulletinReadRecordMapper;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mysql.domain.EchoBulletinReadRecord;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.gmc.EchoGmcService;
import com.digiwin.athena.ania.util.SystemLanguageUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EchoGmcServiceImpl
implements EchoGmcService {
    private static final Logger log = LoggerFactory.getLogger(EchoGmcServiceImpl.class);
    @Autowired
    private GmcHelper gmcHelper;
    @Resource
    private IamHelper iamHelper;
    @Resource
    private KmHelper kmHelper;
    @Resource
    private CacHelper cacHelper;
    @Autowired
    private EchoBulletinReadRecordMapper bulletinReadRecordMapper;
    @Autowired
    private AssistantService assistantService;
    @Autowired
    private FusionAssistantService fusionAssistantService;

    public List<GmcBulletinResultDTO> queryReadBulletinList(String appCode, AuthoredUser user, Integer pageNum, Integer pageSize) {
        if (user == null) {
            user = AppAuthContextHolder.getContext().getAuthoredUser();
        }
        String token = user.getToken();
        String tenantId = user.getTenantId();
        String userId = user.getUserId();
        List bulletinAppCodes = this.getBulletinAppCodes(appCode, tenantId, token);
        if (bulletinAppCodes.isEmpty()) {
            log.warn("\u5df2\u8bfb\u516c\u544a:\u7528\u6237\u65e0\u4efb\u4f55\u52a9\u7406\u5e94\u7528\u6743\u9650");
            return Collections.emptyList();
        }
        List bulletinList = this.queryBulletinList(user, bulletinAppCodes, pageNum, pageSize);
        List agileDataBulletinReadRecords = this.bulletinReadRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EchoBulletinReadRecord::getTenantId, (Object)tenantId)).eq(EchoBulletinReadRecord::getUserId, (Object)userId));
        Set readSids = agileDataBulletinReadRecords.stream().map(EchoBulletinReadRecord::getSid).collect(Collectors.toSet());
        bulletinList.forEach(bulletin -> {
            if (!readSids.contains(bulletin.getSid())) {
                this.bulletinReadRecordMapper.insert((Object)new EchoBulletinReadRecord(userId, tenantId, bulletin.getSid()));
            }
            bulletin.setIsRead(Boolean.valueOf(true));
        });
        return bulletinList;
    }

    @NotNull
    private List<String> getBulletinAppCodes(String appCode, String tenantId, String token) {
        List<String> bulletinAppCodes = new ArrayList<String>();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        FusionAssistantInfoDto param = FusionAssistantInfoDto.builder().assistantId(appCode).auth(Boolean.valueOf(false)).build();
        FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(param, authoredUser);
        if (Objects.isNull(fusionAssistantVo)) {
            return new ArrayList<String>();
        }
        String tenantVersion = this.kmHelper.getTenantVersion(tenantId);
        if (fusionAssistantVo.getAssistantType() == AssistantType.PUBLISH_ASSISTANT.getType()) {
            return ListUtil.toList((Object[])new String[]{fusionAssistantVo.getAssistantId()});
        }
        if (fusionAssistantVo.getAssistantType() == AssistantType.HISTORY_ASSISTANT.getType()) {
            FusionHistoryAssistantVo fusionHistoryAssistantVo = (FusionHistoryAssistantVo)fusionAssistantVo;
            if (AssistantSubTypeEnum.DATA.getType().equals(fusionAssistantVo.getAssistantSubType())) {
                bulletinAppCodes = this.getAutheredDataApp(tenantId, token, null);
            } else if (AssistantSubTypeEnum.KNOWLEAGE.getType().equals(fusionHistoryAssistantVo.getAssistantSubType())) {
                bulletinAppCodes.add(appCode);
                if ("public".equals(fusionHistoryAssistantVo.getKnowledgeType())) {
                    List assistantSceneList = this.assistantService.getAssistantSceneByAssistant(appCode, tenantVersion);
                    bulletinAppCodes.addAll(this.getAutheredKBS(token, assistantSceneList));
                }
            } else if (AssistantSubTypeEnum.BUSINESS.getType().equals(fusionHistoryAssistantVo.getAssistantSubType())) {
                bulletinAppCodes.add(appCode);
            } else if (AssistantSubTypeEnum.COMPOSITE.getType().equals(fusionHistoryAssistantVo.getAssistantSubType())) {
                bulletinAppCodes.add(appCode);
                List assistantSceneList = this.assistantService.getAssistantSceneByAssistant(appCode, tenantVersion);
                ArrayList<AssistantScene> publicKbsSceneList = new ArrayList<AssistantScene>();
                ArrayList<AssistantScene> agileDataSceneList = new ArrayList<AssistantScene>();
                for (AssistantScene assistantScene : assistantSceneList) {
                    if (SceneTypeEnum.KNOWLEDGE.getType().equals(assistantScene.getType()) && "public".equals(assistantScene.getKnowledgeBase().getString("type"))) {
                        publicKbsSceneList.add(assistantScene);
                        continue;
                    }
                    if (!SceneTypeEnum.DATA.getType().equals(assistantScene.getType())) continue;
                    agileDataSceneList.add(assistantScene);
                }
                if (!publicKbsSceneList.isEmpty()) {
                    bulletinAppCodes.addAll(this.getAutheredKBS(token, publicKbsSceneList));
                }
                if (!agileDataSceneList.isEmpty()) {
                    bulletinAppCodes.addAll(this.getAutheredDataApp(tenantId, token, agileDataSceneList));
                }
            }
        }
        return bulletinAppCodes;
    }

    private List<String> getAutheredDataApp(String tenantId, String token, List<AssistantScene> agileDataSceneList) {
        ArrayList<String> bulletinAppCodes = new ArrayList<String>();
        List<Object> autheredAppCodes = new ArrayList();
        List tenantAgileDataApplications = this.kmHelper.queryTenantAgileDataApplication(token, tenantId);
        if (!CollectionUtils.isEmpty((Collection)tenantAgileDataApplications)) {
            autheredAppCodes = tenantAgileDataApplications.stream().map(app -> app.get("code").toString()).collect(Collectors.toList());
        } else {
            log.warn("\u5df2\u8bfb\u516c\u544a:\u5f53\u524d\u7528\u6237\u672a\u8d2d\u4e70\u654f\u6377\u6570\u636e\u5e94\u7528");
        }
        if (null == agileDataSceneList || agileDataSceneList.isEmpty()) {
            bulletinAppCodes = autheredAppCodes;
        } else {
            for (AssistantScene agileDataScene : agileDataSceneList) {
                if (!autheredAppCodes.contains(agileDataScene.getDataMetric().getString("application"))) continue;
                bulletinAppCodes.add(agileDataScene.getDataMetric().getString("application"));
            }
        }
        return bulletinAppCodes;
    }

    private List<String> getAutheredKBS(String userToken, List<AssistantScene> assistantSceneList) {
        ArrayList<String> autheredKbsCodes = new ArrayList();
        ResponseEntity curentApps = this.cacHelper.getCurentApps(userToken);
        log.info("EchoGmcServiceImpl#getAutheredKBS#curentApps:{}", (Object)curentApps);
        JSONObject body = JSONObject.parseObject((String)((String)curentApps.getBody()));
        log.info("EchoGmcServiceImpl#getAutheredKBS#cacBody:{}", (Object)body);
        List mapList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)body.get((Object)"data")), Map.class);
        List curentAppList = mapList.stream().filter(item -> !"Athena".equals(MapUtils.getString((Map)item, (Object)"id"))).map(item -> (String)item.get("id")).collect(Collectors.toList());
        HashMap<String, Map> maps = new HashMap<String, Map>();
        block0: for (Map map : mapList) {
            for (String code : curentAppList) {
                if (!code.equals(MapUtils.getString((Map)map, (Object)"id"))) continue;
                maps.put(code, map);
                continue block0;
            }
        }
        Iterator<AssistantScene> iterator = assistantSceneList.iterator();
        while (iterator.hasNext()) {
            AssistantScene next = iterator.next();
            String assistantSceneCode = next.getCode();
            if (curentAppList.contains(assistantSceneCode)) {
                Map map = (Map)maps.get(assistantSceneCode);
                DateTime expiredTime = DateUtil.parseDate((CharSequence)MapUtils.getString((Map)map, (Object)"expiredTime"));
                if (!expiredTime.before(new Date())) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        autheredKbsCodes = assistantSceneList.stream().map(scene -> scene.getCode()).collect(Collectors.toList());
        return autheredKbsCodes;
    }

    public GmcBulletinUnReadResultDTO queryUnreadBulletinList(String appCode, AuthoredUser user, Integer pageNum, Integer pageSize) {
        if (user == null) {
            user = AppAuthContextHolder.getContext().getAuthoredUser();
        }
        String token = user.getToken();
        String tenantId = user.getTenantId();
        String userId = user.getUserId();
        List bulletinAppCodes = this.getBulletinAppCodes(appCode, tenantId, token);
        if (bulletinAppCodes.isEmpty()) {
            log.warn("\u672a\u8bfb\u516c\u544a:\u7528\u6237\u65e0\u4efb\u4f55\u52a9\u7406\u5e94\u7528\u6743\u9650");
            return null;
        }
        List bulletinList = this.queryBulletinList(user, bulletinAppCodes, pageNum, pageSize);
        GmcBulletinUnReadResultDTO gmcBulletinUnReadResultDTO = new GmcBulletinUnReadResultDTO();
        List agileDataBulletinReadRecords = this.bulletinReadRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EchoBulletinReadRecord::getTenantId, (Object)tenantId)).eq(EchoBulletinReadRecord::getUserId, (Object)userId));
        if (!CollectionUtils.isEmpty((Collection)agileDataBulletinReadRecords)) {
            bulletinList.removeIf(bulletin -> agileDataBulletinReadRecords.stream().anyMatch(record -> record.getSid().equals(bulletin.getSid())));
        }
        gmcBulletinUnReadResultDTO.setCount(Integer.valueOf(bulletinList.size()));
        gmcBulletinUnReadResultDTO.setBulletinList(bulletinList);
        return gmcBulletinUnReadResultDTO;
    }

    public Boolean saveReadBulletin(AuthoredUser user, GmcBulletinUnReadSaveDTO saveDTO) {
        try {
            this.bulletinReadRecordMapper.insertBatch(user.getUserId(), user.getTenantId(), saveDTO.getSidList());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5df2\u8bfb\u516c\u544a\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private List<GmcBulletinResultDTO> queryBulletinList(AuthoredUser user, List<String> codes, Integer pageNum, Integer pageSize) {
        String traditional;
        if (user == null) {
            user = AppAuthContextHolder.getContext().getAuthoredUser();
        }
        String token = user.getToken();
        String tenantId = user.getTenantId();
        String userId = user.getUserId();
        List bulletins = this.gmcHelper.queryBulletinList(token, tenantId, codes, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)bulletins)) {
            log.warn("\u5f53\u524d\u7528\u6237\u672a\u67e5\u8be2\u5230\u516c\u544a\u5217\u8868,codes:{},user:{}", codes, (Object)JsonUtils.objectToString((Object)user));
            return Collections.emptyList();
        }
        Comparator tComparator = Comparator.reverseOrder();
        bulletins.sort((o1, o2) -> tComparator.compare(o1.getUpdateTime(), o2.getUpdateTime()));
        try {
            String locale = this.iamHelper.getAthenaUserLanguage(token, userId);
            traditional = Locale.TAIWAN.toString().equals(locale) ? SystemLanguageUtils.toTraditional((String)JsonUtils.objectToString((Object)bulletins)) : SystemLanguageUtils.toSimple((String)JsonUtils.objectToString((Object)bulletins));
        }
        catch (Exception e) {
            throw new ServiceException(Integer.valueOf(500), e.getMessage());
        }
        return (List)JsonUtils.jsonToObject((String)traditional, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }
}

