/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.helper.im.ImTypeHandlerStrategy;
import com.digiwin.athena.ania.service.IntentTypeHandler;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AdministrativeAffairesTypeHandler
implements IntentTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(AdministrativeAffairesTypeHandler.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ImTypeHandlerStrategy imTypeHandlerStrategy;
    @Autowired
    private IamHelper iamHelper;
    private static final String PROCESS_MSG_TO_ASA_URL = "/asa/message/athena/processMessage";
    private static final String GUIDE_SENTENCE = "\u4f60\u7684\u95ee\u9898\u884c\u653f\u52a9\u7406\u5a1c\u5a1c\u6682\u4e0d\u652f\u6301\u89e3\u51b3\uff0c\u8bf7\u5207\u6362\u5230\u5bf9\u5e94\u52a9\u7406\u518d\u8be2\u95ee";
    @Value(value="${openfire.msgDomain}")
    private String msgDomain;

    public String getIntentType() {
        return "3";
    }

    public void handler(UserMessageActionContext userMessageActionContext) throws Exception {
        this.processMessage(userMessageActionContext);
    }

    private void processMessage(UserMessageActionContext userMessageActionContext) {
        JSONObject msgBody = userMessageActionContext.getImMessageLog().getMsgBody();
        String msgidServer = userMessageActionContext.getImMessageLog().getMsgidServer();
        String msgType = userMessageActionContext.getImMessageLog().getMsgType();
        JSONObject attachInfo = new JSONObject();
        JSONObject msgExt = userMessageActionContext.getImMessageLog().getMsgExt();
        JSONObject msg = new JSONObject();
        msg.put("msgidServer", (Object)msgidServer);
        msg.put("msgType", (Object)msgType);
        msg.put("msgBody", (Object)msgBody);
        msg.put("attachInfo", (Object)attachInfo);
        msg.put("msgExt", (Object)msgExt);
        msg.put("msgTimestamp", (Object)userMessageActionContext.getImMessageLog().getMsgTimestamp());
        msg.put("msgidClient", (Object)userMessageActionContext.getImMessageLog().getMsgidClient());
        msg.put("fromClientType", (Object)userMessageActionContext.getImMessageLog().getFromClientType());
        HttpHeaders httpHeaders = new HttpHeaders();
        String userToken = msgExt.getString("token");
        httpHeaders.set("digi-middleware-auth-user", userToken);
        httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HttpEntity httpEntity = new HttpEntity((Object)msg, (MultiValueMap)httpHeaders);
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.envProperties.getAsaUri());
        sbUrl.append(PROCESS_MSG_TO_ASA_URL);
        log.info("\u5f00\u59cb\u8c03\u7528C\u5a1c\u63a5\u53e3\u63a8\u9001\u6d88\u606f\u5230C\u5a1c\uff0curl:{}", (Object)sbUrl.toString());
        log.info("params\uff1a{}", (Object)JSON.toJSONString((Object)msg));
        ResponseEntity responseEntity = this.restTemplate.exchange(sbUrl.toString(), HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)msg);
        if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
            log.info("\u8c03\u7528C\u5a1c\u63a5\u53e3\u63a8\u9001\u6d88\u606f\u5230C\u5a1c\u5931\u8d25 code:{}", (Object)responseEntity.getStatusCodeValue());
            return;
        }
        log.info("\u8c03\u7528C\u5a1c\u884c\u653f\u52a9\u7406\u63a5\u53e3\u63a8\u9001\u6d88\u606f\u5230\u884c\u653f\u52a9\u7406\u63a5\u53e3\u6210\u529f,\u8fd4\u56de\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)responseEntity));
        JSONObject responseBody = (JSONObject)responseEntity.getBody();
        JSONObject map = responseBody.getJSONObject("data");
        String resultType = (String)map.get("resultType");
        if ("NOTSUPPORT".equals(resultType)) {
            String lagauage = this.iamHelper.getAthenaUserLanguage(userToken, MapUtils.getString((Map)msgExt, (Object)"userId"));
            log.info("\u8bed\u8a00\u522b\u4e3a\uff1a{}", (Object)lagauage);
            String guideSentence = null;
            if (LocalsEnum.TW.getCode().equals(lagauage)) {
                guideSentence = "\u4f60\u7684\u554f\u984c\u884c\u653f\u52a9\u7406\u5a1c\u5a1c\u66ab\u4e0d\u652f\u63f4\u89e3\u6c7a\uff0c\u8acb\u5207\u63db\u5230\u5c0d\u61c9\u52a9\u7406\u518d\u8a62\u554f";
            } else if (LocalsEnum.CN.getCode().equals(lagauage)) {
                guideSentence = GUIDE_SENTENCE;
            }
            String accId = userMessageActionContext.getImMessageLog().getFromAccount();
            this.imTypeHandlerStrategy.handler(this.envProperties.getSupplierType(), accId, (Object)guideSentence, "3", msgExt, this.msgDomain);
        }
    }
}

