/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl;

import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.service.IntentTypeHandler;
import com.digiwin.athena.ania.service.impl.bnaProcessor.BnaProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BnaAssistantHandler
implements IntentTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(BnaAssistantHandler.class);
    private Map<Integer, BnaProcessor> assistantTypeStrategyMap = new HashMap();

    @Autowired
    public void setAssistantTypeStrategyMap(Map<String, BnaProcessor> bnaProcessorMap) {
        bnaProcessorMap.forEach((k, v) -> this.assistantTypeStrategyMap.put(v.getAssistantSubType(), v));
    }

    public String getIntentType() {
        return "";
    }

    public void handler(UserMessageActionContext userMessageActionContext) {
        ImMessageLog imMessageLog = userMessageActionContext.getImMessageLog();
        Assistant assistant = imMessageLog.getAssistant();
        Integer assistantSubType = assistant.getAssistantSubType();
        BnaProcessor bnaProcessor = (BnaProcessor)this.assistantTypeStrategyMap.get(assistantSubType);
        if (Objects.nonNull(bnaProcessor)) {
            bnaProcessor.execute(userMessageActionContext);
        }
    }
}

