/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.AtzMessageDto;
import com.digiwin.athena.ania.dto.FromDto;
import com.digiwin.athena.ania.dto.ImConversationMsgDto;
import com.digiwin.athena.ania.dto.ToDto;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.knowledge.server.dto.SendMqYunxinMsg;
import com.digiwin.athena.ania.mapper.mongo.MessageMongoMapper;
import com.digiwin.athena.ania.service.IGptService;
import com.digiwin.athena.ania.service.ImService;
import com.digiwin.athena.ania.service.MessageSeachService;
import com.digiwin.athena.ania.service.MessageService;
import com.digiwin.athena.ania.service.NewConversationService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ImServiceImpl
implements ImService {
    private static final Logger log = LoggerFactory.getLogger(ImServiceImpl.class);
    @Autowired
    private IGptService iGptService;
    @Autowired
    private MessageMongoMapper messageMongoMapper;
    @Autowired
    private MessageService messageService;
    @Resource
    private MessageSeachService messageSeachService;
    @Autowired
    private NewConversationService newConversationService;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Value(value="${yunxin.businessLogQueueName}")
    private String businessLogQueueName;
    @Value(value="${yunxin.troubleshootMqOpen}")
    private boolean troubleshootMqOpen;

    public void singleChatReceive(ImConversationMsgDto message) throws IOException {
        message.setExt(JSONObject.toJSONString((Object)JSONObject.parseObject((String)message.getExt()).fluentPut("userId", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId())));
        ImMessageLog imMessageLog = new ImMessageLog(message);
        try {
            JSONObject jsonObject;
            JSONObject jSONObject = jsonObject = Objects.isNull(imMessageLog.getMsgExt()) ? new JSONObject() : imMessageLog.getMsgExt();
            if (message.getCustomerAccId().equals(message.getTo()) && !Objects.equals(2, message.getAssistantSubType()) && !Objects.equals("301", jsonObject.getString("messageType"))) {
                this.iGptService.dialogueToGpt(imMessageLog);
            }
            if (message.getCustomerAccId().equals(message.getTo()) && Objects.equals(3, message.getAssistantSubType()) && BooleanUtils.isFalse((Boolean)imMessageLog.getAssistant().getSourceCustom()) && !Objects.equals("301", jsonObject.getString("messageType"))) {
                this.extAction(imMessageLog);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
            return;
        }
        this.messageMongoMapper.message(imMessageLog);
        this.messageSeachService.enterSearch(imMessageLog);
    }

    private void extAction(ImMessageLog imMessageLog) {
        try {
            SendMqYunxinMsg message = new SendMqYunxinMsg();
            message.setFrom(imMessageLog.getFromAccount());
            message.setTo(imMessageLog.getToAccount());
            message.setMsgExt(imMessageLog.getMsgExt());
            message.setAssistantCode(imMessageLog.getAssistant().getAssistantCode());
            this.newConversationService.newConversationMg(message);
        }
        catch (Exception e) {
            log.error("MqReceiver.extAction is error message:{}", (Object)JSON.toJSONString((Object)imMessageLog), (Object)e);
        }
    }

    public void handlerAtzMessage(AtzMessageDto atzMessageDto, String token, String routerKey) {
        FromDto from = atzMessageDto.getFrom();
        ToDto to = atzMessageDto.getTo();
        String userId = from.getUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            String userId1 = to.getUserId();
            if (StringUtils.isBlank((CharSequence)userId1)) {
                this.messageService.sendMessageForAtz(atzMessageDto, token, routerKey);
            } else {
                log.info("\u4eba\u53d1\u7ed9\u4eba");
            }
        } else {
            String userId1 = to.getUserId();
            if (StringUtils.isBlank((CharSequence)userId1)) {
                log.info("\u52a9\u7406\u53d1\u7ed9\u52a9\u7406");
            } else {
                log.info("\u52a9\u7406\u53d1\u7ed9\u4eba");
            }
        }
    }
}

