/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.enums.SupplierTypeEnum;
import com.digiwin.athena.ania.dto.AtzMessageDto;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.entity.im.ImSessionMsgLog;
import com.digiwin.athena.ania.entity.im.ImSingleChatQuery;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.AgoraImHelper;
import com.digiwin.athena.ania.helper.ImHelper;
import com.digiwin.athena.ania.helper.YunXinImHelper;
import com.digiwin.athena.ania.helper.im.ImTypeHandlerStrategy;
import com.digiwin.athena.ania.mapper.mongo.MessageMongoMapper;
import com.digiwin.athena.ania.mapper.mongo.MessageSearchMongoMapper;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.service.MessageService;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private ImHelper imHelper;
    @Autowired
    private MessageMongoMapper messageMongoMapper;
    @Autowired
    private ImTypeHandlerStrategy imTypeHandlerStrategy;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private YunXinImHelper yunXinImHelper;
    @Autowired
    private AgoraImHelper agoraImHelper;
    @Autowired
    private AssistantService assistantService;
    @Resource
    private MessageSearchMongoMapper messageSearchMongoMapper;
    @Value(value="${openfire.msgDomain}")
    private String msgDomain;
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;

    public ResultBean sendMessage(Map mapParam, AuthoredUser authoredUser) {
        try {
            Map msgExt = null;
            msgExt = null != mapParam.get("msgExt") ? (Map)mapParam.get("msgExt") : new HashMap();
            String proxyToken = (String)mapParam.get("proxyToken");
            String targetTenantId = (String)mapParam.get("targetTenantId");
            String userId = (String)mapParam.get("userId");
            String msgType = (String)mapParam.get("msgType");
            String skillType = (String)mapParam.get("skillType");
            String asaCode = msgExt.getOrDefault("asaCode", "").toString();
            Map user = this.imHelper.getAccidFromIm(targetTenantId, userId, authoredUser);
            String accid = (String)user.get("accid");
            userId = (String)user.get("userId");
            JSONObject jsonObjectMsgExt = JSONObject.parseObject((String)JSON.toJSONString(msgExt));
            jsonObjectMsgExt.fluentPut("userId", (Object)userId);
            jsonObjectMsgExt.put("proxyToken", (Object)proxyToken);
            jsonObjectMsgExt.put("targetTenantId", (Object)targetTenantId);
            if (!jsonObjectMsgExt.containsKey((Object)"routerKey")) {
                jsonObjectMsgExt.put("routerKey", (Object)authoredUser.getTenantId());
            }
            if (!jsonObjectMsgExt.containsKey((Object)"token")) {
                jsonObjectMsgExt.put("token", (Object)authoredUser.getToken());
            }
            String assistantAccount = StrUtil.isNotBlank((CharSequence)asaCode) ? this.assistantService.getAssistantAccount(asaCode) : this.assistantService.getAssistantAccount(skillType);
            MDC.put((String)"serverAccid", (String)assistantAccount);
            if (msgType.equals(ImConstants.ImMsgTypeEnum.TEXT.getTypeChar()) || msgType.equals("txt")) {
                Map msgBody = (Map)mapParam.get("msgBody");
                String text = (String)msgBody.get("text");
                return this.imTypeHandlerStrategy.handler(this.envProperties.getSupplierType(), accid, (Object)text, skillType, jsonObjectMsgExt, this.msgDomain);
            }
            if (msgType.equals(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar()) || msgType.equals(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar().toLowerCase())) {
                Map msgBody = (Map)mapParam.get("msgBody");
                JSONObject message = JSONObject.parseObject((String)JSONObject.toJSONString((Object)msgBody));
                return this.imTypeHandlerStrategy.handler(this.envProperties.getSupplierType(), accid, (Object)message, skillType, jsonObjectMsgExt, this.msgDomain);
            }
        }
        catch (Exception e) {
            log.error("sendMessage exception,errMsg:{}", (Object)e.getMessage(), (Object)e);
            return new ResultBean(Integer.valueOf(500), Integer.valueOf(500), "\u53d1\u9001\u6d88\u606f\u5931\u8d25");
        }
        return ResultBean.success(null);
    }

    public List<ImMessageLog> latelyMessage(Map mapParam, AuthoredUser user) {
        String targetTenantId = (String)mapParam.get("targetTenantId");
        String userId = (String)mapParam.get("userId");
        String skillType = (String)mapParam.get("skillType");
        String asaCode = (String)mapParam.get("asaCode");
        String sessionId = MapUtils.getString((Map)mapParam, (Object)"sessionId");
        Map map = Maps.newHashMap();
        try {
            map = this.imHelper.getAccidFromIm(targetTenantId, userId, user);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e91\u4fe1\u8d26\u6237\u51fa\u9519:{}", (Object)e.getMessage());
            return new ArrayList<ImMessageLog>();
        }
        String assistantAccount = (String)map.get("accid");
        if (StrUtil.isNotBlank((CharSequence)asaCode)) {
            assistantAccount = this.assistantService.getAssistantAccount(asaCode);
        } else if (StringUtils.isNotBlank((CharSequence)skillType)) {
            assistantAccount = this.assistantService.getAssistantAccount(skillType);
        }
        List imMessageLogList = this.messageMongoMapper.getLatestMessages((String)map.get("accid"), (Integer)mapParam.get("num"), assistantAccount, sessionId);
        this.imMessageFillAnswer(imMessageLogList);
        return imMessageLogList;
    }

    private void imMessageFillAnswer(List<ImMessageLog> imMessageLogList) {
        if (CollUtil.isNotEmpty(imMessageLogList)) {
            imMessageLogList.forEach(im -> {
                JSONObject msgExt;
                String contentId;
                if (ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar().equals(im.getMsgType()) && StringUtils.isNotBlank((CharSequence)(contentId = (msgExt = im.getMsgExt()).getString("contentId")))) {
                    AsaKnowledgeMessage asaKnowledgeMessage = this.asaKnowledgeMessageDao.findById((Object)contentId).orElse(null);
                    im.setAnswerWrapper(asaKnowledgeMessage);
                }
            });
        }
    }

    public List<ImMessageLog> queryMessageById(List<String> msgidServers) {
        List imMessageLogList = this.messageMongoMapper.queryMessageByIds(msgidServers);
        return imMessageLogList;
    }

    public ResultBean sendMessageForAtz(AtzMessageDto atzMessageDto, String token, String routerKey) {
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setToken(token);
        try {
            String targetTenantId = atzMessageDto.getFrom().getTargetTenantId();
            String userId = atzMessageDto.getFrom().getUserId();
            String msgType = atzMessageDto.getMsgType();
            String skillType = atzMessageDto.getSkillType();
            Map user = this.imHelper.getAccidFromIm(targetTenantId, userId, authoredUser);
            String accid = (String)user.get("accid");
            String assistantAccount = this.assistantService.getAssistantAccount(skillType);
            MDC.put((String)"serverAccid", (String)assistantAccount);
            if (!this.envProperties.getSupplierType().equals(SupplierTypeEnum.AGORA.getValue())) {
                if (msgType.equals(ImConstants.ImMsgTypeEnum.TEXT.getTypeChar()) || msgType.equals("txt")) {
                    JSONObject msgBody = atzMessageDto.getMsgBody();
                    String text = (String)msgBody.get("text");
                    JSONObject msgExt = atzMessageDto.getMsgExt();
                    msgExt.fluentPut("userId", (Object)userId);
                    msgExt.fluentPut("token", (Object)token);
                    msgExt.fluentPut("routerKey", (Object)routerKey);
                    msgExt.fluentPut("skillType", (Object)skillType);
                    return this.yunXinImHelper.pushMessageNew(accid, MDC.get((String)"serverAccid"), text, skillType, msgExt);
                }
                if (msgType.equals(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar()) || msgType.equals(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar().toLowerCase())) {
                    JSONObject msgBody = atzMessageDto.getMsgBody();
                    JSONObject message = JSONObject.parseObject((String)JSONObject.toJSONString((Object)msgBody));
                    JSONObject msgExt = atzMessageDto.getMsgExt();
                    msgExt.fluentPut("userId", (Object)userId);
                    msgExt.fluentPut("token", (Object)token);
                    msgExt.fluentPut("routerKey", (Object)routerKey);
                    msgExt.fluentPut("skillType", (Object)skillType);
                    this.yunXinImHelper.pushCustomMessageNew(accid, MDC.get((String)"serverAccid"), message, skillType, msgExt);
                }
            } else {
                if (msgType.equals(ImConstants.ImMsgTypeEnum.TEXT.getTypeChar()) || msgType.equals("txt")) {
                    JSONObject msgBody = atzMessageDto.getMsgBody();
                    String text = (String)msgBody.get("text");
                    JSONObject msgExt = atzMessageDto.getMsgExt();
                    msgExt.fluentPut("userId", (Object)userId);
                    msgExt.fluentPut("token", (Object)token);
                    msgExt.fluentPut("routerKey", (Object)routerKey);
                    msgExt.fluentPut("skillType", (Object)skillType);
                    return this.agoraImHelper.handlerNew(accid, MDC.get((String)"serverAccid"), (Object)text, skillType, msgExt);
                }
                if (msgType.equals(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar()) || msgType.equals(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar().toLowerCase())) {
                    JSONObject msgBody = atzMessageDto.getMsgBody();
                    JSONObject message = JSONObject.parseObject((String)JSONObject.toJSONString((Object)msgBody));
                    JSONObject msgExt = atzMessageDto.getMsgExt();
                    msgExt.fluentPut("userId", (Object)userId);
                    msgExt.fluentPut("token", (Object)token);
                    msgExt.fluentPut("routerKey", (Object)routerKey);
                    msgExt.fluentPut("skillType", (Object)skillType);
                    this.agoraImHelper.handlerNew(accid, MDC.get((String)"serverAccid"), (Object)message, skillType, msgExt);
                }
            }
        }
        catch (Exception e) {
            return new ResultBean(Integer.valueOf(500), Integer.valueOf(500), "\u53d1\u9001\u6d88\u606f\u5931\u8d25");
        }
        return ResultBean.success(null);
    }

    public ResultBean searchMessage(Map mapParam, AuthoredUser authoredUser) {
        JSONObject object = new JSONObject();
        Map user = this.imHelper.getAccidFromIm(null, null, authoredUser);
        String accid = (String)user.get("accid");
        if (StringUtils.isBlank((CharSequence)accid)) {
            return ResultBean.success((Integer)0, Collections.emptyList());
        }
        Integer page = MapUtils.getInteger((Map)mapParam, (Object)"page");
        Long messageCount = 0L;
        if (Objects.nonNull(page) && page == 1) {
            messageCount = this.messageSearchMongoMapper.countMessage(mapParam, accid);
        }
        List messageSearchList = this.messageSearchMongoMapper.searchMessage(mapParam, accid);
        object.fluentPut("total", (Object)messageCount);
        object.fluentPut("page", (Object)MapUtils.getIntValue((Map)mapParam, (Object)"page"));
        object.fluentPut("rows", (Object)MapUtils.getIntValue((Map)mapParam, (Object)"rows"));
        object.fluentPut("data", (Object)messageSearchList);
        return ResultBean.success((Integer)0, (Object)object);
    }

    public List<ImSessionMsgLog> queryLatestMsg(String from, String to, Integer limit) {
        try {
            ImSingleChatQuery query = new ImSingleChatQuery();
            query.setFrom(from);
            query.setTo(to);
            query.setBeginTime(0L);
            query.setEndTime(System.currentTimeMillis());
            query.setLimit(limit.intValue());
            query.setReverse(Boolean.valueOf(false));
            return this.yunXinImHelper.singleChatQuery(query);
        }
        catch (IOException e) {
            log.error("SseEmitterCallbackComponent.queryLatestMsg error", (Throwable)e);
            return null;
        }
    }
}

