/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.agora.AgoraResponseDTO;
import com.digiwin.athena.ania.dto.agora.ImportMessageRequestDTO;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.entity.MigrateMessageMapping;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.AgoraImHelper;
import com.digiwin.athena.ania.mapper.mongo.MessageMongoMapper;
import com.digiwin.athena.ania.mapper.mongo.MigrateMessageMapper;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.service.IMigrateMessageService;
import com.digiwin.athena.ania.util.RedisRateLimiter;
import com.digiwin.athena.ania.util.RedisUtils;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MigrateMessageServiceImpl
implements IMigrateMessageService {
    private static final Logger log = LoggerFactory.getLogger(MigrateMessageServiceImpl.class);
    @Autowired
    private AgoraImHelper agoraImHelper;
    @Autowired
    private RedisRateLimiter redisRateLimiter;
    @Autowired
    private MigrateMessageMapper migrateMessageMapper;
    @Autowired
    private MessageMongoMapper messageMongoMapper;
    @Autowired
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public void asyncMigrateMessage(ImMessageLog messageLog) throws InterruptedException {
        JSONObject agoraMsg = new JSONObject();
        agoraMsg.put("from", (Object)messageLog.getFromAccount());
        agoraMsg.put("to", (Object)messageLog.getToAccount());
        agoraMsg.put("type", (Object)messageLog.getMsgType());
        agoraMsg.put("body", (Object)messageLog.getMsgBody());
        agoraMsg.put("sync_device", (Object)false);
        agoraMsg.put("ext", (Object)messageLog.getMsgExt());
        agoraMsg.put("ext.em_ignore_notification", (Object)false);
        ImportMessageRequestDTO importMessageRequestDTO = ImportMessageRequestDTO.builder().from(messageLog.getFromAccount()).target(messageLog.getToAccount()).type(messageLog.getMsgType()).body(agoraMsg).isAckRead(Boolean.valueOf(true)).msgTimestamp(messageLog.getMsgTimestamp().longValue()).needDownload(Boolean.valueOf(false)).build();
        while (true) {
            boolean isAllowed;
            if (isAllowed = this.redisRateLimiter.isAllowed("migrateMessage", 100, 1)) break;
            Thread.sleep(10L);
            log.info("\u88ab\u9650\u6d41\uff0c\u7b49\u5f85\u4e2d........");
        }
        AgoraResponseDTO agoraResponseDTO = this.agoraImHelper.buildPostRequest("https://{host}/{org_name}/{app_name}/messages/users/import", (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)importMessageRequestDTO)), "");
        log.info("\u4e91\u4fe1\u6d88\u606f\u5bfc\u5165agora\u6210\u529f,result:{}", (Object)JSONObject.toJSONString((Object)agoraResponseDTO));
    }

    public void syncMigrateMessage(ImMessageLog messageLog) {
        JSONObject body = new JSONObject();
        String type = "txt";
        if ("TEXT".equals(messageLog.getMsgType())) {
            body.put("msg", (Object)messageLog.getMsgBody().getString("text"));
        }
        if ("CUSTOM".equals(messageLog.getMsgType())) {
            type = "custom";
            body.put("customEvent", (Object)"custom_event");
            body.put("customExts", (Object)messageLog.getMsgBody());
        }
        ImportMessageRequestDTO importMessageRequestDTO = ImportMessageRequestDTO.builder().from(messageLog.getFromAccount()).target(messageLog.getToAccount()).type(type).body(body).ext(messageLog.getMsgExt()).isAckRead(Boolean.valueOf(true)).msgTimestamp(messageLog.getMsgTimestamp().longValue()).needDownload(Boolean.valueOf(false)).build();
        try {
            while (true) {
                boolean isAllowed;
                if (isAllowed = RedisUtils.isAllowed((String)"ania:migrateMessage", (int)100)) {
                    try {
                        log.info("\u5bfc\u5165\u6d88\u606f\u5f00\u59cb\uff0c\u6d88\u606f\u7684msgIdServer\uff1a{}", (Object)messageLog.getMsgidServer());
                        AgoraResponseDTO agoraResponseDTO = this.agoraImHelper.buildPostRequest("https://{host}/{org_name}/{app_name}/messages/users/import", (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)importMessageRequestDTO)), "");
                        log.info("\u5bfc\u5165\u6d88\u606f\u5b8c\u6210\uff0c\u6d88\u606f\u7684msgIdServer\uff1a{}", (Object)messageLog.getMsgidServer());
                        if (Objects.nonNull(agoraResponseDTO.getData())) {
                            String agoraMsgId = MapUtils.getString((Map)((Map)agoraResponseDTO.getData()), (Object)"msg_id");
                            MigrateMessageMapping migrateMessageMapping = MigrateMessageMapping.builder().fromAccount(messageLog.getFromAccount()).originalMsgidServer(messageLog.getMsgidServer()).newMsgidServer(agoraMsgId).createTime(Long.valueOf(System.currentTimeMillis())).build();
                            this.migrateMessageMapper.insert(migrateMessageMapping);
                            log.info("\u4fdd\u5b58MigrateMessageMapping\u5b8c\u6210\uff0cagora\u6d88\u606f\u7684msgId\uff1a{}", (Object)agoraMsgId);
                            log.info("\u4e91\u4fe1\u6d88\u606f\u5bfc\u5165agora\u6210\u529f, result:{}", (Object)agoraResponseDTO);
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("too many queries")) {
                            log.error("\u5bfc\u5165\u6d88\u606f\u5931\u8d25\uff0c\u56e0\u4e3a\u88ab\u9650\u6d41........", (Throwable)e);
                            Thread.sleep(10L);
                            continue;
                        }
                        break;
                    }
                }
                log.info("\u88ab\u9650\u6d41\uff0c\u7b49\u5f85\u4e2d........");
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleMigrateMessage(MigrateMessageMapping migrateMessageMapping) {
        log.info("\u5f00\u59cb\u5904\u7406ania_message\u8868,\u539f\u6765\u7684msgIdServer\uff1a{}", (Object)migrateMessageMapping.getOriginalMsgidServer());
        long start = System.currentTimeMillis();
        ImMessageLog imMessageLog = this.messageMongoMapper.queryMessageById(migrateMessageMapping.getOriginalMsgidServer());
        if (Objects.nonNull(imMessageLog)) {
            this.messageMongoMapper.updateMessageServerId(imMessageLog, migrateMessageMapping.getNewMsgidServer());
        }
        long middle = System.currentTimeMillis();
        log.info("\u5237\u65b0ania_message\u8868\u8017\u65f6\uff1a{}ms", (Object)(middle - start));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("t", String.valueOf(System.currentTimeMillis()));
        HttpEntity httpEntity = new HttpEntity((Object)migrateMessageMapping, (MultiValueMap)httpHeaders);
        log.info("\u5f00\u59cb\u5904\u7406workitemInfoData\u8868,\u539f\u6765\u7684msgIdServer\uff1a{}", (Object)migrateMessageMapping.getOriginalMsgidServer());
        log.debug("\u5237\u65b0 workitemInfoData.lastBnaMsgId \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)migrateMessageMapping));
        ResponseEntity responseEntity = this.restTemplate.exchange(this.envProperties.getAsaUri() + "/asa/test/migrate/message/lastBnaMsgId/refresh", HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{migrateMessageMapping});
        log.debug("\u5237\u65b0 workitemInfoData.lastBnaMsgId \u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)responseEntity));
        log.info("\u5237\u65b0workitemInfoData.lastBnaMsgId\u8868\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - middle));
    }
}

