/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl.bnaProcessor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.dto.AssistantConfig;
import com.digiwin.athena.ania.dto.LanguageTemplateBO;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.service.impl.bnaProcessor.BnaProcessor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class BnaBusinessProcessor
extends BnaProcessor {
    private static final Logger log = LoggerFactory.getLogger(BnaBusinessProcessor.class);
    private static final String GUIDE_SENTENCE = "\u4f60\u7684\u95ee\u9898\u5a1c\u5a1c\u6682\u4e0d\u652f\u6301\u89e3\u51b3\uff0c\u8bf7\u5207\u6362\u5230\u5bf9\u5e94\u52a9\u7406\u518d\u8be2\u95ee";
    private static final String PROCESS_MSG_TO_ASA_URL = "/asa/message/athena/processMessage";
    @Value(value="${openfire.msgDomain}")
    private String msgDomain;

    public Integer getAssistantSubType() {
        return AssistantSubTypeEnum.BUSINESS.getType();
    }

    public void execute(UserMessageActionContext userMessageActionContext) {
        String msgType = userMessageActionContext.getImMessageLog().getMsgType();
        JSONObject msgExt = userMessageActionContext.getImMessageLog().getMsgExt();
        String contentId = msgExt.getString("contentId");
        if (StringUtils.isNotBlank((CharSequence)contentId)) {
            return;
        }
        String skillType = MapUtils.getString((Map)msgExt, (Object)"skillType");
        JSONObject msg = new JSONObject();
        msg.put("msgidServer", (Object)userMessageActionContext.getImMessageLog().getMsgidServer());
        if ("txt".equals(msgType)) {
            msgType = "TEXT";
        }
        if ("custom".equals(msgType)) {
            msgType = "CUSTOM";
        }
        msg.put("msgType", (Object)msgType);
        msg.put("msgBody", (Object)userMessageActionContext.getImMessageLog().getMsgBody());
        msg.put("msgExt", (Object)msgExt);
        msg.put("msgTimestamp", (Object)userMessageActionContext.getImMessageLog().getMsgTimestamp());
        msg.put("msgidClient", (Object)userMessageActionContext.getImMessageLog().getMsgidClient());
        msg.put("fromClientType", (Object)userMessageActionContext.getImMessageLog().getFromClientType());
        HttpHeaders httpHeaders = new HttpHeaders();
        String userToken = msgExt.getString("token");
        httpHeaders.set("digi-middleware-auth-user", userToken);
        httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HttpEntity httpEntity = new HttpEntity((Object)msg, (MultiValueMap)httpHeaders);
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.envProperties.getAsaUri());
        sbUrl.append(PROCESS_MSG_TO_ASA_URL);
        log.info("BnaAssistantHandler.handler params\uff1a{}", (Object)JSON.toJSONString((Object)msg));
        ResponseEntity responseEntity = this.restTemplate.exchange(sbUrl.toString(), HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)msg);
        if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
            log.info("BnaAssistantHandler.handler is fail responseEntity:{}", (Object)responseEntity);
            return;
        }
        JSONObject responseBody = (JSONObject)responseEntity.getBody();
        log.info("BnaAssistantHandler.handler  responseBody:{}", (Object)responseBody);
        JSONObject data = responseBody.getJSONObject("data");
        String resultType = MapUtils.getString((Map)data, (Object)"resultType");
        if ("NOTSUPPORT".equals(resultType)) {
            String accId = userMessageActionContext.getImMessageLog().getFromAccount();
            this.imTypeHandlerStrategy.handler(this.envProperties.getSupplierType(), accId, (Object)GUIDE_SENTENCE, skillType, msgExt, this.msgDomain);
        }
    }

    public void filterAuthScene(List<LanguageTemplateBO> filterAssistantScenes, AssistantConfig assistantConfig, List<LanguageTemplateBO> assistantScenes, Map<String, Map> authAppIdMapList, Set<String> authAppIds) {
        if (this.auth(assistantConfig.getAssistantCode(), authAppIdMapList, authAppIds).booleanValue()) {
            filterAssistantScenes.addAll(assistantScenes);
        }
    }
}

