/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl.bnaProcessor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.AssistantSceneTypeEnum;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.dto.AssistantConfig;
import com.digiwin.athena.ania.dto.LanguageTemplateBO;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.service.impl.bnaProcessor.BnaProcessor;
import com.digiwin.athena.ania.util.LanguageUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BnaCompositeProcessor
extends BnaProcessor {
    private static final Logger log = LoggerFactory.getLogger(BnaCompositeProcessor.class);
    private static final String ATZURL = "/api/ai/agileData/snapData/processMessage";
    private static final String PROCESS_MSG_TO_ASA_URL = "/asa/message/athena/processMessage";
    @Autowired
    private KmHelper kmHelper;

    public Integer getAssistantSubType() {
        return AssistantSubTypeEnum.COMPOSITE.getType();
    }

    public void execute(UserMessageActionContext userMessageActionContext) {
    }

    public void filterAuthScene(List<LanguageTemplateBO> filterAssistantScenes, AssistantConfig assistantConfig, List<LanguageTemplateBO> assistantScenes, Map<String, Map> authAppIdMapList, Set<String> authAppIds) {
        if (CollUtil.isNotEmpty(assistantScenes)) {
            for (int i = 0; i < assistantScenes.size(); ++i) {
                LanguageTemplateBO assistantScene = assistantScenes.get(i);
                if (Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_KNOWLEDGE.getType(), assistantScene.getType())) {
                    if ("private".equals(assistantScene.getKnowledgeBase().get((Object)"type"))) {
                        if (!this.auth("KCF", authAppIdMapList, authAppIds).booleanValue()) continue;
                        filterAssistantScenes.add(assistantScene);
                        continue;
                    }
                    if (!"public".equals(assistantScene.getKnowledgeBase().get((Object)"type")) || !this.auth(assistantScene.getIntent(), authAppIdMapList, authAppIds).booleanValue()) continue;
                    filterAssistantScenes.add(assistantScene);
                    continue;
                }
                if (Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_DATA.getType(), assistantScene.getType())) {
                    String application = assistantScene.getDataMetric().getString("application");
                    if (!this.auth(application, authAppIdMapList, authAppIds).booleanValue()) continue;
                    filterAssistantScenes.add(assistantScene);
                    continue;
                }
                if (Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_BUSINESS.getType(), assistantScene.getType())) {
                    if (!this.auth(assistantScene.getAssistantCode(), authAppIdMapList, authAppIds).booleanValue()) continue;
                    filterAssistantScenes.add(assistantScene);
                    continue;
                }
                filterAssistantScenes.add(assistantScene);
            }
            this.dataSceneAssemble(assistantConfig, filterAssistantScenes);
        }
    }

    public void dataSceneAssemble(AssistantConfig assistantConfig, List<LanguageTemplateBO> assistantScenes) {
        try {
            if (CollUtil.isEmpty(assistantScenes)) {
                return;
            }
            LinkedHashMap<String, LanguageTemplateBO> firstOccurrenceMap = new LinkedHashMap<String, LanguageTemplateBO>();
            for (int i = assistantScenes.size() - 1; i >= 0; --i) {
                JSONObject lang;
                JSONObject name;
                String dataMetricApplicationName;
                LanguageTemplateBO scene = assistantScenes.get(i);
                if (!Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_DATA.getType(), scene.getType()) || !Objects.nonNull(scene.getDataMetric()) || scene.getDataMetric().isEmpty()) continue;
                String application = scene.getDataMetric().getString("application");
                if (firstOccurrenceMap.containsKey(application)) {
                    LanguageTemplateBO firstOccurrence = (LanguageTemplateBO)firstOccurrenceMap.get(application);
                    firstOccurrence.getTexts().addAll(scene.getTexts());
                    assistantScenes.remove(i);
                    continue;
                }
                firstOccurrenceMap.put(application, scene);
                JSONObject response = this.kmHelper.applicationByCode(application, assistantConfig.getTenantId());
                if (null == response || response.isEmpty() || !StrUtil.isNotBlank((CharSequence)(dataMetricApplicationName = (name = (lang = response.getJSONObject("lang")).getJSONObject("name")).getString(LanguageUtils.processLanguage())))) continue;
                scene.setIntentName(dataMetricApplicationName);
            }
        }
        catch (Exception e) {
            log.info("BnaCompositeProcessor.dataSceneAssemble error", (Throwable)e);
        }
    }
}

