/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.service.SSEEventService;
import com.digiwin.athena.ania.service.message.HisConversationMessageService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.client.RestTemplate;

public abstract class AssistantSceneStrategy
extends SSEEventService {
    private static final Logger log = LoggerFactory.getLogger(AssistantSceneStrategy.class);
    public static final String PRIVATE_KNOWLEDGE_TYPE = "private";
    public static final String QUESTION_SCENE_CODE_KEY = "ANIA_QUESTION_";
    public static final String QUESTION_COMBINATION_KEY = "ANIA_QUESTION_CBT_";
    public static final int SCENE_DATA_TYPE = 1;
    public static final int SCENE_KNOWLEDGE_TYPE = 2;
    public static final int SCENE_TRANSACTION_TYPE = 3;
    public static final int MULTIPLE_INTENT = 99;
    public static final int INTENT_STOP = 88;
    public static final int SCENE_SPECIFY_REPLY_TYPE = 101;
    public static final int SCENE_TEXT_REPLY_TYPE = 102;
    public static final int FCI_HELPER = 103;
    public static final int AIM_HELPER = 104;
    public static final int SCENE_CREATE_PROJECT_TYPE = 105;
    private Integer sceneType;
    @Resource
    protected RedisTemplate<String, String> redisTemplate;
    @Resource
    protected EnvProperties envProperties;
    @Autowired
    protected RestTemplate restTemplate;
    @Resource
    protected SseEventDataService sseEventDataService;
    @Resource
    protected HisConversationMessageService hisConversationMessageService;
    @Resource
    private IamHelper iamHelper;
    protected Map<Integer, SseFlow> flowMap = new HashMap();

    @Autowired
    public void setFlowMap(List<SseFlow> sseFlows) {
        sseFlows.forEach(flow -> this.flowMap.put(flow.getFlowType().getFlowEventType(), flow));
    }

    public AssistantSceneStrategy(Integer sceneType) {
        this.sceneType = sceneType;
    }

    public Integer getAssistantSceneType() {
        return this.sceneType;
    }

    public void dispatchIntentRequest(SseEventParams sseEventParam) {
        this.intentRequestAction(sseEventParam);
    }

    protected abstract void intentRequestAction(SseEventParams var1);

    protected void cacheSceneCode(SseEventParams sseEventParam) {
        try {
            String sceneCodes;
            SseEventParams.ActionScene actionScene = sseEventParam.getActionScene();
            Integer type = actionScene.getType();
            List actionScenes = actionScene.getActionScenes();
            JSONObject data = new JSONObject().fluentPut("type", (Object)type);
            if (3 == type) {
                sceneCodes = ((AssistantScene)actionScenes.get(0)).getCode();
            } else if (2 == type) {
                sceneCodes = CollectionUtils.isNotEmpty((Collection)actionScenes) ? ((AssistantScene)actionScenes.get(0)).getCode() : sseEventParam.getAssistant().getAssistantCode();
            } else if (1 == type) {
                sceneCodes = CollUtil.emptyIfNull((List)actionScenes).stream().map(AssistantScene::getCode).collect(Collectors.joining("_"));
            } else {
                return;
            }
            data.put("sceneCodes", (Object)sceneCodes);
            this.redisTemplate.opsForValue().set((Object)(QUESTION_SCENE_CODE_KEY + sseEventParam.getId()), (Object)JSON.toJSONString((Object)data), 1L, TimeUnit.HOURS);
        }
        catch (Exception ex) {
            log.error("AssistantSceneStrategy.cacheSceneCode is error sseEventParam:{},assistantScene:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
    }

    protected void cacheCombinationMsg(SseEventParams sseEventParam) {
        try {
            if (StringUtils.isNotBlank((CharSequence)sseEventParam.getCombinationMsg())) {
                this.redisTemplate.opsForValue().set((Object)(QUESTION_COMBINATION_KEY + sseEventParam.getId()), (Object)sseEventParam.getCombinationMsg(), 1L, TimeUnit.HOURS);
            }
        }
        catch (Exception ex) {
            log.error("AssistantSceneStrategy.cacheSceneCode is error sseEventParam:{},assistantScene:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
    }

    protected String sceneActionMessage(SseEventParams sseEventParam) {
        SseEventParams.ActionScene actionScene = sseEventParam.getActionScene();
        Integer type = actionScene.getType();
        ImmutableMap eventData = ImmutableMap.of((Object)"msg_type", (Object)"scene_action", (Object)"scene_type", (Object)type);
        return JSON.toJSONString((Object)eventData);
    }

    public Map<String, Function> getExecuteFunctions(String routerKey) {
        HashMap<String, Function> functionMap = new HashMap<String, Function>();
        Function<String, String> getTenantIdFunction = userToken -> this.iamHelper.getTenantIdFromToken(userToken);
        functionMap.put("routerKey", getTenantIdFunction);
        return functionMap;
    }
}

