/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.knowledge.client.sse.DataEventSourceListener;
import com.digiwin.athena.ania.knowledge.client.sse.EventStreamClient;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.BaseUseUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSceneService
extends AssistantSceneStrategy {
    private static final Logger log = LoggerFactory.getLogger(DataSceneService.class);
    @Autowired
    protected EnvProperties envProperties;
    private static final String DATA_SCENE = "/api/ai/agileData/sse/snapData/processMessage";

    public DataSceneService() {
        super(Integer.valueOf(1));
    }

    public void intentRequestAction(SseEventParams sseEventParam) {
        try {
            log.info("DataSceneService.intentRequestAction pre sseEventParam:{},assistantScene:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
            String assistantCode = sseEventParam.getQuestion().getAssistantCode();
            this.cacheSceneCode(sseEventParam);
            if (assistantCode.equals("asada")) {
                this.dataAssistantSceneInitiation(sseEventParam);
            } else {
                ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowStart(sseEventParam);
                this.dataCompositeSceneInitiation(sseEventParam);
            }
        }
        catch (Exception ex) {
            ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowEnd(sseEventParam, Boolean.valueOf(false));
            log.error("DataSceneService.intentRequestAction is error sseEventParam:{},assistantScene:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
    }

    private void dataCompositeSceneInitiation(SseEventParams sseEventParams) throws IOException {
        SseEventlEnum.SseEventDataTypeEnum verbose = SseEventlEnum.SseEventDataTypeEnum.VERBOSE;
        EventData eventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), verbose.getType(), null, this.sceneActionMessage(sseEventParams));
        this.sendEventData(sseEventParams, eventData);
        List actionScenes = sseEventParams.getActionScene().getActionScenes();
        List dataMetricCodes = actionScenes.stream().map(scene -> scene.getDataMetric().getString("code")).collect(Collectors.toList());
        JSONObject msgExt = JSONObject.parseObject((String)sseEventParams.getQuestion().getMessage().getExt());
        msgExt.put("userId", (Object)sseEventParams.getUser().getUserId());
        msgExt.put("sceneType", (Object)1);
        JSONObject param = new JSONObject();
        param.put("msgType", (Object)"TEXT");
        param.put("msgExt", (Object)msgExt);
        param.put("intentCode", dataMetricCodes);
        param.put("msgBody", (Object)new JSONObject().fluentPut("text", (Object)sseEventParams.getQuestion().getMessage().getText()));
        if (StringUtils.isNotBlank((CharSequence)sseEventParams.getCombinationMsg())) {
            param.put("combinationMsg", (Object)sseEventParams.getCombinationMsg());
        }
        this.executeSse(sseEventParams, param);
    }

    private void dataAssistantSceneInitiation(SseEventParams sseEventParams) throws IOException {
        SseEventlEnum.SseEventDataTypeEnum verbose = SseEventlEnum.SseEventDataTypeEnum.VERBOSE;
        EventData eventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), verbose.getType(), null, this.sceneActionMessage(sseEventParams));
        this.sendEventData(sseEventParams, eventData);
        JSONObject msgExt = JSONObject.parseObject((String)sseEventParams.getQuestion().getMessage().getExt());
        msgExt.put("userId", (Object)sseEventParams.getUser().getUserId());
        JSONObject param = new JSONObject();
        param.put("msgType", (Object)"TEXT");
        param.put("msgExt", (Object)msgExt);
        param.put("msgBody", (Object)new JSONObject().fluentPut("text", (Object)sseEventParams.getQuestion().getMessage().getText()));
        this.executeSse(sseEventParams, param);
    }

    private void executeSse(SseEventParams sseEventParams, JSONObject param) {
        param.put("assistantId", (Object)sseEventParams.getQuestionMessage().getAgentId());
        param.put("conversationId", (Object)sseEventParams.getQuestionMessage().getConversationId());
        JSONObject message = new JSONObject().fluentPut("messageId", (Object)sseEventParams.getQuestionMessage().getMessageId()).fluentPut("sectionId", (Object)sseEventParams.getQuestionMessage().getSectionId());
        param.put("message", (Object)message);
        String url = this.envProperties.getAtzUri() + DATA_SCENE;
        String token = sseEventParams.getUser().getToken();
        String language = sseEventParams.getLanguage();
        DataEventSourceListener sseListener = new DataEventSourceListener(sseEventParams, this.sseEventDataService, this.flowMap);
        log.info("DataSceneService.executeSse token:{},param:{}", (Object)token, (Object)JSONUtil.toJsonStr((Object)param));
        EventStreamClient.executeSSE((String)url, null, (String)token, (EventSourceListener)sseListener, (JSONObject)param, (String)language, (Map)this.getExecuteFunctions(sseEventParams.getUser().getTenantId()));
    }
}

