/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.MessageTypeEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.knowledge.client.sse.DesignerEventSourceListener;
import com.digiwin.athena.ania.knowledge.client.sse.EventStreamClient;
import com.digiwin.athena.ania.knowledge.server.dto.HistoryItem;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.LanguageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.Headers;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DesignerSceneService
extends AssistantSceneStrategy {
    private static final Logger log = LoggerFactory.getLogger(DesignerSceneService.class);
    @Resource
    protected EnvProperties envProperties;

    public DesignerSceneService() {
        super(Integer.valueOf(104));
    }

    public void intentRequestAction(SseEventParams sseEventParam) {
        try {
            Assistant assistant = sseEventParam.getAssistant();
            String userId = sseEventParam.getUser().getUserId();
            String tenantId = sseEventParam.getUser().getTenantId();
            String extStr = sseEventParam.getQuestion().getMessage().getExt();
            JSONObject extObj = JSON.parseObject((String)extStr);
            if (extObj.get((Object)"busiInfo") == null) {
                String errorMsg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684AI\u5efa\u6a21\u52a9\u7406\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684AI\u5efa\u6a21\u52a9\u7406\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
                this.errorStop(sseEventParam, errorMsg);
                return;
            }
            JSONObject busiInfo = extObj.getJSONObject("busiInfo");
            if ("801".equals(busiInfo.getString("busiType"))) {
                String modelDetailId = busiInfo.getString("id");
                if (StringUtils.isEmpty((CharSequence)modelDetailId)) {
                    String errorMsg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684AI\u5efa\u6a21\u52a9\u7406\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684AI\u5efa\u6a21\u52a9\u7406\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
                    this.errorStop(sseEventParam, errorMsg);
                    return;
                }
                String designerDomain = this.envProperties.getDesignerUri();
                Headers.Builder requestHeader = new Headers.Builder();
                if ("TENANT".equals(busiInfo.getString("platformCategory"))) {
                    designerDomain = this.envProperties.getTenantDesignerUri();
                    requestHeader.add("level", "tenant");
                    requestHeader.add("branch", "master");
                }
                String url = designerDomain + "/athena-designer/ai/guide/chat/" + modelDetailId;
                String token = sseEventParam.getUser().getToken();
                String language = LanguageUtils.processSseLanguage();
                String newQuestion = sseEventParam.getQuestion().getMessage().getText();
                ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
                List historyMessage = this.hisConversationMessageService.queryMessage(questionMessage.getUserId(), questionMessage.getTenantId(), questionMessage.getConversationId(), questionMessage.getSectionId(), questionMessage.getIndex(), 10);
                ArrayList<HistoryItem> historyList = new ArrayList<HistoryItem>();
                if (CollUtil.isNotEmpty((Collection)historyMessage)) {
                    for (ConversationMessage imMessageLog : historyMessage) {
                        if (MessageTypeEnum.NEW_CONVERSATION.getType().equals(MapUtils.getInteger((Map)imMessageLog.getExt(), (Object)"messageType"))) break;
                        if (imMessageLog.getMsgBody().getInteger("showType") != null && imMessageLog.getMsgBody().getInteger("showType") == 1) continue;
                        String msgText = imMessageLog.getMsgBody().getString("text");
                        HistoryItem historyItem = new HistoryItem();
                        if (CollectionUtils.isNotEmpty((Collection)imMessageLog.getContent())) {
                            List textMap;
                            String text = "";
                            if (Objects.equals(imMessageLog.getStatus(), 1) && CollectionUtils.isNotEmpty((Collection)imMessageLog.getContent()) && CollectionUtils.isNotEmpty(textMap = imMessageLog.getContent().stream().filter(item -> "text".equalsIgnoreCase(MapUtils.getString((Map)item, (Object)"type"))).collect(Collectors.toList()))) {
                                text = MapUtils.getString((Map)((Map)textMap.get(0)), (Object)"text");
                                historyItem.setQuestion(msgText);
                                historyItem.setAnswer(text);
                            }
                        } else {
                            historyItem.setAnswer(msgText);
                        }
                        historyList.add(historyItem);
                    }
                }
                CollUtil.reverse(historyList);
                JSONObject requestBody = new JSONObject();
                requestBody.put("question", (Object)newQuestion);
                requestBody.put("historyFlag", (Object)true);
                requestBody.put("historyList", historyList);
                log.info("DesignerSceneService.intentRequestAction.param:{}", (Object)JSONUtil.toJsonStr((Object)requestBody));
                DesignerEventSourceListener sseListener = new DesignerEventSourceListener(sseEventParam, this.sseEventDataService);
                EventStreamClient.executeSSE((String)url, null, (String)token, (String)language, (Headers)requestHeader.build(), (JSONObject)requestBody, (EventSourceListener)sseListener);
            }
        }
        catch (Exception e) {
            log.info("DesignerSceneService.intentRequestAction error SseEventParams:{}", (Object)JSONUtil.toJsonStr((Object)sseEventParam), (Object)e);
            String errorMsg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684AI\u5efa\u6a21\u52a9\u7406\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684AI\u5efa\u6a21\u52a9\u7406\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            this.errorStop(sseEventParam, errorMsg);
        }
    }
}

