/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.dto.HisConversationMessageDto;
import com.digiwin.athena.ania.helper.AsaHelper;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.WorkitemInfoData;
import com.digiwin.athena.ania.mongo.repository.WorkitemInfoDao;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpecifyReplySceneService
extends AssistantSceneStrategy {
    private static final Logger log = LoggerFactory.getLogger(SpecifyReplySceneService.class);
    @Autowired
    private WorkitemInfoDao workitemInfoDao;
    @Autowired
    private AsaHelper asaHelper;

    public SpecifyReplySceneService() {
        super(Integer.valueOf(101));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intentRequestAction(SseEventParams sseEventParam) {
        try {
            String msg;
            log.info("SpecifyReplySceneService.intentRequestAction pre sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
            ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowStart(sseEventParam);
            String ext = sseEventParam.getQuestion().getMessage().getExt();
            JSONObject extJson = JSONObject.parseObject((String)ext);
            boolean result = this.desSpecifyReplyMsg(sseEventParam, extJson.getString("referenced_message_id"));
            if (result) {
                msg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u56de\u590d\u6210\u529f\uff0c\u611f\u8c22\u60a8\u7684\u64cd\u4f5c\uff01" : "\u56de\u5fa9\u6210\u529f\uff0c\u611f\u8b1d\u60a8\u7684\u64cd\u4f5c\uff01";
                ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowEnd(sseEventParam);
            } else {
                msg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u4efb\u52a1\u5361\u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u56de\u590d\u5931\u8d25\u4e86" : "\u4efb\u52d9\u5361\u5df2\u7d93\u88ab\u95dc\u9589\uff0c\u56de\u5fa9\u5931\u6557\u4e86";
                ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowEnd(sseEventParam, Boolean.valueOf(false));
            }
            EventData actionData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), msg);
            this.sendEventData(sseEventParam, actionData);
            this.cacheSceneCode(sseEventParam);
            this.cacheCombinationMsg(sseEventParam);
            SseEventlEnum.SseEventDataTypeEnum verbose = SseEventlEnum.SseEventDataTypeEnum.VERBOSE;
            EventData eventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), verbose.getType(), null, this.sceneActionMessage(sseEventParam));
            this.sendEventData(sseEventParam, eventData);
            EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
            this.sendEventData(sseEventParam, completed);
        }
        catch (Exception ex) {
            log.error("SpecifyReplySceneService.dispatchIntentRequest is error sseEventParam:{},assistantScene:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
        finally {
            this.stop(sseEventParam, true);
        }
    }

    protected boolean desSpecifyReplyMsg(SseEventParams sseEventParam, String referencedMessageId) {
        List imMessageLogList = this.hisConversationMessageService.queryMessagesByIds(Collections.singletonList(referencedMessageId), sseEventParam.getUser());
        if (CollectionUtils.isEmpty((Collection)imMessageLogList)) {
            return false;
        }
        HisConversationMessageDto responseDTO = (HisConversationMessageDto)imMessageLogList.get(0);
        JSONObject executeContext = responseDTO.getMsgBody().getJSONObject("executeContext");
        if (Objects.isNull(executeContext)) {
            return false;
        }
        boolean sourceCustom = sseEventParam.getAssistant().getSourceCustom();
        if (!(sourceCustom || executeContext.containsKey((Object)"abilityCode") && "textCollect".equals(executeContext.getString("abilityCode")))) {
            return false;
        }
        String text = sseEventParam.getQuestion().getMessage().getText();
        String workItemId = executeContext.getString("workitemId");
        if (StringUtils.isBlank((CharSequence)workItemId)) {
            return false;
        }
        WorkitemInfoData collectWorkCard = this.workitemInfoDao.findByUserIdAndWorkitemId(sseEventParam.getUser().getUserId(), workItemId);
        if (Objects.nonNull(collectWorkCard) && collectWorkCard.needSubmit() && Objects.equals(collectWorkCard.getAssistantCode(), sseEventParam.getAssistant().getAssistantCode())) {
            JSONObject submitDto = new JSONObject();
            if (sourceCustom) {
                submitDto.put("value", (Object)text);
                submitDto.put("executeContext", (Object)executeContext);
                submitDto.put("messageType", responseDTO.getMsgBody().get((Object)"messageType"));
            } else {
                JSONObject layout = collectWorkCard.getBpmData().getJSONObject("_layout");
                if (Objects.isNull(layout)) {
                    return false;
                }
                String schema = layout.getString("schema");
                submitDto.put("value", (Object)Utils.getReferencedValue((String)schema, (String)text, (String)sseEventParam.getLanguage()));
                submitDto.put("executeContext", (Object)executeContext);
                submitDto.put("msgIdServer", (Object)responseDTO.getMsgidServer());
                submitDto.put("msgIdClient", (Object)responseDTO.getMsgidClient());
                submitDto.put("messageType", responseDTO.getMsgBody().get((Object)"messageType"));
            }
            return this.asaHelper.submit(submitDto, sseEventParam.getUser().getToken());
        }
        log.info("bNa#desSpecifyReplyMsg workItemId is not needSubmit message:{}", (Object)sseEventParam.getQuestion().getMessage().getExt());
        return false;
    }
}

