/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.token.base.impl;

import com.digiwin.athena.ania.service.token.base.TokenConfig;
import com.digiwin.athena.ania.service.token.base.TokenService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseTokenService
implements TokenService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(BaseTokenService.class);
    private TokenConfig tokenConfig;

    public void afterPropertiesSet() {
        this.getToken(true);
        this.startTokenRefreshSchedule();
    }

    public String getToken() throws BusinessException {
        return this.getToken(false);
    }

    public String getToken(boolean forceRefresh) throws BusinessException {
        String token;
        if (!forceRefresh && !this.getTokenConfig().isTokenExpired() && StringUtils.isNotBlank((CharSequence)(token = this.getTokenConfig().getToken()))) {
            return token;
        }
        Lock lock = this.getTokenConfig().getTokenLock();
        boolean locked = false;
        try {
            do {
                String token2;
                locked = lock.tryLock(100L, TimeUnit.MILLISECONDS);
                if (forceRefresh || this.getTokenConfig().isTokenExpired() || !StringUtils.isNotBlank((CharSequence)(token2 = this.getTokenConfig().getToken()))) continue;
                String string = token2;
                return string;
            } while (!locked);
            Pair tokenInfo = this.getTokenAction();
            String string = this.extractToken(tokenInfo);
            return string;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw BusinessException.create((Throwable)ie);
        }
        catch (Exception e) {
            throw BusinessException.create((Throwable)e);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public TokenConfig getTokenConfig() {
        return this.tokenConfig;
    }

    public void setTokenConfig(TokenConfig tokenConfig) {
        this.tokenConfig = tokenConfig;
    }

    protected abstract Pair<String, Long> getTokenAction() throws BusinessException;

    protected void startTokenRefreshSchedule() throws BusinessException {
    }

    protected String extractToken(Pair<String, Long> tokenInfo) {
        log.info(this.getClass().getName() + "->token: " + (String)tokenInfo.getKey());
        BaseUseUtils.isBlankException((String)((String)tokenInfo.getKey()), (String)"BaseTokenService.getTokenAction return token is blank");
        TokenConfig config = this.getTokenConfig();
        config.updateApplicationToken((String)tokenInfo.getKey(), Objects.isNull(tokenInfo.getValue()) ? 0L : (Long)tokenInfo.getValue());
        return (String)tokenInfo.getKey();
    }
}

