/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.token.appToken;

import com.digiwin.athena.ania.common.AgoraConstant;
import com.digiwin.athena.ania.common.enums.SupplierTypeEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.io.agora.chat.ChatTokenBuilder2;
import com.digiwin.athena.ania.util.RedisUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class AgoraClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AgoraClientHttpRequestInterceptor.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ChatTokenBuilder2 chatTokenBuilder;

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        if (SupplierTypeEnum.AGORA.getValue().equals(this.envProperties.getSupplierType()) && !RedisUtils.hasAppTokenKey().booleanValue()) {
            String appToken = this.chatTokenBuilder.buildAppToken(this.envProperties.getAgoraAppId(), this.envProperties.getAgoraAppCertificate(), AgoraConstant.AGORA_APP_TOKEN_SECONDS.intValue());
            RedisUtils.insertAppToken((String)appToken);
        }
        return clientHttpRequestExecution.execute(httpRequest, bytes);
    }
}

