/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.BizException;
import com.digiwin.athena.ania.util.JsonUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseUseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseUseUtils.class);
    private static final Pattern CN = Pattern.compile("[\u4e00-\u9fa5]+");

    private BaseUseUtils() {
    }

    public static <T> void paramValidationNullAndNotBlank(T target) {
        Class<?> clazz = target.getClass();
        Field[] declaredFields = clazz.getDeclaredFields();
        try {
            for (Field field : declaredFields) {
                NotNull annotation;
                field.setAccessible(true);
                if (field.isAnnotationPresent(NotNull.class)) {
                    annotation = field.getAnnotation(NotNull.class);
                    if (!Objects.isNull(field.get(target))) continue;
                    throw new BizException(Integer.valueOf(500), annotation.message(), null);
                }
                if (!field.isAnnotationPresent(NotBlank.class)) continue;
                annotation = field.getAnnotation(NotBlank.class);
                if (!Objects.isNull(field.get(target)) && (!field.getGenericType().toString().equals("class java.lang.String") || !StringUtils.isBlank((CharSequence)((String)field.get(target))))) continue;
                throw new BizException(Integer.valueOf(500), annotation.message(), null);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("BaseUseUtils.paramValidationNullAndNotBlank is error", (Throwable)e);
        }
    }

    public static void isNullException(Object target, String msg) throws BizException {
        BaseUseUtils.businessException((boolean)Objects.isNull(target), (String)msg);
    }

    public static void isBlankException(String target, String msg) throws BizException {
        BaseUseUtils.businessException((boolean)StringUtils.isBlank((CharSequence)target), (String)msg);
    }

    public static void isEmptyException(Collection<?> coll, String msg) throws BizException {
        BaseUseUtils.businessException((boolean)CollectionUtils.isEmpty(coll), (String)msg);
    }

    public static void isEmptyException(Map<?, ?> map, String msg) throws BizException {
        BaseUseUtils.businessException((boolean)MapUtils.isEmpty(map), (String)msg);
    }

    public static void businessException(boolean whether, String msg) throws BizException {
        if (whether) {
            BaseUseUtils.businessException((String)msg);
        }
    }

    public static void businessException(String msg) {
        throw new BizException(Integer.valueOf(500), msg, null);
    }

    public static String toJsonString(Object value) {
        try {
            return JsonUtil.toJSONString((Object)value);
        }
        catch (Exception e) {
            LOGGER.error("BaseUseUtils.toJsonString is error", (Throwable)e);
            return "{}";
        }
    }

    public static boolean isJsonString(String content) {
        boolean b;
        if (StringUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        String str = content.trim();
        boolean bl = b = str.startsWith("{") && str.endsWith("}") || str.startsWith("[") && !str.endsWith("]");
        if (b) {
            try {
                JSONObject.parse((String)str);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isAllChinese(String str) {
        if (str == null) {
            return false;
        }
        Matcher matcher = CN.matcher(str);
        return matcher.matches();
    }
}

