/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import com.digiwin.athena.ania.util.AsaDateFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigInteger;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private JsonUtil() {
        throw new UnsupportedOperationException();
    }

    public static String toJSONString(Object value) {
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (Throwable ignore) {
            log.error(ignore.getLocalizedMessage(), ignore);
            throw new RuntimeException(ignore);
        }
    }

    public static byte[] writeValueAsBytes(Object value) {
        try {
            return objectMapper.writeValueAsBytes(value);
        }
        catch (Throwable ignore) {
            log.error(ignore.getLocalizedMessage(), ignore);
            throw new RuntimeException(ignore);
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(text, clazz);
        }
        catch (Throwable ignore) {
            log.error(ignore.getLocalizedMessage(), ignore);
            throw new RuntimeException(ignore);
        }
    }

    public static <T> T parseObject(byte[] body, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(body, clazz);
        }
        catch (Throwable ignore) {
            log.error(ignore.getLocalizedMessage(), ignore);
            throw new RuntimeException(ignore);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        try {
            return (List)objectMapper.readValue(text, objectMapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clazz}));
        }
        catch (Throwable ignore) {
            log.error(ignore.getLocalizedMessage(), ignore);
            return null;
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDateFormat((DateFormat)new AsaDateFormat());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT)));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMAT)));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMAT)));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT)));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMAT)));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMAT)));
        javaTimeModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        javaTimeModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        javaTimeModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)javaTimeModule);
    }
}

