/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.appcore.domain.LanguageMark;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LanguageUtils {
    private static final Logger log = LoggerFactory.getLogger(LanguageUtils.class);

    public static String processLanguage() {
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        return StrUtil.isNotBlank((CharSequence)(langName = langName.replace("-", "_"))) ? langName : LocalsEnum.CN.getCode();
    }

    public static void processLanguage(Object data, String langName) {
        if (data == null) {
            return;
        }
        if (LanguageUtils.isWrapperObjectOrBasic((Object)data)) {
            return;
        }
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            for (Object item : collection) {
                LanguageUtils.processLanguage(item, (String)langName);
            }
            return;
        }
        ArrayList fields = new ArrayList();
        Class<?> classType = data.getClass();
        if (classType == null || classType.getPackage() == null) {
            return;
        }
        if (data instanceof Map) {
            try {
                LanguageUtils.processLanguage((Map)((Map)data), (String)langName);
            }
            catch (JsonProcessingException e) {
                log.error("Parse language info error", (Throwable)e);
            }
            return;
        }
        if (!classType.getPackage().getName().startsWith("com.digiwin.")) {
            return;
        }
        while (classType != null) {
            fields.addAll(Arrays.stream(classType.getDeclaredFields()).collect(Collectors.toList()));
            classType = classType.getSuperclass();
        }
        AccessibleObject[] fieldArray = new Field[fields.size()];
        fields.toArray(fieldArray);
        Field.setAccessible(fieldArray, true);
        for (Field field : fields) {
            try {
                Object value = field.get(data);
                LanguageMark languageMark = field.getAnnotation(LanguageMark.class);
                if (languageMark != null) {
                    if (value != null && value instanceof String) {
                        field.set(data, LanguageUtils.getLanguageValue((String)value.toString(), (String)langName));
                        continue;
                    }
                    LanguageUtils.processLanguage((Object)value, (String)langName);
                    continue;
                }
                LanguageUtils.processLanguage((Object)value, (String)langName);
            }
            catch (JsonParseException e) {
                log.error("Parse language info error", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Parse language info error", (Throwable)e);
            }
        }
    }

    private static void processLanguage(Map data, String langName) throws JsonProcessingException {
        Set keySet = data.entrySet();
        for (Map.Entry entry : keySet) {
            Object value = entry.getValue();
            if (value != null && value instanceof String) {
                entry.setValue(LanguageUtils.getLanguageValue((String)value.toString(), (String)langName));
                continue;
            }
            LanguageUtils.processLanguage(value, (String)langName);
        }
    }

    private static Object getLanguageValue(String valueText, String langName) throws JsonProcessingException {
        return MessageUtils.getMessageByLanguage((Object)valueText, (String)langName);
    }

    private static boolean isWrapperObjectOrBasic(Object data) {
        if (data == null) {
            return false;
        }
        Class<?> classType = data.getClass();
        if (classType.isPrimitive()) {
            return true;
        }
        if (classType == String.class) {
            return true;
        }
        if (classType == Byte.class) {
            return true;
        }
        if (classType == Short.class) {
            return true;
        }
        if (classType == Integer.class) {
            return true;
        }
        if (classType == Long.class) {
            return true;
        }
        if (classType == Float.class) {
            return true;
        }
        if (classType == Double.class) {
            return true;
        }
        if (classType == Character.class) {
            return true;
        }
        return classType == Boolean.class;
    }

    public static void valueLocale(JSONObject jsonObject, String local) {
        Object lang = jsonObject.get((Object)"lang");
        if (lang instanceof Map) {
            Map langObject = (Map)lang;
            langObject.forEach((k, v) -> {
                Map TocalMap;
                Object o;
                if (jsonObject.containsKey(k) && v instanceof Map && (o = (TocalMap = (Map)v).get(local)) != null) {
                    jsonObject.put(k, o);
                }
            });
        }
    }

    public static String processSseLanguage() {
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        if (StringUtils.isEmpty((CharSequence)langName)) {
            return LocalsEnum.CN.getCode();
        }
        langName = langName.replace("-", "_");
        return langName;
    }

    public static String toAcceptLanguage(String langName) {
        if (langName == null) {
            return "";
        }
        return langName.replace("_", "-");
    }
}

