/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final int VERSION_LENGTH = 3;

    public static String base64Encode(byte[] data) {
        byte[] encodedBytes = Base64.encodeBase64((byte[])data);
        return new String(encodedBytes);
    }

    public static byte[] base64Decode(String data) {
        return Base64.decodeBase64((byte[])data.getBytes());
    }

    public static int getTimestamp() {
        return (int)(new Date().getTime() / 1000L);
    }

    public static int randomInt() {
        return new SecureRandom().nextInt();
    }

    public static boolean isUUID(String uuid) {
        if (uuid.length() != 32) {
            return false;
        }
        return uuid.matches("\\p{XDigit}+");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] data) {
        byte[] output;
        Deflater deflater = new Deflater();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        try {
            deflater.reset();
            deflater.setInput(data);
            deflater.finish();
            byte[] buf = new byte[data.length];
            while (!deflater.finished()) {
                int i = deflater.deflate(buf);
                bos.write(buf, 0, i);
            }
            output = bos.toByteArray();
        }
        catch (Exception e) {
            output = data;
            e.printStackTrace();
        }
        finally {
            deflater.end();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] data) {
        Inflater inflater = new Inflater();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        try {
            int len;
            inflater.setInput(data);
            byte[] buf = new byte[8192];
            while ((len = inflater.inflate(buf)) > 0) {
                bos.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            inflater.end();
        }
        return bos.toByteArray();
    }

    public static void writeJsonObject(HttpServletResponse response, Object obj) {
        if (response.isCommitted()) {
            return;
        }
        try {
            if (obj != null) {
                if (obj instanceof String || Utils.isPrimitive(obj.getClass())) {
                    response.getWriter().write(obj.toString());
                } else {
                    response.getWriter().write(JSON.toJSONString((Object)obj));
                }
            }
        }
        catch (IOException e) {
            log.error("writeJsonObject exception", (Throwable)e);
        }
    }

    public static boolean isPrimitive(Class<?> c) {
        return c != null && (c.isPrimitive() || c.equals(String.class) || Number.class.isAssignableFrom(c) || Boolean.class.equals(c) || Character.class.isAssignableFrom(c) || Date.class.equals(c) || java.sql.Date.class.equals(c));
    }

    public static JSONObject getSubmitAction(String language) {
        HashMap<String, String> titleMap = new HashMap<String, String>();
        titleMap.put("zh_CN", "\u786e\u5b9a");
        titleMap.put("zh_TW", "\u78ba\u5b9a");
        titleMap.put("en_US", "\u786e\u5b9a");
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
        map.put("title", titleMap);
        JSONObject submitAction = new JSONObject();
        submitAction.put("lang", map);
        submitAction.put("dispatch", (Object)true);
        submitAction.put("type", (Object)"ASA");
        submitAction.put("actionType", (Object)"PROCESS_VARIABLE_SUBMIT");
        JSONObject actionParam = new JSONObject();
        actionParam.put("name", (Object)"render_obj");
        actionParam.put("type", (Object)"GET_ACTION_RESPONSE");
        actionParam.put("value", (Object)"render_obj");
        submitAction.put("actionParams", (Object)ListUtil.toList((Object[])new JSONObject[]{actionParam}));
        submitAction.put("title", (Object)ListUtil.toList((Object[])new String[]{(String)titleMap.get(language)}));
        return submitAction;
    }

    public static JSONObject getReferencedValue(String key, String valueStr, String language) {
        JSONObject value = new JSONObject();
        value.put("submitAction", (Object)Utils.getSubmitAction((String)language));
        value.put("pageData", (Object)new JSONObject().fluentPut("render_obj", (Object)new JSONObject().fluentPut(key, (Object)valueStr)));
        return value;
    }

    public static String createStrNext(String string) {
        char[] tempChar = string.toCharArray();
        boolean forward = false;
        for (int i = tempChar.length - 1; i >= 0; --i) {
            char next = tempChar[i];
            if ((next = (char)(next + '\u0001')) < 'z') {
                forward = false;
                tempChar[i] = next;
                break;
            }
            forward = true;
            tempChar[i] = 97;
        }
        return forward ? 'a' + String.valueOf(tempChar) : String.valueOf(tempChar);
    }
}

