package com.digiwin.athena.apimgmt;

import com.digiwin.athena.apimgmt.infra.util.PathContextUtil;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * System parameters<BR>
 * The instance of ApplicationParameter will be initated by Spring Framework
 */
@Component
public class ApiMgmtApplicationParameter implements InitializingBean {

    public static String _TEMPLATE_FILE_NAME = "StdApiTemplate.xls";
    public static String _EXPORT_TEMPLATE_FILE_NAME = "StdApiExportTemplate.xlsx";

    // 規格檔路徑
    public static String _FILE_TEMPLATE_PATH;
    public static String _FILE_EXPORT_PATH;

    public static String _DEV_PLATE_URL;

    @Autowired
    private ApiMgmtProp prop;

    public void loadParameters() {
        /*
         * 開始設定參數 - 使用依赖注入的接口
         */

        // 規格檔路徑
        String pkFileTemplatePath = prop.getBackendPath() + "/application/fileTemplate";
        String pkFileExportPath = prop.getBackendPath() + "/application/exportData";

        _FILE_TEMPLATE_PATH = pkFileTemplatePath;
        _FILE_EXPORT_PATH = pkFileExportPath;

        _DEV_PLATE_URL = prop.getDevPlatform().getUrl();
    }

    @Override
    public void afterPropertiesSet() {
        loadParameters();
    }
}
