package com.digiwin.athena.apimgmt.apiservice;

import java.util.HashMap;
import java.util.Map;

import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * 刪除辭彙
 * /restful/standard/apimgmt/ApiDataName/Delete
 */
@Slf4j
@Service
@OperateAuthorityVerify
public class ApiDataNameDeleteService extends AbstractApiService {
	
	@Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;
	
	public ApiDataNameDeleteService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.API_DATA_NAME_DELETE_SCHEMA;
	}

	/**
	 * 删除词典信息
	 * @param validatorResult validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		String tDataName = tRequestJsonNode.get(ApimgmtConstant.DATA_NAME).asText();
		standardDataNameDao.delete(tDataName);
		Map<String, Object> tResponse = new HashMap<>();
		// 組成回傳訊息
		tResponse.put(ApimgmtConstant.CODE, "000");
		tResponse.put(ApimgmtConstant.RESULT, ApimgmtConstant.SUCCESS);
		return tResponse;
	}
}
