package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApiCountKeyValue;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import cn.hutool.core.collection.CollUtil;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 取得API狀態清單
 * /restful/standard/apimgmt/ApiStatusList/Get
 */
@Slf4j
@Service
public class ApiStatusListGetService {
	

	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	@Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;
	
	public ApiStatusListGetService(){
		super();
	}

	/**
	 * 查询对应状态API的个数
	 * @param validatorResult validatorResult
	 * @return list
	 * @throws Exception Exception
	 */
	public ArrayList<Map<String, Object>> execute(String validatorResult) throws Exception {
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口：" + this.getClass()
				+ "，原始訊息：" + validatorResult);
		ArrayList<Map<String, Object>> tResponse = new ArrayList<>();
		// 取得語系
		String tLocale = ApiMgmtServiceContextHolder.getLocale();
		// header沒傳語系的話，默認回傳英文
		tLocale = tLocale == null ? LocaleEnum.EN_US.getType() : tLocale;
		JsonNode tRequestJsonNode = JsonLoader.fromString(validatorResult);
		boolean tIsVerifyAcct = false;
		if(!StringUtil.isEmptyOrSpace(tRequestJsonNode.get(ApimgmtConstant.VERIFY_ACCT).asText())){
			tIsVerifyAcct = true;
		}
		List<ApprovedStatus> tApprovedStatusList = new ArrayList<>();
		if(tIsVerifyAcct){
			ApprovedStatus tApprovedStatus = approvedStatusDao.get(2L);
			tApprovedStatusList.add(tApprovedStatus);
		}else{
			tApprovedStatusList = approvedStatusDao.getAll();
		}
		//查询返回数据信息
		List<ApiCountKeyValue> tApiCountList = standardApiVersionDao.getApiCountByStatus(ApiMgmtServiceContextHolder.getUserId(),
                ApiMgmtServiceContextHolder.getTenantId(), tIsVerifyAcct);
		// 組成回傳訊息
		tApiCountList.forEach(x->log.info("查询数据打印"+x.getApprovedStatus() +"_"+ x.getApiCount()));
		for(ApprovedStatus tApprovedStatus : tApprovedStatusList){
			Map<String, Object> tStatusMap = new HashMap<>();
			String tStatus;
			Integer count = 0;
			List<ApiCountKeyValue> apiCountKeyValues = tApiCountList.stream().filter(x->x.getApprovedStatus().equals(tApprovedStatus.getId())).collect(Collectors.toList());
			if (CollUtil.isNotEmpty(apiCountKeyValues)) {
				count = apiCountKeyValues.get(0).getApiCount();
			}
			switch(tLocale){
				case ApimgmtConstant.ZH_CN:
					tStatus = tApprovedStatus.getNameZhCn();
					break;
				case ApimgmtConstant.ZH_TW:
					tStatus = tApprovedStatus.getNameZhTw();
					break;
				case ApimgmtConstant.EN_US:
				default:
					tStatus = tApprovedStatus.getNameEnUs();
					break;
			}
			tStatusMap.put(ApimgmtConstant.ID, tApprovedStatus.getId());
			tStatusMap.put(ApimgmtConstant.STATUS, tStatus);
			tStatusMap.put(ApimgmtConstant.COUNT, count);
			tResponse.add(tStatusMap);
		}
		return tResponse;
	}

}
