package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtProjectVersionMapper;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;
import java.util.Set;

@Primary
@Repository
@Transactional
public class ApiMgmtProjectVersionDaoMybatisImpl extends GenericDaoMybatisImpl<ApiMgmtProjectVersionMapper, ProjectVersion, Long>
        implements ApiMgmtProjectVersionDao {

    public ApiMgmtProjectVersionDaoMybatisImpl() {
        super();
    }

    @Override
    public List<ProjectVersion> getByProjectId(Long projectId) {
        LambdaQueryWrapper<ProjectVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersion::getProjectId, projectId);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersion> getByProjectVersionName(String projectVersionName) {
        LambdaQueryWrapper<ProjectVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersion::getProjectVersionName, projectVersionName);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersion> getByProjectVersionNames(List<String> projectVersionNames) {
        if (CollUtil.isEmpty(projectVersionNames)) {
            return Collections.emptyList();
        }

        LambdaQueryWrapper<ProjectVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ProjectVersion::getProjectVersionName, projectVersionNames);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersion> getByProjectVersionNames(Long projectId, List<String> projectVersionNames) {
        if (CollUtil.isEmpty(projectVersionNames)) {
            return Collections.emptyList();
        }

        LambdaQueryWrapper<ProjectVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersion::getProjectId, projectId)
                .in(ProjectVersion::getProjectVersionName, projectVersionNames);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersion> queryProjectVersionByIdList(List<Long> idList) {
        LambdaQueryWrapper<ProjectVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ProjectVersion::getProjectVersionId, idList);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public List<ProjectVersion> selectByProjectIds(List<Long> projectIds) {
        LambdaQueryWrapper<ProjectVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ProjectVersion::getProjectId, projectIds);
        return baseMapper.selectList(wrapper);
    }

    @Override
    public Integer deleteByIds(List<Long> projectVersionIds) {
        return baseMapper.deleteBatchIds(projectVersionIds);
    }

    @Override
    public void batchUpdate(List<ProjectVersion> updateVersionList) {
        batchSave(updateVersionList);
    }

    @Override
    public void deleteByProjectId(Long projectId) {
        LambdaQueryWrapper<ProjectVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectVersion::getProjectId, projectId);
        baseMapper.delete(wrapper);
    }

    @Override
    public void batchSave(List<ProjectVersion> projectVersionList) {
        CollUtil.split(projectVersionList, 50)
                .forEach(list -> baseMapper.batchSave(list));
    }

    @Override
    public Set<Long> selectExistProjectId(List<Long> projectIds) {
        return baseMapper.selectExistProjectId(projectIds);
    }
}
