package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import cn.afterturn.easypoi.excel.annotation.Excel;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * The persistent class for the standard_data_name database table.
 * 
 */
@TableName("standard_data_name")
public class StandardDataName implements Serializable {
	private static final long serialVersionUID = 1L;

	@TableId
	@Excel(name = "名稱", width = 25)
	private String dataName;

	@TableField("approved_acct")
	private String approvedAcct;

	@TableField("approved_status")
	private Long approvedStatus;

	@TableField("approved_time")
    private LocalDateTime approvedTime;

	@TableField("build_acct")
	private String buildAcct;

	@TableField("build_time")
    private LocalDateTime buildTime;

	@TableField("description_zh_tw")
	@Excel(name = "說明(繁中)", width = 25)
	private String descriptionZhTw;

	@Excel(name = "分類(繁中)", width = 25)
	@TableField("type_zh_tw")
	private String typeZhTw;

	@TableField("description_zh_cn")
	@Excel(name = "说明(简中)", width = 25)
	private String descriptionZhCn;

	@TableField("type_zh_cn")
	@Excel(name = "分类(简中)", width = 25)
	private String typeZhCn;

	@TableField("description_en_us")
	@Excel(name = "說明(英文)", width = 25)
	private String descriptionEnUs;

	@TableField("type_en_us")
	@Excel(name = "分類(英文)", width = 25)
	private String typeEnUs;

	@TableField("last_update_time")
    private LocalDateTime lastUpdateTime;

	@TableField("tag_zh_cn")
	private String tagZhCn;

	@TableField("tag_zh_tw")
	private String tagZhTw;

	@TableField("tag_en_us")
	private String tagEnUs;

	@TableField("unit_or_default_en_us")
	private String unitOrDefaultEnUs;

	@TableField("unit_or_default_zh_cn")
	private String unitOrDefaultZhCn;

	@Excel(name = "類別", width = 25)
	@TableField("unit_or_default_zh_tw")
	private String unitOrDefaultZhTw;
	
	@TableField("remark_en_us")
	private String remarkEnUs;

	@TableField("remark_zh_cn")
	private String remarkZhCn;

	@Excel(name = "備註", width = 25)
	@TableField("remark_zh_tw")
	private String remarkZhTw;

	@TableField("dirty")
	private Boolean dirty;

	public StandardDataName() {
	}

	public String getDataName() {
		return this.dataName;
	}

	public void setDataName(String dataName) {
		this.dataName = dataName;
	}

	public String getApprovedAcct() {
		return this.approvedAcct;
	}

	public void setApprovedAcct(String approvedAcct) {
		this.approvedAcct = approvedAcct;
	}

	public Long getApprovedStatus() {
		return this.approvedStatus;
	}

	public void setApprovedStatus(Long approvedStatus) {
		this.approvedStatus = approvedStatus;
	}

    public LocalDateTime getApprovedTime() {
		return this.approvedTime;
	}

    public void setApprovedTime(LocalDateTime approvedTime) {
		this.approvedTime = approvedTime;
	}

	public String getBuildAcct() {
		return this.buildAcct;
	}

	public void setBuildAcct(String buildAcct) {
		this.buildAcct = buildAcct;
	}

    public LocalDateTime getBuildTime() {
		return this.buildTime;
	}

    public void setBuildTime(LocalDateTime buildTime) {
		this.buildTime = buildTime;
	}

	public String getDescriptionEnUs() {
		return this.descriptionEnUs;
	}

	public void setDescriptionEnUs(String descriptionEnUs) {
		this.descriptionEnUs = descriptionEnUs;
	}

	public String getDescriptionZhCn() {
		return this.descriptionZhCn;
	}

	public void setDescriptionZhCn(String descriptionZhCn) {
		this.descriptionZhCn = descriptionZhCn;
	}

	public String getDescriptionZhTw() {
		return this.descriptionZhTw;
	}

	public void setDescriptionZhTw(String descriptionZhTw) {
		this.descriptionZhTw = descriptionZhTw;
	}

    public LocalDateTime getLastUpdateTime() {
		return this.lastUpdateTime;
	}

    public void setLastUpdateTime(LocalDateTime lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public String getTagEnUs() {
		return this.tagEnUs;
	}

	public void setTagEnUs(String tagEnUs) {
		this.tagEnUs = tagEnUs;
	}

	public String getTagZhCn() {
		return this.tagZhCn;
	}

	public void setTagZhCn(String tagZhCn) {
		this.tagZhCn = tagZhCn;
	}

	public String getTagZhTw() {
		return this.tagZhTw;
	}

	public void setTagZhTw(String tagZhTw) {
		this.tagZhTw = tagZhTw;
	}
	
	public String getRemarkEnUs() {
		return this.remarkEnUs;
	}

	public void setRemarkEnUs(String remarkEnUs) {
		this.remarkEnUs = remarkEnUs;
	}

	public String getRemarkZhCn() {
		return this.remarkZhCn;
	}

	public void setRemarkZhCn(String remarkZhCn) {
		this.remarkZhCn = remarkZhCn;
	}

	public String getRemarkZhTw() {
		return this.remarkZhTw;
	}

	public void setRemarkZhTw(String remarkZhTw) {
		this.remarkZhTw = remarkZhTw;
	}

	public String getUnitOrDefaultEnUs() {
		return this.unitOrDefaultEnUs;
	}

	public void setUnitOrDefaultEnUs(String unitOrDefaultEnUs) {
		this.unitOrDefaultEnUs = unitOrDefaultEnUs;
	}

	public String getUnitOrDefaultZhCn() {
		return this.unitOrDefaultZhCn;
	}

	public void setUnitOrDefaultZhCn(String unitOrDefaultZhCn) {
		this.unitOrDefaultZhCn = unitOrDefaultZhCn;
	}

	public String getUnitOrDefaultZhTw() {
		return this.unitOrDefaultZhTw;
	}

	public void setUnitOrDefaultZhTw(String unitOrDefaultZhTw) {
		this.unitOrDefaultZhTw = unitOrDefaultZhTw;
	}

	public String getTypeZhTw() {
		return typeZhTw;
	}

	public void setTypeZhTw(String typeZhTw) {
		this.typeZhTw = typeZhTw;
	}
	
	public String getTypeZhCn() {
		return typeZhCn;
	}

	public void setTypeZhCn(String typeZhCn) {
		this.typeZhCn = typeZhCn;
	}
	
	public String getTypeEnUs() {
		return typeEnUs;
	}

	public void setTypeEnUs(String typeEnUs) {
		this.typeEnUs = typeEnUs;
	}
	
	public Boolean getDirty() {
		return this.dirty;
	}

	public void setDirty(Boolean dirty) {
		this.dirty = dirty;
	}

}