package com.digiwin.athena.apimgmt.service.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.services.ApiMgmtDevelopmentPlatformService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 开发平台处理类util
 */
@Service
public class DevelopmentPlatformServiceUtil extends GenericServiceUtil<ApiMgmtDevelopmentPlatformService> {

    private static final Logger log = LoggerFactory.getLogger(DevelopmentPlatformServiceUtil.class);
    private static ApiMgmtDevelopmentPlatformService service;

    @Override
    @Autowired
    public void setService(ApiMgmtDevelopmentPlatformService pService) {
        service = pService;
    }

    public static void sendApiToDevelopmentPlatform(StandardApiVersion tStandardApiVersion) throws Exception {
        //非esp的API不需要同步
        if (StringUtils.isNoneBlank(tStandardApiVersion.getStandardApi().getApiType()) && !ApimgmtConstant.DEFAULT_API_TYPE.equals(tStandardApiVersion.getStandardApi().getApiType())) {
            log.info("非esp的API不需要同步,apiName={}", tStandardApiVersion.getStandardApi().getName());
            return;
        }
        service.sendApiToDevelopmentPlatform(tStandardApiVersion);
    }

    public static List<String> getWithAuthList(String pUserToken, String type) throws Exception {
        JSONObject jsonObject = service.getWithAuthList(pUserToken, type);
        JSONObject data = jsonObject.getJSONObject("data");
        if (null != data) {
            Object obj = data.get("obj");
            if (null != obj) {
                return (List<String>) obj;
            }
        }
        return new ArrayList<>();
    }

}
