package com.digiwin.athena.apimgmt.service.util;

import java.util.Map;

import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.athena.apimgmt.services.ApiMgmtIamVerifyService;

/**
 * IAM处理类util
 * @apiNote 禁止业务层调用，使用{@link ApiMgmtServiceContextHolder}
 */
@Service
public class IamVerifyServiceUtil extends GenericServiceUtil<ApiMgmtIamVerifyService> {

	private static ApiMgmtIamVerifyService service;

	@Override
	@Autowired
	public void setService(ApiMgmtIamVerifyService pService) {
		service = pService;
	}

	public static String getUserId(String pUserToken) throws Exception {
		return service.getUserId(pUserToken);
	}

	public static String getTenantId(String pUserToken) throws Exception {
		return service.getTenantId(pUserToken);
	}

	public static String getUserName(String pUserToken) throws Exception {
		return service.getUserName(pUserToken);
	}

	public static Map<String, String> getUserInfo(String pUserToken) throws Exception {
		return service.getUserInfo(pUserToken);
	}

	public static String getTeamId(String pUserToken) throws Exception {
		return service.getTeamId(pUserToken);
	}

	public static String getIntegrationToken(String tenantId) throws Exception {
		return service.getIntegrationToken(tenantId);
	}

	/**
	 * 获取teamType
	 * 1或者4属于内部返回1
	 * 其他属于外部返回2
	 * @param teamId teamId
	 * @return String
	 */
	public static String getTeamType(String teamId) {
		if (null == teamId) {
			return null;
		}
		return "1".equals(teamId) || "4".equals(teamId) ? "1" : "2";
	}
	
}
