package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtInterfaceConstant;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.ApiMetaData;
import com.digiwin.athena.apimgmt.util.DateUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 开发平台-同步api
 */
@Slf4j
@Service
public class ApiMgmtDevelopmentPlatformService {


    ObjectMapper mapper = new ObjectMapper();

    @Autowired
    private ApiMgmtSyncMdcAddService syncMdcAddService;

    @Autowired
    private ApiMgmtProp prop;

    /**
     * api发送开发平台
     *
     * @param tStandardApiVersion tStandardApiVersion
     */
    public void sendApiToDevelopmentPlatform(StandardApiVersion tStandardApiVersion) throws Exception {
        try {
            String pUserToken = ApiMgmtServiceContextHolder.getToken();

            String value = sendDpMessage(tStandardApiVersion);
            log.info("同步开发平台数据信息: " + value);
            HttpRequest tHttpPost = HttpRequest.ofPost(URLUtil.completeUrl(ApiMgmtApplicationParameter._DEV_PLATE_URL,
                    ApimgmtInterfaceConstant.DEV_PLATE_API_PATH));
            tHttpPost.setEntity(value);
            tHttpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
            tHttpPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_USER, pUserToken);
            tHttpPost.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
            tHttpPost.setHeader(ApimgmtConstant.TOKEN, pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tHttpPost.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
            }
            String responseMessage = HttpUtil.execute(tHttpPost, String.class);
            log.info("同步开发平台成功: " + responseMessage);
        } catch (Exception e) {
            log.error("同步开发平台api异常：" + e.getMessage(), e);
            throw new Exception("同步开发平台api异常");
        }

    }

    /**
     * 获取开发平台白名单配置
     */
    public JSONObject getWithAuthList(String pUserToken, String type) throws Exception {
        try {
            HttpRequest tHttpGet = HttpRequest.ofGet(URLUtil.completeUrl(ApiMgmtApplicationParameter._DEV_PLATE_URL,
                    ApimgmtInterfaceConstant.DEV_PLATE_PRESET_DATA_PATH + "?key=" + type));
            tHttpGet.setHeader("Content-Type", "application/json;charset=UTF-8");
            tHttpGet.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_USER, pUserToken);
            tHttpGet.setHeader(ApimgmtConstant.DIGI_MIDDLEWARE_AUTH_APP, prop.getIamToken());
            tHttpGet.setHeader(ApimgmtConstant.TOKEN, pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tHttpGet.setHeader(ApimgmtConstant.ROUTER_KEY, ApiMgmtServiceContextHolder.getRouterKey());
            }
            JSONObject responseMessage = HttpUtil.execute(tHttpGet, JSONObject.class);
            log.info("获取开发平台数据成功: " + responseMessage);
            return responseMessage;
        } catch (Exception e) {
            log.error("获取开发平台数据异常：" + e.getMessage(), e);
            throw new Exception("获取开发平台数据异常");
        }

    }

    /**
     * 推送开发平台消息体
     *
     * @param tStandardApiVersion api数据
     * @return String
     */
    private String sendDpMessage(StandardApiVersion tStandardApiVersion) {
        StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
        // 建立data節點
        ObjectNode tApiMetadataNode = mapper.createObjectNode();
        tApiMetadataNode.put(ApimgmtConstant.API_NAME_DP, tStandardApi.getName());
        // 如果API的tenant_id欄位有值則外顯
        if (null != tStandardApi.getTenantId()) {
            tApiMetadataNode.put(ApimgmtConstant.TENANT_ID, tStandardApi.getTenantId());
            // 如果package_name欄位有值則外顯
            if (null != tStandardApi.getPackageName()) {
                tApiMetadataNode.put(ApimgmtConstant.PACKAGE_NAME, tStandardApi.getPackageName());
            }
        }
        tApiMetadataNode.put(ApimgmtConstant.TIMESTAMP, DateUtil.formatToSimpleSecond(new Date()));
        tApiMetadataNode.put(ApimgmtConstant.ACTION, "add");
        tApiMetadataNode.put(ApimgmtConstant.INVOKED_TYPE, tStandardApi.getStandardApiSyncType().getNameEnUs());
        tApiMetadataNode.put(ApimgmtConstant.CATEGORY, tStandardApi.getStandardApiCategory().getNameZhTw());
        ObjectNode tDescriptionNode = mapper.createObjectNode();
        tDescriptionNode.put(ApimgmtConstant.ZH_TW, tStandardApi.getDescriptionZhTw());
        tDescriptionNode.put(ApimgmtConstant.ZH_CN, tStandardApi.getDescriptionZhCn());
        tDescriptionNode.put(ApimgmtConstant.EN_US, tStandardApi.getDescriptionEnUs());
        tApiMetadataNode.set(ApimgmtConstant.DESCRIPTION, tDescriptionNode);
        ObjectNode tRemarkNode = mapper.createObjectNode();
        tRemarkNode.put(ApimgmtConstant.ZH_TW, tStandardApi.getRemarkZhTw());
        tRemarkNode.put(ApimgmtConstant.ZH_CN, tStandardApi.getRemarkZhCn());
        tRemarkNode.put(ApimgmtConstant.EN_US, tStandardApi.getRemarkEnUs());
        tApiMetadataNode.set(ApimgmtConstant.REMARK, tRemarkNode);
        ApiMetaData apiMetaData = syncMdcAddService.CreateApiMetaData(tStandardApiVersion.getId());
        tApiMetadataNode.put(ApimgmtConstant.API_VERSION_DP, tStandardApiVersion.getVersion());
        tApiMetadataNode.put(ApimgmtConstant.URL, prop.getEaiUrl() + "/CROSS/RESTful");
        tApiMetadataNode.set(ApimgmtConstant.DATA_METADATA, mapper.valueToTree(apiMetaData));
        tApiMetadataNode.put(ApimgmtConstant.IDEMPOTENCY, tStandardApiVersion.getIdempotency());
        tApiMetadataNode.put(ApimgmtConstant.API_EXTEND, tStandardApi.getApiExtend());
        return tApiMetadataNode.toString();
    }
}
