package com.digiwin.athena.apimgmt.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.StandardApiColumnTypeConstants;
import com.digiwin.athena.apimgmt.constants.StandardApiMessageTypeConstants;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;

/**
 * Neville-Hsieh 2017/11/25 標準API訊息產生工具(XML or JSON)
 */
public class StandardApiMessageUtil {

    public static Map<Integer, List<StandardApiDataName>> getMsgTypeMap(List<StandardApiDataName> plistOfNodes) {
        Map<Integer, List<StandardApiDataName>> tMap = new HashMap<>();
        List<StandardApiDataName> tlistOfHierarchyNodesRequest = new ArrayList<>();
        List<StandardApiDataName> tlistOfHierarchyNodesResponseSuccess = new ArrayList<>();
        List<StandardApiDataName> tlistOfHierarchyNodesResponseFailed = new ArrayList<>();
        for (StandardApiDataName tApiDataName : plistOfNodes) {
            switch (tApiDataName.getMsgType()) {
                case StandardApiMessageTypeConstants.REQUEST:
                    tlistOfHierarchyNodesRequest.add(tApiDataName);
                    break;
                case StandardApiMessageTypeConstants.RESPONSE_SUCCESS:
                    tlistOfHierarchyNodesResponseSuccess.add(tApiDataName);
                    break;
                case StandardApiMessageTypeConstants.RESPONSE_FAILED:
                    tlistOfHierarchyNodesResponseFailed.add(tApiDataName);
                    break;
                default:
                    break;
            }
        }
        tMap.put(1, tlistOfHierarchyNodesRequest);
        tMap.put(2, tlistOfHierarchyNodesResponseSuccess);
        tMap.put(3, tlistOfHierarchyNodesResponseFailed);
        return tMap;

    }

    /**
     * 判斷StandardApiDataName是否有父階層
     */
    public static List<StandardApiDataName> generateListOfHierarchyNodes(List<StandardApiDataName> pListOfNodes, Long pApVerid) {
        // 去重
        pListOfNodes = pListOfNodes.stream().distinct().collect(Collectors.toList());
        List<StandardApiDataName> listOfHierarchyNodes = new ArrayList<>();
        for (StandardApiDataName tApiDataName : pListOfNodes) {
            if (tApiDataName.getParentId() == null) {
                if (null != pApVerid) {
                    addAllNodes(tApiDataName, pListOfNodes);
                }
                listOfHierarchyNodes.add(tApiDataName);
            }
        }
        return listOfHierarchyNodes;
    }

    private static void addAllNodes(StandardApiDataName pParent, List<StandardApiDataName> pListOfNodes) {
        List<StandardApiDataName> tChildrens = new ArrayList<>();
        for (StandardApiDataName tApiDataName : pListOfNodes) {
            // 每一次檢查是子node就先放到這個暫存的List<StandardApiDataName>
            if (tApiDataName.getParentId() != null) {
                if (pParent.getId().equals(tApiDataName.getParentId())) {
                    tChildrens.add(tApiDataName);
                    addAllNodes(tApiDataName, pListOfNodes);
                }
            }
        }
        pParent.setChildrens(tChildrens);
    }

    public static List<StandardApiDataName> filterOutHierarchyNodesForParameter(List<StandardApiDataName> pListOfHierarchyNodes) {
        ArrayList<StandardApiDataName> tNewListOfHierarchyNodes = new ArrayList<>();
        for (StandardApiDataName tStandardApiDataName : pListOfHierarchyNodes) {
            if (!(tStandardApiDataName.getColumnType().equals(StandardApiColumnTypeConstants.DATAKEY_CONSTANTS)) && !(tStandardApiDataName.getColumnType().equals(StandardApiColumnTypeConstants.HEADER_CONSTANTS)) && !(tStandardApiDataName.getColumnType().equals(StandardApiColumnTypeConstants.EXECUTION_CONSTANTS))) {
                tNewListOfHierarchyNodes.add(tStandardApiDataName);
            }
        }
        return tNewListOfHierarchyNodes;
    }

    public static List<StandardApiDataName> filterHierarchyNodes(List<StandardApiDataName> pListOfHierarchyNodes, String StandardApiColumnTypeConstantsString) {
        ArrayList<StandardApiDataName> tNewListOfHierarchyNodes = new ArrayList<>();
        for (StandardApiDataName tStandardApiDataName : pListOfHierarchyNodes) {
            if (tStandardApiDataName.getColumnType().equals(StandardApiColumnTypeConstantsString)) {
                tNewListOfHierarchyNodes.add(tStandardApiDataName);
            }
        }
        return tNewListOfHierarchyNodes;
    }

    public static List<List<AdvanceSearchValue>> generateQuery(ArrayNode tConditionArrayNode, JsonNode tCategoryId,
                                                               JsonNode tStatusId, JsonNode tType, JsonNode projectId, JsonNode projectVersionId, String tUserId) {
        // 除分组的第一个节点,每个节点的mark属性代表当前节点的操作标识(and|or)
        // 分组的第一个节,配置的mark属性为分组主体的筛选字段, 默认为and
        // 分组的情况下且只存在一个节点情况下则没有bracket属性,多个节点则首尾节点存在bracket("("|")")属性
        List<List<AdvanceSearchValue>> arrayList = new ArrayList<>();
        List<AdvanceSearchValue> advanceSearchValueList = new ArrayList<>();
        boolean bracketJudge = false; // 不在括号内
        int bracketOrder = 0;
        for (int i = 0; i < tConditionArrayNode.size(); i++) {
            JsonNode tConditionNode = tConditionArrayNode.get(i);
            JsonNode bracket = tConditionNode.get(ApimgmtConstant.BRACKET);
            JsonNode mark = tConditionNode.get(ApimgmtConstant.MARK);
            // 单一节点(不在范围节点内)
            if (null == bracket && !bracketJudge) {
                advanceSearchValueList = new ArrayList<>();
                advanceSearchValueList.add(new AdvanceSearchValue(
                        tConditionNode.get(ApimgmtConstant.CONTENT).asText(),
                        tConditionNode.get(ApimgmtConstant.EQUATION).asText(),
                        null == mark ? ApimgmtConstant.MARK_AND : mark.asText(),
                        tConditionNode.get(ApimgmtConstant.CONDITION).asText(),
                        0));
                arrayList.add(advanceSearchValueList);
                continue;
            } else if (null != bracket && bracket.asText().equals("(")) {
                // 范围节点
                bracketOrder = 0;
                bracketJudge = true;
                advanceSearchValueList = new ArrayList<>();
            }
            advanceSearchValueList.add(new AdvanceSearchValue(
                    tConditionNode.get(ApimgmtConstant.CONTENT).asText(),
                    tConditionNode.get(ApimgmtConstant.EQUATION).asText(),
                    null == mark ? ApimgmtConstant.MARK_AND : mark.asText(),
                    tConditionNode.get(ApimgmtConstant.CONDITION).asText(),
                    bracketOrder)
            );
            bracketOrder++;
            if (null != bracket && bracket.asText().equals(")")) {
                bracketOrder = 0;
                bracketJudge = false;
                arrayList.add(advanceSearchValueList);
            }
        }
        // 服务于标准查询
        if (null != tCategoryId && !StringUtil.isEmptyOrSpace(tCategoryId.asText())) {
            advanceSearchValueList = new ArrayList<>();
            advanceSearchValueList.add(new AdvanceSearchValue(
                    tCategoryId.asText(),
                    ApimgmtConstant.EQUAL,
                    ApimgmtConstant.MARK_AND,
                    ApimgmtConstant.API_CATEGORY,
                    0));
            arrayList.add(advanceSearchValueList);
        }
        // 服务于设计查询
        if (null != tStatusId && !StringUtil.isEmptyOrSpace(tStatusId.asText())) {
            advanceSearchValueList = new ArrayList<>();
            advanceSearchValueList.add(new AdvanceSearchValue(
                    tStatusId.asText(),
                    ApimgmtConstant.EQUAL,
                    ApimgmtConstant.MARK_AND,
                    ApimgmtConstant.API_STATUS,
                    0));
            arrayList.add(advanceSearchValueList);
        }
        // 服务于设计查询
        if (null != tType && tType.asBoolean() && null != tUserId) {
            advanceSearchValueList = new ArrayList<>();
            advanceSearchValueList.add(new AdvanceSearchValue(
                    tUserId,
                    ApimgmtConstant.EQUAL,
                    ApimgmtConstant.MARK_AND,
                    ApimgmtConstant.USER_ID,
                    0));
            arrayList.add(advanceSearchValueList);
        }
        if (null != projectId && !StringUtil.isEmptyOrSpace(projectId.asText())) {
            advanceSearchValueList = new ArrayList<>();
            advanceSearchValueList.add(new AdvanceSearchValue(
                    projectId.asText(),
                    ApimgmtConstant.EQUAL,
                    ApimgmtConstant.MARK_AND,
                    ApimgmtConstant.PROJECT_ID,
                    0));
            arrayList.add(advanceSearchValueList);
        }
        if (null != projectVersionId && !StringUtil.isEmptyOrSpace(projectVersionId.asText())) {
            advanceSearchValueList = new ArrayList<>();
            advanceSearchValueList.add(new AdvanceSearchValue(
                    projectVersionId.asText(),
                    ApimgmtConstant.EQUAL,
                    ApimgmtConstant.MARK_AND,
                    ApimgmtConstant.PROJECT_VERSION_ID,
                    0));

            advanceSearchValueList.add(new AdvanceSearchValue(
                    null,
                    ApimgmtConstant.IS,
                    ApimgmtConstant.MARK_OR,
                    ApimgmtConstant.PROJECT_VERSION_ID,
                    1));
            arrayList.add(advanceSearchValueList);
        }
//        if (null != apiType && !StringUtil.isEmptyOrSpace(apiType.asText())) {
//            advanceSearchValueList = new ArrayList<>();
//            advanceSearchValueList.add(new AdvanceSearchValue(
//                    apiType.asText(),
//                    ApimgmtConstant.EQUAL,
//                    ApimgmtConstant.MARK_AND,
//                    ApimgmtConstant.API_TYPE,
//                    0));
//            arrayList.add(advanceSearchValueList);
//        }
        return arrayList;
    }
}
