/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.apiservice;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtStandardDataExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardDataExportService.class);
    @Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;

    public synchronized Object execute() throws BaseException {
        ArrayList<Map<String, Object>> sheetsList = new ArrayList<Map<String, Object>>();
        try {
            String time = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss").format(Calendar.getInstance().getTime());
            List<StandardDataName> unApprovedList = this.standardDataNameDao.getDataNameByApprovedStatus(1L, false);
            this.export(unApprovedList, sheetsList);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Workbook workBook = ExcelExportUtil.exportExcel(sheetsList, (ExcelType)ExcelType.HSSF);
            workBook.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            Map responseHeader = ApiMgmtServiceContextHolder.getResponseHeader();
            responseHeader.put("Content-Type", MediaType.APPLICATION_OCTET_STREAM);
            responseHeader.put("Content-Disposition", "attachment;filename=" + time + ".xlsx");
            responseHeader.put("Access-Control-Expose-Headers", "Content-Disposition");
            responseHeader.put("Character-Encoding", "utf-8");
            return bytes;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private <T> void export(List<T> list, List<Map<String, Object>> sheetsList) {
        ExportParams deptExportParams = new ExportParams();
        deptExportParams.setSheetName("\u8fad\u5f59\u6e05\u55ae_\u5be9\u68381");
        HashMap<String, Object> deptExportMap = new HashMap<String, Object>();
        deptExportMap.put("title", deptExportParams);
        deptExportMap.put("entity", StandardDataName.class);
        deptExportMap.put("data", list);
        sheetsList.add(deptExportMap);
    }
}

