/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectVersionRelationDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.GenericDaoMybatisImpl;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.MpPage;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.WhereCondition;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiMapper;
import com.digiwin.athena.apimgmt.model.AdvanceSearchValue;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.Page;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Repository
public class ApiMgmtStandardApiDaoMybatisImpl
extends GenericDaoMybatisImpl<ApiMgmtStandardApiMapper, StandardApi, Long>
implements ApiMgmtStandardApiDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardApiDaoMybatisImpl.class);
    private ApiMgmtProjectVersionRelationDao projectVersionRelationDao;

    @Override
    public List<StandardApi> advanceSearch(ArrayList<Map<String, String>> pConditionList, String teamType, boolean searchType, boolean tViewAllApi) {
        List<WhereCondition> conditionList = DaoConverter.INSTANCE.toWhereCondition(pConditionList);
        String tenantId = pConditionList.stream().map(v -> (String)v.get("tenant")).filter(Objects::nonNull).findFirst().orElse(null);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).advanceSearch(conditionList, tenantId, teamType, searchType, tViewAllApi);
    }

    @Override
    public List<StandardApi> getByNameAndTenantId(String pName, String pTenantId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(StandardApi::getName, (Object)pName)).eq(StandardApi::getTenantId, (Object)pTenantId);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<StandardApi> getListByNameAndBranchAndTenantId(String pName, String branch, String pTenantId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(StandardApi::getName, (Object)pName)).eq(StandardApi::getBranch, (Object)branch)).eq(StandardApi::getTenantId, (Object)pTenantId);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public StandardApi getByNameAndBranchAndTenantId(String pName, String branch, String pTenantId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(StandardApi::getName, (Object)pName)).eq(StandardApi::getBranch, (Object)branch)).eq(StandardApi::getTenantId, (Object)pTenantId)).last("LIMIT 1");
        return (StandardApi)((ApiMgmtStandardApiMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public Page<StandardApiVersion> advanceApiSearch(List<List<AdvanceSearchValue>> pList, String teamType, String tenantId, boolean searchType, boolean tViewAllApi, Integer pageSize, Integer pageNum) {
        List<Long> versionIds;
        Page<StandardApiVersion> page = new Page<StandardApiVersion>();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        List<WhereCondition> conditions = DaoConverter.INSTANCE.convertToWhereCondition(pList);
        Long count = ((ApiMgmtStandardApiMapper)this.baseMapper).advanceApiSearchCount(conditions, teamType, tenantId, searchType, tViewAllApi);
        page.setPageTotal(count);
        if (count > 0L && (versionIds = ((ApiMgmtStandardApiMapper)this.baseMapper).advanceApiSearchVersionIds(conditions, teamType, tenantId, searchType, tViewAllApi, new MpPage(pageNum.intValue(), pageSize.intValue()))) != null && !versionIds.isEmpty()) {
            List<StandardApiVersion> versions = ((ApiMgmtStandardApiMapper)this.baseMapper).selectVersionsByIds(versionIds);
            page.setList(versions);
        }
        return page;
    }

    @Override
    public List<Long> advanceStandardApiCountSearch(List<List<AdvanceSearchValue>> pList, String teamType, String pTenantId, boolean tViewAllApi) {
        List<WhereCondition> conditions = DaoConverter.INSTANCE.convertToWhereCondition(pList);
        return ((ApiMgmtStandardApiMapper)this.baseMapper).advanceStandardApiCountSearch(conditions, teamType, pTenantId, false, tViewAllApi);
    }

    @Override
    @Transactional
    public StandardApi save(StandardApi pStandardApi, boolean cleanProjectRelation) {
        String tApiName = pStandardApi.getName();
        String tTenantId = pStandardApi.getTenantId();
        String branch = pStandardApi.getBranch();
        StandardApi existingApi = this.getByNameAndBranchAndTenantId(tApiName, branch, tTenantId);
        if (existingApi != null) {
            pStandardApi.setId(existingApi.getId());
            pStandardApi.setMsgMdata(existingApi.getMsgMdata());
            if (cleanProjectRelation) {
                this.projectVersionRelationDao.deleteByApiId(pStandardApi.getId());
            }
        }
        for (StandardApiVersion tVersion : pStandardApi.getStandardApiVersions()) {
            tVersion.setApprovedTime(LocalDateTime.now());
        }
        pStandardApi.setBuildTime(LocalDateTime.now());
        if (pStandardApi.getId() == null) {
            ((ApiMgmtStandardApiMapper)this.baseMapper).insert(pStandardApi);
        } else {
            ((ApiMgmtStandardApiMapper)this.baseMapper).updateById(pStandardApi);
        }
        log.info("\u5132\u5b58API. API\u540d\u7a31: " + pStandardApi.getName());
        return pStandardApi;
    }

    @Override
    public void delete(Long pId) {
        ((ApiMgmtStandardApiMapper)this.baseMapper).deleteById(pId);
    }

    @Autowired
    public void setProjectVersionRelationDao(ApiMgmtProjectVersionRelationDao projectVersionRelationDao) {
        this.projectVersionRelationDao = projectVersionRelationDao;
    }

    public static class DaoConverter {
        public static final Map<String, String> fieldMapping = new HashMap<String, String>();
        public static final Map<String, WhereCondition.Type> typeMapping = new HashMap<String, WhereCondition.Type>();
        public static DaoConverter INSTANCE = new DaoConverter();

        public List<WhereCondition> convertToWhereCondition(List<List<AdvanceSearchValue>> pList) {
            return pList.stream().flatMap(list -> {
                List<WhereCondition> child = list.stream().map(v -> WhereCondition.from(fieldMapping.get(v.getField()), typeMapping.getOrDefault(v.getField(), WhereCondition.Type.STRING), v)).collect(Collectors.toList());
                if (child.isEmpty()) {
                    return Stream.empty();
                }
                return Stream.of(WhereCondition.segment(((WhereCondition)child.get(0)).isAnd(), child));
            }).collect(Collectors.toList());
        }

        public List<WhereCondition> toWhereCondition(ArrayList<Map<String, String>> list) {
            return list.stream().flatMap(inMap -> fieldMapping.keySet().stream().map(field -> {
                String val = (String)inMap.get(field);
                if (val == null) {
                    return null;
                }
                String ops = (String)inMap.get(field + "_ops");
                if ("provider".equals(field)) {
                    ops = ops == null ? WhereCondition.Operator.LIKE.getOp() : ops;
                }
                AdvanceSearchValue searchValue = new AdvanceSearchValue(val, ops, "and", (String)field, 0);
                return WhereCondition.from(fieldMapping.get(field), typeMapping.getOrDefault(field, WhereCondition.Type.STRING), searchValue);
            }).filter(Objects::nonNull)).collect(Collectors.toList());
        }

        static {
            fieldMapping.put("apiName", "stdapi.name");
            fieldMapping.put("apiType", "stdapi.api_type");
            fieldMapping.put("projectId", "pvr.project_id");
            fieldMapping.put("projectVersionId", "pvr.project_version_id");
            fieldMapping.put("apiStatus", "astat.id");
            fieldMapping.put("apiTag", "stdapi.tag");
            typeMapping.put("apiTag", WhereCondition.Type.MULTI_LANG);
            fieldMapping.put("apiDataName", "stdapidataname.api_ver_id");
            fieldMapping.put("apiDescription", "stdapi.description");
            typeMapping.put("apiDescription", WhereCondition.Type.MULTI_LANG);
            fieldMapping.put("apiRemark", "stdapi.remark");
            typeMapping.put("apiRemark", WhereCondition.Type.MULTI_LANG);
            fieldMapping.put("apiSyncType", "stdapist.id");
            fieldMapping.put("apiCategory", "stdapicat.id");
            fieldMapping.put("provider", "stdapi.provider");
            fieldMapping.put("requester", "stdapi.requester");
            fieldMapping.put("tenantId", "stdapi.tenant_id");
            fieldMapping.put("apiBuildTime", "stdapi.build_time");
            typeMapping.put("apiBuildTime", WhereCondition.Type.DATE);
            fieldMapping.put("userId", "stdapiver.user_id");
        }
    }
}

