/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.service.model.ApiMetaData;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcAddService;
import com.digiwin.athena.apimgmt.util.DateUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtDevelopmentPlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtDevelopmentPlatformService.class);
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private ApiMgmtSyncMdcAddService syncMdcAddService;
    @Autowired
    private ApiMgmtProp prop;

    public void sendApiToDevelopmentPlatform(StandardApiVersion tStandardApiVersion) throws Exception {
        try {
            String pUserToken = ApiMgmtServiceContextHolder.getToken();
            String value = this.sendDpMessage(tStandardApiVersion);
            log.info("\u540c\u6b65\u5f00\u53d1\u5e73\u53f0\u6570\u636e\u4fe1\u606f: " + value);
            HttpRequest tHttpPost = HttpRequest.ofPost((String)URLUtil.completeUrl((String)ApiMgmtApplicationParameter._DEV_PLATE_URL, (String)"/athena-designer/apiMetadata/upsertApiToDev"));
            tHttpPost.setEntity((Object)value);
            tHttpPost.setHeader("Content-Type", (Object)"application/json;charset=UTF-8");
            tHttpPost.setHeader("digi-middleware-auth-user", (Object)pUserToken);
            tHttpPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tHttpPost.setHeader("token", (Object)pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tHttpPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            String responseMessage = (String)HttpUtil.execute((HttpRequest)tHttpPost, String.class);
            log.info("\u540c\u6b65\u5f00\u53d1\u5e73\u53f0\u6210\u529f: " + responseMessage);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5f00\u53d1\u5e73\u53f0api\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new Exception("\u540c\u6b65\u5f00\u53d1\u5e73\u53f0api\u5f02\u5e38");
        }
    }

    public JSONObject getWithAuthList(String pUserToken, String type) throws Exception {
        try {
            HttpRequest tHttpGet = HttpRequest.ofGet((String)URLUtil.completeUrl((String)ApiMgmtApplicationParameter._DEV_PLATE_URL, (String)("/athena-designer/presetData/getPresetDataObject?key=" + type)));
            tHttpGet.setHeader("Content-Type", (Object)"application/json;charset=UTF-8");
            tHttpGet.setHeader("digi-middleware-auth-user", (Object)pUserToken);
            tHttpGet.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tHttpGet.setHeader("token", (Object)pUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tHttpGet.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            JSONObject responseMessage = (JSONObject)HttpUtil.execute((HttpRequest)tHttpGet, JSONObject.class);
            log.info("\u83b7\u53d6\u5f00\u53d1\u5e73\u53f0\u6570\u636e\u6210\u529f: " + responseMessage);
            return responseMessage;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f00\u53d1\u5e73\u53f0\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new Exception("\u83b7\u53d6\u5f00\u53d1\u5e73\u53f0\u6570\u636e\u5f02\u5e38");
        }
    }

    private String sendDpMessage(StandardApiVersion tStandardApiVersion) {
        StandardApi tStandardApi = tStandardApiVersion.getStandardApi();
        ObjectNode tApiMetadataNode = this.mapper.createObjectNode();
        tApiMetadataNode.put("api_name", tStandardApi.getName());
        if (null != tStandardApi.getTenantId()) {
            tApiMetadataNode.put("tenantId", tStandardApi.getTenantId());
            if (null != tStandardApi.getPackageName()) {
                tApiMetadataNode.put("package_name", tStandardApi.getPackageName());
            }
        }
        tApiMetadataNode.put("timestamp", DateUtil.formatToSimpleSecond((Date)new Date()));
        tApiMetadataNode.put("action", "add");
        tApiMetadataNode.put("type", tStandardApi.getStandardApiSyncType().getNameEnUs());
        tApiMetadataNode.put("category", tStandardApi.getStandardApiCategory().getNameZhTw());
        ObjectNode tDescriptionNode = this.mapper.createObjectNode();
        tDescriptionNode.put("zh_TW", tStandardApi.getDescriptionZhTw());
        tDescriptionNode.put("zh_CN", tStandardApi.getDescriptionZhCn());
        tDescriptionNode.put("en_US", tStandardApi.getDescriptionEnUs());
        tApiMetadataNode.set("description", (JsonNode)tDescriptionNode);
        ObjectNode tRemarkNode = this.mapper.createObjectNode();
        tRemarkNode.put("zh_TW", tStandardApi.getRemarkZhTw());
        tRemarkNode.put("zh_CN", tStandardApi.getRemarkZhCn());
        tRemarkNode.put("en_US", tStandardApi.getRemarkEnUs());
        tApiMetadataNode.set("remark", (JsonNode)tRemarkNode);
        ApiMetaData apiMetaData = this.syncMdcAddService.CreateApiMetaData(tStandardApiVersion.getId());
        tApiMetadataNode.put("api_version", tStandardApiVersion.getVersion());
        tApiMetadataNode.put("url", this.prop.getEaiUrl() + "/CROSS/RESTful");
        tApiMetadataNode.set("data_metadata", this.mapper.valueToTree((Object)apiMetaData));
        tApiMetadataNode.put("idempotency", tStandardApiVersion.getIdempotency());
        tApiMetadataNode.put("api_extend", tStandardApi.getApiExtend());
        return tApiMetadataNode.toString();
    }
}

