/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.constants.ProtocolConstants;
import com.digiwin.athena.apimgmt.constants.RequestMethodConstants;
import com.digiwin.athena.apimgmt.constants.SyncTypeConstants;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiPagingDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.enums.APIExportImportEnums;
import com.digiwin.athena.apimgmt.enums.IsRequiredEnum;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiPaging;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import com.digiwin.athena.apimgmt.services.ApiMgmtProjectVersionService;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtStandardApiExportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardApiExportService.class);
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;
    @Autowired
    ApiMgmtStandardApiPagingDao standardApiPagingDao;
    @Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;
    @Autowired
    private ApiMgmtProjectDao projectDao;
    @Autowired
    private ApiMgmtProjectVersionService projectVersionService;

    public String exportStandardApi(StandardApiVersion pStandardApiVersion) {
        String tNewFilePath;
        try {
            HSSFWorkbook tHSSFWorkbook;
            File d = new File(ApiMgmtApplicationParameter._FILE_EXPORT_PATH);
            if (!d.exists()) {
                boolean mk = d.mkdir();
                log.info("\u521b\u5efa\u8def\u5f84\u6210\u529f" + mk);
            }
            if ((tHSSFWorkbook = this.getTemplateFile(true)) == null) {
                return APIExportImportEnums.UNKNOW_ERROR.toString();
            }
            this.createSheet(tHSSFWorkbook, pStandardApiVersion);
            Calendar tCalendar = Calendar.getInstance();
            tCalendar.setTime(new Date());
            SimpleDateFormat tFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            StandardApi tStandardApi = pStandardApiVersion.getStandardApi();
            String tNewFileName = "StdApi_" + tStandardApi.getName() + "_" + pStandardApiVersion.getVersion() + "_" + tFormat.format(tCalendar.getTimeInMillis()) + ".xls";
            tNewFilePath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + tNewFileName;
            FileOutputStream fileOut = new FileOutputStream(tNewFilePath);
            tHSSFWorkbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Catch exception when export Standard API file.");
            return APIExportImportEnums.UNKNOW_ERROR.toString();
        }
        return tNewFilePath;
    }

    public boolean removeFile(String filePath) {
        try {
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                return new File(filePath).delete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void createSheet(HSSFWorkbook pHSSFWorkbook, StandardApiVersion pStandardApiVersion) {
        StandardApi tStandardApi = pStandardApiVersion.getStandardApi();
        List<StandardApiDataName> tStandardApiDataNames = this.standardApiDataNameDao.getByApiVerId(pStandardApiVersion.getId(), true);
        tStandardApiDataNames = tStandardApiDataNames.stream().distinct().collect(Collectors.toList());
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageUtil.getMsgTypeMap(tStandardApiDataNames);
        int tRequestCount = tMsgTypeMap.get(1).size();
        int tResponseSuccessCount = tMsgTypeMap.get(2).size();
        int tResponseFaleseCount = tMsgTypeMap.get(3).size();
        HSSFSheet tDataSheet = pHSSFWorkbook.getSheetAt(1);
        HSSFSheet tTemplateSheet = pHSSFWorkbook.getSheetAt(4);
        HSSFSheet tNewSheet = pHSSFWorkbook.createSheet(tStandardApi.getName());
        this.setSheetWidthAndHight(tTemplateSheet, tNewSheet);
        this.createDropDownMenu(tDataSheet, tTemplateSheet, tNewSheet, tRequestCount, tResponseSuccessCount, tResponseFaleseCount);
        this.writeStandardAPI(pHSSFWorkbook, tTemplateSheet, tNewSheet, tStandardApi, pStandardApiVersion);
        this.writeStandardAPIDataName(pHSSFWorkbook, tTemplateSheet, tNewSheet, tMsgTypeMap, tStandardApiDataNames);
        int tNewSheetIdx = pHSSFWorkbook.getSheetIndex(tNewSheet.getSheetName());
        pHSSFWorkbook.setActiveSheet(tNewSheetIdx);
        pHSSFWorkbook.setSheetHidden(4, true);
    }

    private void createDropDownMenu(HSSFSheet pDataSheet, HSSFSheet pTemplateSheet, HSSFSheet pNewSheet, int pRequestCount, int pResponseSuccessCount, int pResponseFalseCount) {
        int tApiTypeCol = 24;
        int tRequestMethodCol = 26;
        int tSyncTypeCol = 6;
        int tPagingCol = 7;
        int tIsBtachCol = 10;
        int tGroupCol = 11;
        int tCategoryCol = 12;
        int tMsgFormatCol = 13;
        int tRequestFirstRow = 6;
        int tRequestLastRow = pRequestCount == 0 ? tRequestFirstRow + pRequestCount : tRequestFirstRow + pRequestCount - 1;
        int tResponseSuccessFirstRow = tRequestLastRow + 4;
        int tResponseSuccessLastRow = pResponseSuccessCount == 0 ? tResponseSuccessFirstRow + pResponseSuccessCount : tResponseSuccessFirstRow + pResponseSuccessCount - 1;
        int tResponseFalseFirstRow = tResponseSuccessLastRow + 4;
        int tResponseFalseLastRow = pResponseFalseCount == 0 ? tResponseFalseFirstRow + pResponseFalseCount : tResponseFalseFirstRow + pResponseFalseCount - 1;
        int tColumnTypeCol = 1;
        int tDataTypeCol = 5;
        int tIsRequiredCol = 6;
        int tIsDatakeyCol = 7;
        int tIsArrayCol = 8;
        int tCFCol = 4;
        CellRangeAddressList tApiTypeRegions = new CellRangeAddressList(2, 2, tApiTypeCol, tApiTypeCol);
        CellRangeAddressList tRequestMethodRegions = new CellRangeAddressList(2, 2, tRequestMethodCol, tRequestMethodCol);
        CellRangeAddressList tSyncTypeRegions = new CellRangeAddressList(2, 2, tSyncTypeCol, tSyncTypeCol);
        CellRangeAddressList tPagingRegions = new CellRangeAddressList(2, 2, tPagingCol, tPagingCol);
        CellRangeAddressList tIsBatchRegions = new CellRangeAddressList(2, 2, tIsBtachCol, tIsBtachCol);
        CellRangeAddressList tGroupRegions = new CellRangeAddressList(2, 2, tGroupCol, tGroupCol);
        CellRangeAddressList tCategoryRegions = new CellRangeAddressList(2, 2, tCategoryCol, tCategoryCol);
        CellRangeAddressList tMsgFormatRegions = new CellRangeAddressList(2, 2, tMsgFormatCol, tMsgFormatCol);
        CellRangeAddressList tRequestColumnTypeRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tColumnTypeCol, tColumnTypeCol);
        CellRangeAddressList tResponseSuccessColumnTypeRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tColumnTypeCol, tColumnTypeCol);
        CellRangeAddressList tResponseFalseColumnTypeRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tColumnTypeCol, tColumnTypeCol);
        CellRangeAddressList tRequestDataTypeRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tDataTypeCol, tDataTypeCol);
        CellRangeAddressList tResponseSuccessDataTypeRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tDataTypeCol, tDataTypeCol);
        CellRangeAddressList tResponseFalseDataTypeRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tDataTypeCol, tDataTypeCol);
        CellRangeAddressList tRequestIsRequiredRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tIsRequiredCol, tIsRequiredCol);
        CellRangeAddressList tResponseSuccessIsRequiredRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tIsRequiredCol, tIsRequiredCol);
        CellRangeAddressList tResponseFalseIsRequiredRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tIsRequiredCol, tIsRequiredCol);
        CellRangeAddressList tRequestIsDatakeyRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tIsDatakeyCol, tIsDatakeyCol);
        CellRangeAddressList tResponseSuccessIsDatakeyRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tIsDatakeyCol, tIsDatakeyCol);
        CellRangeAddressList tResponseFalseIsDatakeyRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tIsDatakeyCol, tIsDatakeyCol);
        CellRangeAddressList tRequestIsArrayRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tIsArrayCol, tIsArrayCol);
        CellRangeAddressList tResponseSuccessIsArrayRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tIsArrayCol, tIsArrayCol);
        CellRangeAddressList tResponseFalseIsArrayRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tIsArrayCol, tIsArrayCol);
        CellRangeAddressList tCFRegions = new CellRangeAddressList();
        tCFRegions.addCellRangeAddress(tRequestFirstRow, tCFCol, tRequestLastRow, tCFCol);
        tCFRegions.addCellRangeAddress(tResponseSuccessFirstRow, tCFCol, tResponseSuccessLastRow, tCFCol);
        tCFRegions.addCellRangeAddress(tResponseFalseFirstRow, tCFCol, tResponseFalseLastRow, tCFCol);
        String[] tApiTypeList = ApiTypeConstants.API_TYPE_ARRAY;
        DVConstraint tApiTypeConstraint = DVConstraint.createExplicitListConstraint((String[])tApiTypeList);
        String[] tProtocolList = ProtocolConstants.PROTOCOL_ARRAY;
        DVConstraint tProtocolConstraint = DVConstraint.createExplicitListConstraint((String[])tProtocolList);
        String[] tRequestMethodList = RequestMethodConstants.REQUEST_METHOD_ARRAY;
        DVConstraint tRequestMethodConstraint = DVConstraint.createExplicitListConstraint((String[])tRequestMethodList);
        String[] tIsSyncTypeList = SyncTypeConstants.SYNC_TYPE_ARRAY;
        DVConstraint tSyncTypeConstraint = DVConstraint.createExplicitListConstraint((String[])tIsSyncTypeList);
        List tStandardApiPagingList = this.standardApiPagingDao.getAll();
        String[] tPagingList = new String[tStandardApiPagingList.size()];
        for (int i = 0; i < tStandardApiPagingList.size(); ++i) {
            tPagingList[i] = ((StandardApiPaging)tStandardApiPagingList.get(i)).getId() + "." + ((StandardApiPaging)tStandardApiPagingList.get(i)).getNameZhTw();
        }
        DVConstraint tPagingConstraint = DVConstraint.createExplicitListConstraint((String[])tPagingList);
        String[] tIsBatchList = new String[]{"Y", "N"};
        DVConstraint tIsBatchConstraint = DVConstraint.createExplicitListConstraint((String[])tIsBatchList);
        String[] tGroupList = this.getDropDownData(pDataSheet, 0);
        DVConstraint tGroupConstraint = DVConstraint.createExplicitListConstraint((String[])tGroupList);
        List tStandardApiCategoryList = this.standardApiCategoryDao.getAll();
        String[] tCategoryList = new String[tStandardApiCategoryList.size()];
        for (int i = 0; i < tStandardApiCategoryList.size(); ++i) {
            tCategoryList[i] = ((StandardApiCategory)tStandardApiCategoryList.get(i)).getId() + "." + ((StandardApiCategory)tStandardApiCategoryList.get(i)).getNameZhTw();
        }
        DVConstraint tCategoryConstraint = DVConstraint.createExplicitListConstraint((String[])tCategoryList);
        String[] tMsgFormatlist = this.getDropDownData(pDataSheet, 2);
        DVConstraint tMsgFormatConstraint = DVConstraint.createExplicitListConstraint((String[])tMsgFormatlist);
        String[] tColumnTypelist = this.getDropDownData(pDataSheet, 3);
        DVConstraint tColumnTypeConstraint = DVConstraint.createExplicitListConstraint((String[])tColumnTypelist);
        String[] tDataTypelist = this.getDropDownData(pDataSheet, 4);
        DVConstraint tDataTypeConstraint = DVConstraint.createExplicitListConstraint((String[])tDataTypelist);
        String[] tIsRequiredlist = this.getDropDownData(pDataSheet, 5);
        DVConstraint tIsRequiredConstraint = DVConstraint.createExplicitListConstraint((String[])tIsRequiredlist);
        String[] tIsDatakeyList = new String[]{"Y"};
        DVConstraint tIsDatakeyConstraint = DVConstraint.createExplicitListConstraint((String[])tIsDatakeyList);
        String[] tIsArrayList = new String[]{"Y", "N"};
        DVConstraint tIsArrayConstraint = DVConstraint.createExplicitListConstraint((String[])tIsArrayList);
        HSSFDataValidation tApiTypeValidation = new HSSFDataValidation(tApiTypeRegions, (DataValidationConstraint)tApiTypeConstraint);
        HSSFDataValidation tRequestMethodValidation = new HSSFDataValidation(tRequestMethodRegions, (DataValidationConstraint)tRequestMethodConstraint);
        HSSFDataValidation tSyncTypeValidation = new HSSFDataValidation(tSyncTypeRegions, (DataValidationConstraint)tSyncTypeConstraint);
        HSSFDataValidation tPagingValidation = new HSSFDataValidation(tPagingRegions, (DataValidationConstraint)tPagingConstraint);
        HSSFDataValidation tIsBatchValidation = new HSSFDataValidation(tIsBatchRegions, (DataValidationConstraint)tIsBatchConstraint);
        HSSFDataValidation tGroupValidation = new HSSFDataValidation(tGroupRegions, (DataValidationConstraint)tGroupConstraint);
        HSSFDataValidation tCategoryValidation = new HSSFDataValidation(tCategoryRegions, (DataValidationConstraint)tCategoryConstraint);
        HSSFDataValidation tMsgFormatValidation = new HSSFDataValidation(tMsgFormatRegions, (DataValidationConstraint)tMsgFormatConstraint);
        HSSFDataValidation tRequestColumnTypeValidation = new HSSFDataValidation(tRequestColumnTypeRegions, (DataValidationConstraint)tColumnTypeConstraint);
        HSSFDataValidation tResponseSuccessColumnTypeValidation = new HSSFDataValidation(tResponseSuccessColumnTypeRegions, (DataValidationConstraint)tColumnTypeConstraint);
        HSSFDataValidation tResponseFalseColumnTypeValidation = new HSSFDataValidation(tResponseFalseColumnTypeRegions, (DataValidationConstraint)tColumnTypeConstraint);
        HSSFDataValidation tRequestDataTypeValidation = new HSSFDataValidation(tRequestDataTypeRegions, (DataValidationConstraint)tDataTypeConstraint);
        HSSFDataValidation tResponseSuccessDataTypeValidation = new HSSFDataValidation(tResponseSuccessDataTypeRegions, (DataValidationConstraint)tDataTypeConstraint);
        HSSFDataValidation tResponseFalseDataTypeValidation = new HSSFDataValidation(tResponseFalseDataTypeRegions, (DataValidationConstraint)tDataTypeConstraint);
        HSSFDataValidation tRequestIsRequiredValidation = new HSSFDataValidation(tRequestIsRequiredRegions, (DataValidationConstraint)tIsRequiredConstraint);
        HSSFDataValidation tResponseSuccessIsRequiredValidation = new HSSFDataValidation(tResponseSuccessIsRequiredRegions, (DataValidationConstraint)tIsRequiredConstraint);
        HSSFDataValidation tResponseFalseIsRequiredValidation = new HSSFDataValidation(tResponseFalseIsRequiredRegions, (DataValidationConstraint)tIsRequiredConstraint);
        HSSFDataValidation tRequestIsDatakeyValidation = new HSSFDataValidation(tRequestIsDatakeyRegions, (DataValidationConstraint)tIsDatakeyConstraint);
        HSSFDataValidation tResponseSuccessIsDatakeyValidation = new HSSFDataValidation(tResponseSuccessIsDatakeyRegions, (DataValidationConstraint)tIsDatakeyConstraint);
        HSSFDataValidation tResponseFalseDatakeyValidation = new HSSFDataValidation(tResponseFalseIsDatakeyRegions, (DataValidationConstraint)tIsDatakeyConstraint);
        HSSFDataValidation tRequestIsArrayValidation = new HSSFDataValidation(tRequestIsArrayRegions, (DataValidationConstraint)tIsArrayConstraint);
        HSSFDataValidation tResponseSuccessIsArrayValidation = new HSSFDataValidation(tResponseSuccessIsArrayRegions, (DataValidationConstraint)tIsArrayConstraint);
        HSSFDataValidation tResponseFalseArrayValidation = new HSSFDataValidation(tResponseFalseIsArrayRegions, (DataValidationConstraint)tIsArrayConstraint);
        pNewSheet.addValidationData((DataValidation)tApiTypeValidation);
        pNewSheet.addValidationData((DataValidation)tRequestMethodValidation);
        pNewSheet.addValidationData((DataValidation)tSyncTypeValidation);
        pNewSheet.addValidationData((DataValidation)tPagingValidation);
        pNewSheet.addValidationData((DataValidation)tIsBatchValidation);
        pNewSheet.addValidationData((DataValidation)tGroupValidation);
        pNewSheet.addValidationData((DataValidation)tCategoryValidation);
        pNewSheet.addValidationData((DataValidation)tMsgFormatValidation);
        pNewSheet.addValidationData((DataValidation)tRequestColumnTypeValidation);
        pNewSheet.addValidationData((DataValidation)tResponseSuccessColumnTypeValidation);
        pNewSheet.addValidationData((DataValidation)tResponseFalseColumnTypeValidation);
        pNewSheet.addValidationData((DataValidation)tRequestDataTypeValidation);
        pNewSheet.addValidationData((DataValidation)tResponseSuccessDataTypeValidation);
        pNewSheet.addValidationData((DataValidation)tResponseFalseDataTypeValidation);
        pNewSheet.addValidationData((DataValidation)tRequestIsRequiredValidation);
        pNewSheet.addValidationData((DataValidation)tResponseSuccessIsRequiredValidation);
        pNewSheet.addValidationData((DataValidation)tResponseFalseIsRequiredValidation);
        pNewSheet.addValidationData((DataValidation)tRequestIsDatakeyValidation);
        pNewSheet.addValidationData((DataValidation)tResponseSuccessIsDatakeyValidation);
        pNewSheet.addValidationData((DataValidation)tResponseFalseDatakeyValidation);
        pNewSheet.addValidationData((DataValidation)tRequestIsArrayValidation);
        pNewSheet.addValidationData((DataValidation)tResponseSuccessIsArrayValidation);
        pNewSheet.addValidationData((DataValidation)tResponseFalseArrayValidation);
        pNewSheet.getSheetConditionalFormatting().addConditionalFormatting(tCFRegions.getCellRangeAddresses(), pTemplateSheet.getSheetConditionalFormatting().getConditionalFormattingAt(0).getRule(0));
    }

    private String[] getDropDownData(HSSFSheet pDataSheet, int pRowNumber) {
        HSSFRow Row2 = pDataSheet.getRow(pRowNumber);
        int tCellCount = Row2.getPhysicalNumberOfCells();
        String[] tCellList = new String[tCellCount - 1];
        for (int tCellNumber = 1; tCellNumber < tCellCount; ++tCellNumber) {
            tCellList[tCellNumber - 1] = Row2.getCell(tCellNumber).getStringCellValue();
        }
        return tCellList;
    }

    public String getTemplate() throws IOException {
        HSSFWorkbook tHSSFWorkbook = this.getTemplateFile(true);
        if (tHSSFWorkbook == null) {
            return APIExportImportEnums.UNKNOW_ERROR.toString();
        }
        String tTemplateFilePath = ApiMgmtApplicationParameter._FILE_EXPORT_PATH + "/" + ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME;
        FileOutputStream fileOut = new FileOutputStream(tTemplateFilePath);
        tHSSFWorkbook.write((OutputStream)fileOut);
        fileOut.close();
        return tTemplateFilePath;
    }

    public String getFileName(String pFilePath) {
        String tFileName = "";
        Pattern tPattern = Pattern.compile("StdApi_(.*)xls");
        Matcher tMatcher = tPattern.matcher(pFilePath);
        if (tMatcher.find()) {
            tFileName = tMatcher.group();
        }
        return tFileName;
    }

    public HSSFWorkbook getTemplateFile(boolean pSetDateName) {
        HSSFWorkbook tHSSFWorkbook;
        try {
            String tTemplateFilePath = ApiMgmtApplicationParameter._FILE_TEMPLATE_PATH + "/" + ApiMgmtApplicationParameter._TEMPLATE_FILE_NAME;
            FileInputStream tFileInputStream = new FileInputStream(tTemplateFilePath);
            POIFSFileSystem tPOIFSFileSystem = new POIFSFileSystem((InputStream)tFileInputStream);
            tHSSFWorkbook = new HSSFWorkbook(tPOIFSFileSystem);
            if (pSetDateName) {
                this.setDataNameList(tHSSFWorkbook);
            }
        }
        catch (Exception e) {
            log.error("Catch exception when export Get Template file.");
            e.printStackTrace();
            return null;
        }
        return tHSSFWorkbook;
    }

    private void setDataNameList(HSSFWorkbook pHSSFWorkbook) {
        HSSFCellStyle tLockCell = pHSSFWorkbook.createCellStyle();
        tLockCell.setLocked(true);
        HSSFSheet tAuditUseDataNameSheet = pHSSFWorkbook.getSheetAt(2);
        tAuditUseDataNameSheet.protectSheet("!QAZ2wsx");
        this.setDataName(tAuditUseDataNameSheet, tLockCell);
        HSSFSheet tDataNameSheet = pHSSFWorkbook.getSheetAt(3);
        this.setDataName(tDataNameSheet, null);
    }

    private void setDataName(HSSFSheet pDataNameSheet, HSSFCellStyle pHSSFCellStyle) {
        List<StandardDataName> tDataNameList = pHSSFCellStyle == null ? this.standardDataNameDao.getDataNameByApprovedStatus(4L, false) : this.standardDataNameDao.getDataNameByApprovedStatus(4L, true);
        for (int tNumber = 0; tNumber < tDataNameList.size(); ++tNumber) {
            StandardDataName tStandardDataName = tDataNameList.get(tNumber);
            HSSFRow tRow = pDataNameSheet.createRow(tNumber + 1);
            int tColumnNumber = 0;
            HSSFCell tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getDataName());
            tColumnNumber = 1;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getDescriptionZhTw());
            tColumnNumber = 2;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getTypeZhTw());
            tColumnNumber = 3;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getDescriptionZhCn());
            tColumnNumber = 4;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getTypeZhCn());
            tColumnNumber = 5;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getDescriptionEnUs());
            tColumnNumber = 6;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getTypeEnUs());
            tColumnNumber = 7;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getUnitOrDefaultZhTw());
            tColumnNumber = 8;
            tCell = tRow.createCell(tColumnNumber);
            tCell.setCellValue(tStandardDataName.getRemarkZhTw());
            if (pHSSFCellStyle == null) continue;
            for (int tRorNumber = 0; tRorNumber <= 6; ++tRorNumber) {
                tRow.getCell(tRorNumber).setCellStyle(pHSSFCellStyle);
            }
        }
    }

    private void writeStandardAPI(HSSFWorkbook pHSSFWorkbook, HSSFSheet pTemplateSheet, HSSFSheet pNewSheet, StandardApi pStandardApi, StandardApiVersion pStandardApiVersion) {
        HSSFRow tNewRow;
        for (int tRowNum = 0; tRowNum < 2; ++tRowNum) {
            tNewRow = pNewSheet.createRow(tRowNum);
            HSSFRow tTemplateStandardAPI = pTemplateSheet.getRow(tRowNum);
            this.copyRow(pHSSFWorkbook, tTemplateStandardAPI, tNewRow, null, true);
        }
        tNewRow = pNewSheet.createRow(2);
        this.copyRow(pHSSFWorkbook, pTemplateSheet.getRow(2), tNewRow, null, false);
        tNewRow.getCell(1).setCellValue(pStandardApi.getName());
        tNewRow.getCell(2).setCellValue(pStandardApi.getDescriptionZhTw());
        tNewRow.getCell(3).setCellValue(pStandardApi.getDescriptionZhCn());
        tNewRow.getCell(4).setCellValue(pStandardApi.getDescriptionEnUs());
        tNewRow.getCell(5).setCellValue(pStandardApiVersion.getVersion());
        tNewRow.getCell(6).setCellValue(SyncTypeConstants.getNameByCode((Long)pStandardApi.getStandardApiSyncType().getId()));
        tNewRow.getCell(7).setCellValue(pStandardApi.getStandardApiPaging().getId() + "." + pStandardApi.getStandardApiPaging().getNameZhTw());
        tNewRow.getCell(8).setCellValue(pStandardApi.getRequester());
        tNewRow.getCell(9).setCellValue(pStandardApi.getProvider());
        if (pStandardApi.getIsBatch().booleanValue()) {
            tNewRow.getCell(10).setCellValue("Y");
        } else {
            tNewRow.getCell(10).setCellValue("N");
        }
        tNewRow.getCell(11).setCellValue(pStandardApi.getStandardApiGroup().getId() + "." + pStandardApi.getStandardApiGroup().getNameZhTw());
        tNewRow.getCell(12).setCellValue(pStandardApi.getStandardApiCategory().getId() + "." + pStandardApi.getStandardApiCategory().getNameZhTw());
        tNewRow.getCell(13).setCellValue(pStandardApi.getMsgFormat());
        tNewRow.getCell(14).setCellValue(pStandardApi.getTagZhTw());
        tNewRow.getCell(15).setCellValue(pStandardApi.getTagZhCn());
        tNewRow.getCell(16).setCellValue(pStandardApi.getTagEnUs());
        tNewRow.getCell(17).setCellValue(pStandardApi.getRemarkZhTw());
        tNewRow.getCell(18).setCellValue(pStandardApi.getRemarkZhCn());
        tNewRow.getCell(19).setCellValue(pStandardApi.getRemarkEnUs());
        tNewRow.getCell(20).setCellValue(pStandardApi.getTenantId());
        tNewRow.getCell(21).setCellValue(pStandardApi.getPackageName());
        if (pStandardApiVersion.getIdempotency() != null) {
            if (pStandardApiVersion.getIdempotency().booleanValue()) {
                tNewRow.getCell(22).setCellValue("Y");
            } else {
                tNewRow.getCell(22).setCellValue("N");
            }
        } else {
            tNewRow.getCell(22).setCellValue("N");
        }
        if (pStandardApiVersion.getUpdateHistory() == null) {
            tNewRow.getCell(23).setCellValue("");
        } else {
            tNewRow.getCell(23).setCellValue(pStandardApiVersion.getUpdateHistory());
        }
        StandardApi standardApi = pStandardApiVersion.getStandardApi();
        if (StringUtils.isBlank((CharSequence)standardApi.getApiType())) {
            tNewRow.getCell(24).setCellValue(ApiTypeConstants.getNameByCode((String)"esp"));
        } else {
            tNewRow.getCell(24).setCellValue(ApiTypeConstants.getNameByCode((String)standardApi.getApiType()));
        }
        if (StringUtils.isBlank((CharSequence)standardApi.getApiPath())) {
            tNewRow.getCell(25).setCellValue("");
        } else {
            tNewRow.getCell(25).setCellValue(standardApi.getApiPath());
        }
        if (StringUtils.isBlank((CharSequence)standardApi.getRequestMethod())) {
            tNewRow.getCell(26).setCellValue("");
        } else {
            tNewRow.getCell(26).setCellValue(standardApi.getRequestMethod());
        }
        if (CollUtil.isEmpty(standardApi.getProjectVersionRelations())) {
            tNewRow.getCell(27).setCellValue("Athena");
            tNewRow.getCell(28).setCellValue("");
        } else {
            Long projectId = standardApi.getProjectVersionRelations().get(0).getProjectId();
            Project project = (Project)this.projectDao.get(projectId);
            tNewRow.getCell(27).setCellValue(project.getProjectName());
            List<Long> idList = standardApi.getProjectVersionRelations().stream().map(ProjectVersionRelation::getProjectVersionId).distinct().collect(Collectors.toList());
            List<ProjectVersion> projectVersionList = this.projectVersionService.queryProjectVersionByIdList(idList);
            List nameList = projectVersionList.stream().map(ProjectVersion::getProjectVersionName).collect(Collectors.toList());
            String joinedString = String.join((CharSequence)",", nameList);
            tNewRow.getCell(28).setCellValue(joinedString);
        }
    }

    private void writeStandardAPIDataName(HSSFWorkbook pHSSFWorkbook, HSSFSheet pTemplateSheet, HSSFSheet pNewSheet, Map<Integer, List<StandardApiDataName>> pMsgTypeMap, List<StandardApiDataName> pStandardApiDataNames) {
        int tRequestTitleRow = 3;
        int tRequestRow = 6;
        int tResponseSuccessTitleRow = 6 + pMsgTypeMap.get(1).size();
        int tResponseSuccessRow = tResponseSuccessTitleRow + 3;
        int tResponseFalseTitleRow = tResponseSuccessRow + pMsgTypeMap.get(2).size();
        int tResponseFalseRow = tResponseFalseTitleRow + 3;
        int tTemplateRequestTitleRow = 3;
        int tTemplateResponseSuccessTitleRow = 36;
        int tTemplateResponseFalseTitleRow = 54;
        int tTemplateStandardApiDataNameRow = 6;
        TreeSet<String> tTreeSet = this.collectPrdNames(pStandardApiDataNames);
        Object[] tArray = tTreeSet.toArray();
        int tStartTitleRow = 0;
        int tStartContentRow = 0;
        int tTemplateTitleRow = 0;
        for (Integer tInteger : pMsgTypeMap.keySet()) {
            HSSFRow tNewRow;
            List<StandardApiDataName> tStandardApiDataNames = pMsgTypeMap.get(tInteger);
            switch (tInteger) {
                case 1: {
                    tStartTitleRow = 3;
                    tStartContentRow = 6;
                    tTemplateTitleRow = tTemplateRequestTitleRow;
                    break;
                }
                case 2: {
                    tStartTitleRow = tResponseSuccessTitleRow;
                    tStartContentRow = tResponseSuccessRow;
                    tTemplateTitleRow = tTemplateResponseSuccessTitleRow;
                    break;
                }
                case 3: {
                    tStartTitleRow = tResponseFalseTitleRow;
                    tStartContentRow = tResponseFalseRow;
                    tTemplateTitleRow = tTemplateResponseFalseTitleRow;
                    break;
                }
            }
            int tStartRow = tStartTitleRow;
            while (tStartRow < tStartContentRow) {
                tNewRow = pNewSheet.createRow(tStartRow);
                HSSFRow tTemplateStandardAPI = pTemplateSheet.getRow(tTemplateTitleRow);
                this.copyRow(pHSSFWorkbook, tTemplateStandardAPI, tNewRow, null, true);
                if (tStartRow + 1 == tStartContentRow) {
                    int tSize = tArray.length;
                    for (int ii = 0; ii < tSize; ++ii) {
                        if (null == tNewRow.getCell(22 + ii)) {
                            tNewRow.createCell(22 + ii);
                        }
                        tNewRow.getCell(22 + ii).setCellValue((String)tArray[ii]);
                    }
                }
                ++tStartRow;
                ++tTemplateTitleRow;
            }
            pNewSheet.addMergedRegion(new CellRangeAddress(tStartTitleRow, tStartTitleRow, 1, 2));
            pNewSheet.addMergedRegion(new CellRangeAddress(tStartTitleRow + 1, tStartTitleRow + 1, 1, 3));
            HSSFCellStyle tAPIDataNameStyle = this.newAPIDataNameStyle(pHSSFWorkbook, pTemplateSheet.getRow(tTemplateStandardApiDataNameRow));
            tStartRow = tStartContentRow;
            for (int tIndex = 0; tIndex < tStandardApiDataNames.size(); ++tIndex) {
                tNewRow = pNewSheet.createRow(tStartRow);
                this.copyRow(pHSSFWorkbook, pTemplateSheet.getRow(tTemplateStandardApiDataNameRow), tNewRow, tAPIDataNameStyle, false);
                StandardApiDataName tStandardApiDataName = tStandardApiDataNames.get(tIndex);
                if (tStandardApiDataName.getIsBusinesskey() != null && tStandardApiDataName.getIsBusinesskey().booleanValue()) {
                    tNewRow.getCell(0).setCellValue("Y");
                }
                tNewRow.getCell(1).setCellValue(tStandardApiDataName.getColumnType());
                if (tStandardApiDataName.getParent() != null) {
                    tNewRow.getCell(2).setCellValue(tStandardApiDataName.getParent().getStandardDataName());
                }
                String tDataNameSheetName = pHSSFWorkbook.getSheetAt(2).getSheetName();
                int tCheckRow = tStartRow + 1;
                String tFormulaFormat = "IF(ISBLANK(E%2$d),\"NEW\",IF(OR(SUMPRODUCT(--(EXACT(%1$s!A:A,E%2$d))),AND(OR(E%2$d=\"EntId\",E%2$d=\"CompanyId\",E%2$d=\"PlantId\"),B%2$d=\"datakey\"),B%2$d=\"H\"),\"\",\"NEW\"))";
                String tCheckDataNameFormula = String.format(tFormulaFormat, tDataNameSheetName, tCheckRow);
                tNewRow.getCell(3).setCellFormula(tCheckDataNameFormula);
                tNewRow.getCell(4).setCellValue(tStandardApiDataName.getStandardDataName());
                tNewRow.getCell(5).setCellValue(tStandardApiDataName.getDataType());
                if (tStandardApiDataName.getIsRequired().booleanValue()) {
                    tNewRow.getCell(6).setCellValue(IsRequiredEnum.Y.toString());
                } else {
                    tNewRow.getCell(6).setCellValue(IsRequiredEnum.N.toString());
                }
                if (tStandardApiDataName.getIsDatakey() != null && tStandardApiDataName.getIsDatakey().booleanValue()) {
                    tNewRow.getCell(7).setCellValue("Y");
                }
                if (tStandardApiDataName.getIsArray() != null && tStandardApiDataName.getIsArray().booleanValue()) {
                    tNewRow.getCell(8).setCellValue("Y");
                }
                if (tStandardApiDataName.getCanSort() != null && tStandardApiDataName.getCanSort().booleanValue()) {
                    tNewRow.getCell(9).setCellValue("Y");
                }
                if (tStandardApiDataName.getCanFilter() != null && tStandardApiDataName.getCanFilter().booleanValue()) {
                    tNewRow.getCell(10).setCellValue("Y");
                }
                tNewRow.getCell(11).setCellValue(tStandardApiDataName.getDescriptionZhTw());
                tNewRow.getCell(12).setCellValue(tStandardApiDataName.getDescriptionZhCn());
                tNewRow.getCell(13).setCellValue(tStandardApiDataName.getDescriptionEnUs());
                tNewRow.getCell(14).setCellValue(tStandardApiDataName.getValue());
                if (tStandardApiDataName.getRemarkZhTw() != null) {
                    tNewRow.getCell(15).setCellValue(tStandardApiDataName.getRemarkZhTw());
                }
                if (tStandardApiDataName.getRemarkZhCn() != null) {
                    tNewRow.getCell(16).setCellValue(tStandardApiDataName.getRemarkZhCn());
                }
                if (tStandardApiDataName.getRemarkEnUs() != null) {
                    tNewRow.getCell(17).setCellValue(tStandardApiDataName.getRemarkEnUs());
                }
                if (tStandardApiDataName.getListEnumZhTw() != null) {
                    tNewRow.getCell(18).setCellValue(tStandardApiDataName.getListEnumZhTw());
                }
                if (tStandardApiDataName.getListEnumZhTw() != null) {
                    tNewRow.getCell(19).setCellValue(tStandardApiDataName.getListEnumZhCn());
                }
                if (tStandardApiDataName.getListEnumZhTw() != null) {
                    tNewRow.getCell(20).setCellValue(tStandardApiDataName.getListEnumEn());
                }
                if (tStandardApiDataName.getUpdateHistory() == null) {
                    tNewRow.getCell(21).setCellValue("");
                } else {
                    tNewRow.getCell(21).setCellValue(tStandardApiDataName.getUpdateHistory());
                }
                for (int ii = 0; ii < tArray.length; ++ii) {
                    ProductApiDataName[] tProductApiDataNames = this.filterProductApiDataName(tStandardApiDataName.getProductApiDataNames(), (String)tArray[ii]);
                    if (0 >= tProductApiDataNames.length || null == tProductApiDataNames[0].getLength()) continue;
                    String tStrLi = "";
                    if ("string".equals(tStandardApiDataName.getDataType())) {
                        tStrLi = tProductApiDataNames[0].getLength().toString();
                    } else if ("numeric".equals(tStandardApiDataName.getDataType())) {
                        tStrLi = tProductApiDataNames[0].getLength() + "," + tProductApiDataNames[0].getPrecision();
                    }
                    if (null == tNewRow.getCell(22 + ii)) {
                        tNewRow.createCell(22 + ii);
                    }
                    tNewRow.getCell(22 + ii).setCellValue(tStrLi);
                }
                ++tStartRow;
            }
        }
    }

    private void setSheetWidthAndHight(HSSFSheet pTemplateSheet, HSSFSheet pNewSheet) {
        for (int tColumnNumber = 0; tColumnNumber <= 22; ++tColumnNumber) {
            pNewSheet.setColumnWidth(tColumnNumber, pTemplateSheet.getColumnWidth(tColumnNumber));
        }
    }

    private void copyRow(HSSFWorkbook pWorkbook, HSSFRow pTemplateRow, HSSFRow pNewRow, HSSFCellStyle pNewstyle, boolean pCopyValueFlag) {
        Iterator tCellIt = pTemplateRow.cellIterator();
        while (tCellIt.hasNext()) {
            HSSFCell tTemplateCell = (HSSFCell)tCellIt.next();
            HSSFCell tNewCell = pNewRow.createCell(tTemplateCell.getColumnIndex());
            this.copyCell(pWorkbook, tTemplateCell, tNewCell, pNewstyle, pCopyValueFlag);
        }
    }

    private void copyCell(HSSFWorkbook pHSSFWorkbook, HSSFCell pTemplateCell, HSSFCell pNewCell, HSSFCellStyle pNewstyle, boolean copyValueFlag) {
        if (pNewstyle != null) {
            if (pNewCell.getColumnIndex() < 22) {
                pNewCell.setCellStyle(pNewstyle);
            }
        } else {
            HSSFCellStyle tNewstyle = pHSSFWorkbook.createCellStyle();
            tNewstyle.cloneStyleFrom(pTemplateCell.getCellStyle());
            tNewstyle.setWrapText(true);
            pNewCell.setCellStyle(tNewstyle);
        }
        if (pTemplateCell.getHyperlink() != null) {
            pNewCell.setHyperlink((Hyperlink)pTemplateCell.getHyperlink());
        }
        if (copyValueFlag) {
            pNewCell.setCellValue((RichTextString)pTemplateCell.getRichStringCellValue());
        }
    }

    private TreeSet<String> collectPrdNames(List<StandardApiDataName> pStandardApiDataNames) {
        TreeSet tPrdNms = Sets.newTreeSet();
        for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
            List<ProductApiDataName> tProductApiDataNames = tStandardApiDataName.getProductApiDataNames();
            for (ProductApiDataName tProductApiDataName : tProductApiDataNames) {
                String tPrdNm = tProductApiDataName.getProductName();
                tPrdNms.add(tPrdNm);
            }
        }
        return tPrdNms;
    }

    private ProductApiDataName[] filterProductApiDataName(List<ProductApiDataName> pList, String pPrdName) {
        return (ProductApiDataName[])CollUtil.emptyIfNull(pList).stream().filter(tProductApiDataName -> pPrdName.equals(tProductApiDataName.getProduct().getName())).toArray(ProductApiDataName[]::new);
    }

    private HSSFCellStyle newAPIDataNameStyle(HSSFWorkbook pHSSFWorkbook, HSSFRow pTemplateRow) {
        HSSFCellStyle tNewstyle = pHSSFWorkbook.createCellStyle();
        HSSFCell tCell = pTemplateRow.getCell(0);
        tNewstyle.cloneStyleFrom(tCell.getCellStyle());
        tNewstyle.setWrapText(true);
        return tNewstyle;
    }
}

