package com.digiwin.athena.apimgmt.apiservice;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.model.StandardDataName;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * 新增辭彙
 * /restful/standard/apimgmt/ApiDataName/Add
 */
@Slf4j
@Service
@OperateAuthorityVerify
public class ApiDataNameAddService extends AbstractApiService {
	
	@Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;
	
	public ApiDataNameAddService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.API_DATA_NAME_ADD_SCHEMA;
	}

	/**
	 * 新增词典信息
	 * @param validatorResult validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		String tDataName = tRequestJsonNode.get(ApimgmtConstant.DATA_NAME).asText();
		String tDescZhTw = tRequestJsonNode.get(ApimgmtConstant.DESC_ZH_TW).asText();
		String tDescZhCn = null, tDescEnUs = null;
		String tTypeZhTw = null, tTypeZhCn = null, tTypeEnUs = null;
		String tRemarkZhTw = null, tRemarkZhCn = null, tRemarkEnUs = null;
		if(tRequestJsonNode.get(ApimgmtConstant.DESC_ZH_CN) != null){
			tDescZhCn = tRequestJsonNode.get(ApimgmtConstant.DESC_ZH_CN).asText();
		}
		if(tRequestJsonNode.get(ApimgmtConstant.DESC_EN_US) != null){
			tDescEnUs = tRequestJsonNode.get(ApimgmtConstant.DESC_EN_US).asText();
		}
		if(tRequestJsonNode.get(ApimgmtConstant.TYPE_ZH_TW) != null){
			tTypeZhTw = tRequestJsonNode.get(ApimgmtConstant.TYPE_ZH_TW).asText();
		}
		if(tRequestJsonNode.get(ApimgmtConstant.TYPE_ZH_CN) != null){
			tTypeZhCn = tRequestJsonNode.get(ApimgmtConstant.TYPE_ZH_CN).asText();
		}
		if(tRequestJsonNode.get(ApimgmtConstant.TYPE_EN_US) != null){
			tTypeEnUs = tRequestJsonNode.get(ApimgmtConstant.TYPE_EN_US).asText();
		}
		if(tRequestJsonNode.get(ApimgmtConstant.REMARK_ZH_TW) != null){
			tRemarkZhTw = tRequestJsonNode.get(ApimgmtConstant.REMARK_ZH_TW).asText();
		}
		if(tRequestJsonNode.get(ApimgmtConstant.REMARK_ZH_CN) != null){
			tRemarkZhCn = tRequestJsonNode.get(ApimgmtConstant.REMARK_ZH_CN).asText();
		}
		if(tRequestJsonNode.get(ApimgmtConstant.REMARK_EN_US) != null){
			tRemarkEnUs = tRequestJsonNode.get(ApimgmtConstant.REMARK_EN_US).asText();
		}
		StandardDataName tStandardDataName = new StandardDataName();
		tStandardDataName.setDataName(tDataName);
		tStandardDataName.setDescriptionZhTw(tDescZhTw);
		tStandardDataName.setDescriptionZhCn(tDescZhCn);
		tStandardDataName.setDescriptionEnUs(tDescEnUs);
		tStandardDataName.setTypeZhTw(tTypeZhTw);
		tStandardDataName.setTypeZhCn(tTypeZhCn);
		tStandardDataName.setTypeEnUs(tTypeEnUs);
		tStandardDataName.setRemarkZhTw(tRemarkZhTw);
		tStandardDataName.setRemarkZhCn(tRemarkZhCn);
		tStandardDataName.setRemarkEnUs(tRemarkEnUs);
		tStandardDataName.setApprovedStatus(1L);
		tStandardDataName.setBuildAcct("admin");
		tStandardDataName.setApprovedAcct("admin");
		tStandardDataName.setApprovedTime(LocalDateTime.now());
		tStandardDataName.setDirty(true);
		standardDataNameDao.add(tStandardDataName);
		Map<String, Object> tResponse = new HashMap<>();
		//組成回傳訊息
		tResponse.put(ApimgmtConstant.CODE, "000");
		tResponse.put(ApimgmtConstant.RESULT, ApimgmtConstant.SUCCESS);
		return tResponse;
	}
	
}
