package com.digiwin.athena.apimgmt.apiservice;

import com.digiwin.athena.apimgmt.annotate.OperateAuthorityVerify;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.constants.ApimgmtSchemaConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtApprovedStatusDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerifyLogDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtVerityOperateDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ApprovedStatus;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.model.VerifyLog;
import com.digiwin.athena.apimgmt.model.VerityOperate;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.services.ApiMgmtSyncMdcServiceProcessor;
import com.digiwin.athena.apimgmt.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * API審核通過
 * /restful/standard/apimgmt/ApiExaminationPassed/Update
 */
@Slf4j
@Service
@OperateAuthorityVerify
public class ApiExaminationPassedUpdateService extends AbstractApiService {

	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	@Autowired
    ApiMgmtApprovedStatusDao approvedStatusDao;

	@Autowired
    ApiMgmtVerifyLogDao verifyLogDao;

	@Autowired
    ApiMgmtVerityOperateDao verityOperateDao;

	@Autowired
	private ApiMgmtSyncMdcServiceProcessor syncMdcServiceProcessor;

    @Autowired
    private ApiMgmtMdcProp mdcProp;
	
	public ApiExaminationPassedUpdateService() {
		super();
		jsonSchemaFileName = ApimgmtSchemaConstant.API_EXAMINATION_PASSES_SCHEMA;
	}

	/**
	 * 审核通过
	 * @param validatorResult validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		ArrayList<Long> tListApiVerIdNeedToSyncMetadata = new ArrayList<>(); // for MDC.
		String tToken = ApiMgmtServiceContextHolder.getToken();
		String routerKey = ApiMgmtServiceContextHolder.getRouterKey();
		String tUserId = ApiMgmtServiceContextHolder.getUserId();
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		ArrayNode tApiArrayNode = (ArrayNode) tRequestJsonNode.get(ApimgmtConstant.API_LIST);
		for (JsonNode tApiNode : tApiArrayNode) {
			Map<String, String> tConditionMap = new HashMap<>();
			tConditionMap.put(ApiAttributeEnum.apiName.toString(), tApiNode.get(ApiAttributeEnum.apiName.toString()).asText());
			tConditionMap.put(ApiAttributeEnum.version.toString(), tApiNode.get(ApiAttributeEnum.version.toString()).asText());
			if(tApiNode.get(ApiAttributeEnum.tenantId.toString()) != null){
				tConditionMap.put(ApiAttributeEnum.tenantId.toString(), tApiNode.get(ApiAttributeEnum.tenantId.toString()).asText());
			}
			StandardApiVersion tStandardApiVersion = standardApiVersionDao.fetchApiVersion(tConditionMap);
			if(tStandardApiVersion != null){
				ApprovedStatus tApprovedStatus = approvedStatusDao.get(3L); // 開發中
				tStandardApiVersion.setApprovedStatus(tApprovedStatus);
				tStandardApiVersion.setApprovedTime(LocalDateTime.now());
				standardApiVersionDao.saveOrupdate(tStandardApiVersion);
				Long tApiVerId = tStandardApiVersion.getId();
				tListApiVerIdNeedToSyncMetadata.add(tApiVerId); // for MDC.
				setLog(tApiVerId, tUserId, tApiNode.get(ApimgmtConstant.PASS_DESC).asText());
			}
		}
		// 同步MDC元數據
		for (String url : mdcProp.getReviewUrlList()) {
			syncMdcServiceProcessor.runSyncMdcMetadata(
					tListApiVerIdNeedToSyncMetadata, url, tUserId, tToken, routerKey);
		}
		Map<String, Object> tResponse = new HashMap<>();
		// 組成回傳訊息
		tResponse.put(ApimgmtConstant.CODE, "000");
		tResponse.put(ApimgmtConstant.RESULT, ApimgmtConstant.SUCCESS);
		return tResponse;
	}
	
	private void setLog(Long pApiVerId, String pUserId, String pPaasDesc){
		VerityOperate tVerityOperate = verityOperateDao.get(1L);
		VerifyLog tVerifyLog = new VerifyLog();
		tVerifyLog.setApiVerId(pApiVerId);
		tVerifyLog.setVerifyAcct(pUserId);
		tVerifyLog.setVerifyTime(LocalDateTime.now());
		tVerifyLog.setVerityOperate(tVerityOperate);
		tVerifyLog.setReason(pPaasDesc);
		verifyLogDao.save(tVerifyLog);
	}
	
}
