package com.digiwin.athena.apimgmt.dao;

import java.util.List;
import java.util.Map;

import com.digiwin.athena.apimgmt.model.ApiCountKeyValue;
import com.digiwin.athena.apimgmt.model.DirtyData;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;

public interface ApiMgmtStandardApiVersionDao extends GenericDao<StandardApiVersion, Long> {

    List<StandardApiVersion> fetch(Map<String, String> pCondition);

    /**
     * 查询版本信息
     *
     * @param pId     pId
     * @param pUserId pUserId
     * @param pStatus pStatus
     * @return list
     */
    List<StandardApiVersion> getVersionByApiId(Long pId, String pUserId, String pStatus);

    List<StandardApiVersion> getVersionListByApiId(Long pId);

    List<StandardApiVersion> fetchApiVersionsByName(final String pApiName, String branch, String pTenantId);

    List<StandardApiVersion> fetchApiVersionsByName(final String pApiName, String branch, String pTenantId, String tTenantId, String teamType, boolean pViewAllApi);

    /**
     * 根据类型查询API
     *
     * @param pStatus       状态
     * @param pUserId       用户
     * @param pTenantId     租户
     * @param pIsVerifyAcct acct
     * @return list
     */
    List<StandardApiVersion> getByStatus(Long pStatus, String pUserId, String pTenantId, boolean pIsVerifyAcct);

    /**
     * 查询租户对应状态的审核个数
     *
     * @param pUserId       用户Id
     * @param pTenantId     租户ID
     * @param pIsVerifyAcct acct
     * @return list
     */
    List<ApiCountKeyValue> getApiCountByStatus(String pUserId, String pTenantId, boolean pIsVerifyAcct);

    StandardApiVersion fetchApiVersion(Map<String, String> pConditions);

    List<StandardApiVersion> fetchApiVersions(String pApiName, String pVersion);

    List<StandardApiVersion> fetchApiVersions(String pApiName, String pTenantId, String pVersion);

    void fillApiLatestVersion(List<StandardApi> apiList);

    void delete(final Long pId, boolean pRemoveApi);

    List<StandardApiVersion> getExistApiVersion(String pApiName, String pTenantId, String pVersion);

    List<StandardApiVersion> getByCategory(Long pCategory, String pTenantId, String teamType, boolean pViewAllApi);

    /**
     * 脏数据查询
     *
     * @return List
     */
    List<DirtyData> queryDirtyData();

    /**
     * 标准api总数查询
     *
     * @param versionIds versionIds
     * @return list
     */
    Map<Long, Long> advanceStandardApiCountByVersionIds(List<Long> versionIds);
}
