package com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper;

import cn.hutool.core.lang.Pair;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.digiwin.athena.apimgmt.model.ApiCountKeyValue;
import com.digiwin.athena.apimgmt.model.DirtyData;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface ApiMgmtStandardApiVersionMapper extends BaseMapperPlus<StandardApiVersion> {

    List<StandardApiVersion> getVersionByApiId(@Param("apiId") Long apiId,
                                               @Param("userId") String userId,
                                               @Param("status") String status);

    List<StandardApiVersion> fetchApiVersionsByNameSimple(@Param("apiName") String apiName,
                                                          @Param("branch") String branch,
                                                          @Param("tenantId") String tenantId);

    List<StandardApiVersion> fetchApiVersionsByNameWithAuth(@Param("apiName") String apiName,
                                                            @Param("branch") String branch,
                                                            @Param("tTenantId") String tTenantId,
                                                            @Param("pTenantId") String pTenantId,
                                                            @Param("teamType") String teamType,
                                                            @Param("viewAllApi") boolean viewAllApi);

    List<StandardApiVersion> getByStatus(@Param("status") Long status,
                                         @Param("userId") String userId,
                                         @Param("tenantId") String tenantId,
                                         @Param("isVerifyAcct") boolean isVerifyAcct);

    List<ApiCountKeyValue> getApiCountByStatus(@Param("userId") String userId,
                                               @Param("tenantId") String tenantId,
                                               @Param("isVerifyAcct") boolean isVerifyAcct,
                                               @Param("approveStatusList") List<Integer> statusList);

    StandardApiVersion fetchApiVersion(@Param("conditions") Map<String, String> conditions);

    List<StandardApiVersion> getByCategory(@Param("category") Long category,
                                           @Param("tenantId") String tenantId,
                                           @Param("teamType") String teamType,
                                           @Param("viewAllApi") boolean viewAllApi);

    List<DirtyData> queryDirtyData();

    List<Pair<Long, Long>> advanceStandardApiCountByVersionIds(@Param("versionIds") List<Long> versionIds);

    List<StandardApiVersion> fetchByConditions(@Param("conditions") Map<String, String> conditions, IPage<?> page);

    @MapKey(value = "apiId")
    Map<Long, StandardApiVersion> selectLatestByApiId(List<Long> apiIdList);
}
