package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * The persistent class for the prd_api_version_mapping database table.
 * 
 */
@TableName(value = "prd_api_version_mapping", resultMap = "BaseResultMap")
@Data
public class PrdApiVersionMapping implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
	private Long id;

    @TableField("build_acct")
	private String buildAcct;

    @TableField("build_time")
    private LocalDateTime buildTime;

	private boolean isvalid;

    @TableField("last_update_acct")
	private String lastUpdateAcct;

    @TableField("last_update_time")
    private LocalDateTime lastUpdateTime;

	//bi-directional many-to-one association to ProductVersion
    @TableField(exist = false)
	private ProductVersion productVersion;

	//bi-directional many-to-one association to StandardApiVersion
    @TableField(exist = false)
	private StandardApiVersion standardApiVersion;

}