package com.digiwin.athena.apimgmt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@TableName(value = "verify_log", resultMap = "BaseResultMap")
public class VerifyLog implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
	private Long id;

    @TableField("api_ver_id")
	private Long apiVerId;

    @TableField("verify_acct")
    private String verifyAcct;

    @TableField("verify_time")
    private LocalDateTime verifyTime;

    @TableField("verity_operate")
    private Long verityOperateId;

    @TableField(exist = false)
	private VerityOperate verityOperate;

    @TableField("reason")
	private String reason;
	

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getApiVerId() {
		return apiVerId;
	}

	public void setApiVerId(Long apiVerId) {
		this.apiVerId = apiVerId;
	}

	public String getVerifyAcct() {
        return verifyAcct;
	}

	public void setVerifyAcct(String verifyAcct) {
        this.verifyAcct = verifyAcct;
    }

    public LocalDateTime getVerifyTime() {
        return verifyTime;
    }

    public void setVerifyTime(LocalDateTime verifyTime) {
        this.verifyTime = verifyTime;
	}

    public Long getVerityOperateId() {
        return verityOperateId;
	}

    public void setVerityOperateId(Long verityOperateId) {
        this.verityOperateId = verityOperateId;
	}

	public VerityOperate getVerityOperate() {
		return verityOperate;
	}

	public void setVerityOperate(VerityOperate verityOperate) {
		this.verityOperate = verityOperate;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public VerifyLog() {
	}

}