package com.digiwin.athena.apimgmt.service.util;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.services.ApiMgmtValidateApiDataNameService;

/**
 * api基础信息验证处理类util
 */
@Service
public class ValidateApiDataNameServiceUtil extends GenericServiceUtil<ApiMgmtValidateApiDataNameService> {

	private static ApiMgmtValidateApiDataNameService service;

	@Override
	@Autowired
	public void setService(ApiMgmtValidateApiDataNameService pService) {
		service = pService;
	}

	public static boolean checkBatchIsChanged(boolean pPreviIsBatch, boolean pIsBatch) {
		return service.checkBatchIsChanged(pPreviIsBatch, pIsBatch);
	}

	public static boolean checkSyncTypeIsChanged(long pPreviSyncType, long pSyncType) {
		return service.checkSyncTypeIsChanged(pPreviSyncType, pSyncType);
	}

	public static StringBuilder checkRequiredDataName(String[] pCheckRequiredDataName, String[] pRequiredDataName, Map<String, StandardApiDataName> pAddDataName) {
		return service.checkRequiredDataName(pCheckRequiredDataName, pRequiredDataName, pAddDataName);
	}

	public static StringBuilder isArrayCannotBeY(List<StandardApiDataName> pAddDataNameList) {
		return service.isArrayCannotBeY(pAddDataNameList);
	}

	@Deprecated
	public static StringBuilder checkApiIsLackDataName(List<StandardApiDataName> pPreviApiDataName, Map<String, StandardApiDataName> pAddDataName) {
		return service.checkApiIsLackDataName(pPreviApiDataName, pAddDataName);
	}

	public static StringBuilder checkIsArray(List<StandardApiDataName> pPreviousApiDataName, Map<String, StandardApiDataName> pAddDataName) {
		return service.checkIsArray(pPreviousApiDataName, pAddDataName);
	}

	@Deprecated
	public static StringBuilder checkIsRequired(Map<String, StandardApiDataName> pPreviApiDataNameMap, List<StandardApiDataName> pAddDataName) {
		return service.checkIsRequired(pPreviApiDataNameMap, pAddDataName);
	}

	public static StringBuilder checkListEnum(List<StandardApiDataName> pStandardApiDataNameList) {
		return service.checkListEnum(pStandardApiDataNameList);
	}
	
	public static StringBuilder checkDatakey(List<StandardApiDataName> pStandardApiDataNameList) {
		return service.checkDatakey(pStandardApiDataNameList);
	}

}
