package com.digiwin.athena.apimgmt.services;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;

@Service
public class ApiMgmtValidateApiDataNameService {

	@Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;

	/**
	 * 檢查是否有包含前一版字段
	 * 
	 * @param pPreviApiDataName pPreviApiDataName
	 * @param pAddDataName pAddDataName
	 */
	public StringBuilder checkApiIsLackDataName(List<StandardApiDataName> pPreviApiDataName, Map<String, StandardApiDataName> pAddDataName) {
		StringBuilder tLackDataName = new StringBuilder();
		for (StandardApiDataName tStandardApiDataName : pPreviApiDataName) {
			String tColumnType = tStandardApiDataName.getColumnType();
			String tDataName = tStandardApiDataName.getStandardDataName();
			String tDataType = tStandardApiDataName.getMsgType().toString();
			StandardApiDataName tParent = tStandardApiDataName.getParent();
			String tParentDataName = tParent == null ? "" : tParent.getStandardDataName();

			StandardApiDataName tDataNameisExist = pAddDataName.get(tColumnType + tDataName + tDataType + tParentDataName);
			if (tDataNameisExist == null) {
				resultStringBuilder(tLackDataName, tDataName);
			}
		}
		return tLackDataName;
	}

	/**
	 * 檢查前一版「為數組」欄位是否為Y，是的話匯入該字段不可為N
	 * 
	 * @param pPreviousApiDataName pPreviousApiDataName
	 * @param pAddDataName pAddDataName
	 */
	public StringBuilder checkIsArray(List<StandardApiDataName> pPreviousApiDataName, Map<String, StandardApiDataName> pAddDataName) {
		StringBuilder tIsArrayDataName = new StringBuilder();
		for (StandardApiDataName tApiDataName : pPreviousApiDataName) {
			String tColumnType = tApiDataName.getColumnType();
			boolean tIsArray = tApiDataName.getIsArray();
			if (tIsArray) {
				String tDataName = tApiDataName.getStandardDataName();
				String tDataType = tApiDataName.getMsgType().toString();
				StandardApiDataName tParent = tApiDataName.getParent();

				String tParentDataName = tParent == null ? "" : tParent.getStandardDataName();

				StandardApiDataName tStandardApiDataName = pAddDataName.get(tColumnType + tDataName + tDataType + tParentDataName);
				if (tStandardApiDataName != null) {
					boolean tApiDataNameIsArray = tStandardApiDataName.getIsArray();
					if (!tApiDataNameIsArray) {
						resultStringBuilder(tIsArrayDataName, tDataName);
					}
				}
			}
		}
		return tIsArrayDataName;
	}

	/**
	 * H、DATAKEY、P和E「為數組」不可為Y
	 * 原除M、D、SD、4D、5D...之外，「為數組」不可為Y
	 * 2022-03-11 Lillian 改為H、DATAKEY、P和E「為數組」不可為Y
	 * 2023-02-04 Lillian P改為允許「為數組」為Y
	 * 
	 * @param pAddDataNameList pAddDataNameList
	 * @return StringBuilder
	 */
	public StringBuilder isArrayCannotBeY(List<StandardApiDataName> pAddDataNameList) {
		StringBuilder tIsArrayCannotBeY = new StringBuilder();
		for (StandardApiDataName tAddDataName : pAddDataNameList) {
			if (tAddDataName.getIsArray()) {
				String tDataName = tAddDataName.getStandardDataName();
				String tColumnType = tAddDataName.getColumnType();
				if (Arrays.asList(ApimgmtConstant.NOT_ALLOW_ARRAY_COLUMN_TYPE).contains(tColumnType.toUpperCase())) {
					resultStringBuilder(tIsArrayCannotBeY, tDataName);
				}
			}
		}
		return tIsArrayCannotBeY;
	}

	/**
	 * 檢查新增的字段「必要」欄位是否為Y， 若該字段上一版也為Y->沒問題； 若該字段上一版為N->錯誤（N不可改為Y）；
	 * 若該字段上一版不存在->錯誤（新增的字段「必要」欄位一定要為N）
	 * 
	 * @param pPreviApiDataNameMap pPreviApiDataNameMap
	 * @param pAddDataName pAddDataName
	 */
	public StringBuilder checkIsRequired(Map<String, StandardApiDataName> pPreviApiDataNameMap, List<StandardApiDataName> pAddDataName) {
		StringBuilder tCannotIsRequired = new StringBuilder();
		for (StandardApiDataName tRequest : pAddDataName) {
			boolean tIsRequired = tRequest.getIsRequired();
			if (tIsRequired) {
				String tColumnType = tRequest.getColumnType();
				String tDataName = tRequest.getStandardDataName();
				String tDataType = tRequest.getMsgType().toString();
				StandardApiDataName tParent = tRequest.getParent();
				String tParentDataName = tParent == null ? "" : tParent.getStandardDataName();
				StandardApiDataName tPreviApiDataName = pPreviApiDataNameMap.get(tColumnType + tDataName + tDataType + tParentDataName);
				if (tPreviApiDataName != null) { // 該字段上一版存在
					boolean tPreviIsRequired = tPreviApiDataName.getIsRequired();
					if (!tPreviIsRequired) { // 該字段上一版是N
						resultStringBuilder(tCannotIsRequired, tDataName); // N不可以改為Y
					}
				} else { // 該字段上一版不存在
					resultStringBuilder(tCannotIsRequired, tDataName); // 新增的字段不可為Y
				}
			}
		}
		return tCannotIsRequired;
	}

	/**
	 * 檢查API「須分包」是否有異動
	 * 
	 * @param pPreviIsBatch pPreviIsBatch
	 * @param pIsBatch pIsBatch
	 * @return boolean
	 */
	public boolean checkBatchIsChanged(boolean pPreviIsBatch, boolean pIsBatch) {
		return pPreviIsBatch != pIsBatch;
	}

	/**
	 * 檢查API字段「調用模式」欄位是否有異動
	 * 
	 * @param pPreviSyncType pPreviSyncType
	 * @param pSyncType pSyncType
	 * @return boolean
	 */
	public boolean checkSyncTypeIsChanged(long pPreviSyncType, long pSyncType) {
		return pPreviSyncType != pSyncType;
	}

	public StringBuilder checkRequiredDataName(String[] pCheckRequiredDataName, String[] pRequiredDataName, Map<String, StandardApiDataName> pAddDataName) {
		StringBuilder tRequired = new StringBuilder();
		for (int i = pCheckRequiredDataName.length - 1; i >= 0; i--) {
			if (pAddDataName.get(pCheckRequiredDataName[i]) == null) {
				resultStringBuilder(tRequired, pRequiredDataName[i]);
			}
		}

		return tRequired;
	}

	private void resultStringBuilder(StringBuilder pStringBuilder, String pDataName) {
		if (pStringBuilder.toString().equals("")) {
			pStringBuilder.append(pDataName);
		} else {
			pStringBuilder.append(",").append(pDataName);
		}
	}

	public StringBuilder checkListEnum(List<StandardApiDataName> pStandardApiDataNameList) {
		StringBuilder tListEnumWrongFormat = new StringBuilder();
		
		for(StandardApiDataName tStandardApiDataName : pStandardApiDataNameList){
			String tDataName = tStandardApiDataName.getStandardDataName();
			String tListEnumZhTw = tStandardApiDataName.getListEnumZhTw();
			String tListEnumZhCN = tStandardApiDataName.getListEnumZhCn();
			String tListEnumEnUS = tStandardApiDataName.getListEnumEn();
			
			if(tListEnumZhTw != null || tListEnumZhCN != null || tListEnumEnUS != null){
				String tStrLi = MessageFormat.format("zh_TW:[{0}]\nzh_CN:[{1}]\nen_US:[{2}]", tListEnumZhTw, tListEnumZhCN, tListEnumEnUS);
				if (!tStrLi.matches(ApimgmtConstant.REGEX_LIST_ENUM_MULT)) {
					resultStringBuilder(tListEnumWrongFormat, tDataName);
				}
			}
		}
		return tListEnumWrongFormat;
	}
	
	/**
	 * 僅[P]和[F結尾]的字段可將為datakey設為Y 
	 */
	public StringBuilder checkDatakey(List<StandardApiDataName> pStandardApiDataNameList) {
		StringBuilder tListEnumWrongFormat = new StringBuilder();
		for(StandardApiDataName tStandardApiDataName : pStandardApiDataNameList){
			String tDataName = tStandardApiDataName.getStandardDataName();
			String tColumnType = tStandardApiDataName.getColumnType();
			boolean tDatakey = tStandardApiDataName.getIsDatakey();
			
			if(!tColumnType.endsWith("F") && !tColumnType.equals("P")){
				if(tDatakey){
					resultStringBuilder(tListEnumWrongFormat, tDataName);
				}
			}
		}
		return tListEnumWrongFormat;
	}
}
