/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.URLUtil;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.MultipartFile;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtDmcProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.service.util.DmcFileServiceUtil;
import com.digiwin.athena.apimgmt.util.Base64;
import com.digiwin.athena.apimgmt.util.Base64Util;
import com.digiwin.athena.apimgmt.util.DateUtil;
import com.digiwin.athena.apimgmt.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtDmcFileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtDmcFileService.class);
    @Autowired
    private ApiMgmtDmcProp apiMgmtDmcProp;
    @Autowired
    private ApiMgmtProp prop;
    ObjectMapper mapper = new ObjectMapper();

    public void uploadFileAndGenerateDownloadLink(ObjectNode pResponseNode, String pFilePath, String pFileName, boolean pIsDetail, int pFailedNum) throws Exception {
        String tSharedDownloadLink = null;
        String tFileId = DmcFileServiceUtil.uploadFile(new File(pFilePath), pFileName);
        if (!StringUtil.isEmptyOrSpace((Object)tFileId)) {
            log.info("\u4e0a\u50b3API\u898f\u683c\u6a94\u81f3dmc\u6210\u529f\uff0c\u6a94\u6848\u540d\u7a31:" + pFileName + " \u6a94\u6848ID:" + tFileId);
            tSharedDownloadLink = this.generateShareDownloadLink(tFileId);
        }
        if (!StringUtil.isEmptyOrSpace(tSharedDownloadLink)) {
            log.info("\u5206\u4eabAPI\u898f\u683c\u6a94\u81f3dmc\u6210\u529f\uff0c\u6a94\u6848\u540d\u7a31:" + pFileName + " \u6a94\u6848ID:" + tFileId + " \u4e0b\u8f09\u9023\u7d50:" + tSharedDownloadLink);
            if (pIsDetail) {
                pResponseNode.put(ApiAttributeEnum.detailFileLink.toString(), tSharedDownloadLink);
                if (pFailedNum != 0) {
                    pResponseNode.put(ApiAttributeEnum.failedNum.toString(), pFailedNum);
                }
            } else {
                pResponseNode.put(ApiAttributeEnum.fileLink.toString(), tSharedDownloadLink);
                pResponseNode.put(ApiAttributeEnum.fileName.toString(), pFileName);
            }
        }
    }

    public String uploadFile(File pFile, String pFileName) throws Exception {
        String tUserToken = this.login();
        String tFileId = "";
        if (!StringUtil.isEmptyOrSpace((Object)tUserToken)) {
            JsonNode tDataNode;
            String tDmcHost = this.apiMgmtDmcProp.getUrl();
            String tBucket = this.apiMgmtDmcProp.getBucket();
            String tDmcDirectoryId = this.apiMgmtDmcProp.getDirectoryId();
            String tUriStr = URLUtil.completeUrl((String)tDmcHost, (String)(String.format("/api/dmc/v2/file/%s/upload", tBucket) + "?bucket=" + tBucket));
            HttpRequest tPost = HttpRequest.ofPost((String)tUriStr);
            tPost.setHeader("digi-middleware-auth-user", (Object)tUserToken);
            tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tPost.setHeader("token", (Object)tUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            MultipartFile file = new MultipartFile("file", pFile);
            JsonObject tFileInfo = new JsonObject();
            tFileInfo.addProperty("directoryId", tDmcDirectoryId);
            tFileInfo.addProperty("displayName", pFileName);
            tFileInfo.addProperty("fileName", pFileName);
            tFileInfo.addProperty("expireDate", DateUtil.formatToSecond((Date)new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L))));
            tPost.setEntity((Object)MapUtil.of((Object)"fileInfo", (Object)tFileInfo));
            String tResponse = (String)HttpUtil.uploadFile((HttpRequest)tPost, (MultipartFile)file, String.class);
            JsonNode tResponseNode = this.mapper.readTree(tResponse);
            if (tResponseNode.get("data") != null && (tDataNode = tResponseNode.get("data")).get("id") != null) {
                tFileId = tDataNode.get("id").asText();
            }
        }
        return tFileId;
    }

    public String generateShareDownloadLink(String pFileId) throws Exception {
        String tUserToken = this.login();
        String tFileId = "";
        if (!StringUtil.isEmptyOrSpace((Object)tUserToken)) {
            JsonNode tDataNode;
            String tDmcHost = this.apiMgmtDmcProp.getUrl();
            String tBucket = this.apiMgmtDmcProp.getBucket();
            String tUriStr = URLUtil.completeUrl((String)tDmcHost, (String)(String.format("/api/dmc/v2/file/%s/share", tBucket) + "?bucket=" + tBucket));
            HttpRequest tPost = HttpRequest.ofPost((String)tUriStr);
            tPost.setHeader("digi-middleware-auth-user", (Object)tUserToken);
            tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
            tPost.setHeader("Content-Type", (Object)"application/json");
            tPost.setHeader("token", (Object)tUserToken);
            if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
                tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
            }
            HashMap<String, String> tRequestBody = new HashMap<String, String>();
            tRequestBody.put("fileId", pFileId);
            tRequestBody.put("expireDate", DateUtil.formatToSecond((Date)new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L))));
            tPost.setEntity(tRequestBody);
            String tResponse = (String)HttpUtil.execute((HttpRequest)tPost, String.class);
            JsonNode tResponseNode = this.mapper.readTree(tResponse);
            if (tResponseNode.get("data") != null && (tDataNode = tResponseNode.get("data")).get("url") != null) {
                tFileId = tDataNode.get("url").asText();
            }
        }
        return tFileId;
    }

    public String login() throws Exception {
        String tToken = null;
        HttpRequest tPost = HttpRequest.ofPost((String)URLUtil.completeUrl((String)this.apiMgmtDmcProp.getUrl(), (String)"/api/dmc/v1/auth/login"));
        HashMap<String, String> tRequestBody = new HashMap<String, String>();
        tRequestBody.put("username", this.apiMgmtDmcProp.getUser());
        tRequestBody.put("pwdhash", this.passwordHash(Base64Util.decodeString((String)this.apiMgmtDmcProp.getPassword())));
        tPost.setHeader("Content-Type", (Object)"application/json");
        tPost.setHeader("digi-middleware-auth-app", (Object)this.prop.getIamToken());
        if (null != ApiMgmtServiceContextHolder.getRouterKey()) {
            tPost.setHeader("routerKey", (Object)ApiMgmtServiceContextHolder.getRouterKey());
        }
        tPost.setEntity(tRequestBody);
        Map tResponse = (Map)HttpUtil.execute((HttpRequest)tPost, HashMap.class);
        if (null != tResponse && tResponse.get("userToken") != null) {
            tToken = (String)tResponse.get("userToken");
        }
        return tToken;
    }

    private String passwordHash(String pPassword) {
        String tPasswordHash = null;
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(pPassword.getBytes(StandardCharsets.UTF_8));
            hash = MessageDigest.getInstance("SHA-256").digest(hash);
            tPasswordHash = Base64.encode((byte[])hash);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tPasswordHash;
    }
}

