/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.constants.RequestMethodConstants;
import com.digiwin.athena.apimgmt.constants.SyncTypeConstants;
import com.digiwin.athena.apimgmt.dao.ApiMgmtProjectDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiCategoryDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiPagingDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.IsRequiredEnum;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.Project;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.model.ProjectVersionRelation;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiCategory;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiPaging;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import com.digiwin.athena.apimgmt.services.ApiMgmtProjectVersionService;
import com.digiwin.athena.apimgmt.util.StandardApiMessageUtil;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMgmtStandardApiExportWithXssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtStandardApiExportWithXssService.class);
    @Autowired
    ApiMgmtStandardApiDao standardApiDao;
    @Autowired
    ApiMgmtStandardApiVersionDao standardApiVersionDao;
    @Autowired
    ApiMgmtStandardApiDataNameDao standardApiDataNameDao;
    @Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;
    @Autowired
    ApiMgmtStandardApiPagingDao standardApiPagingDao;
    @Autowired
    ApiMgmtStandardApiCategoryDao standardApiCategoryDao;
    @Autowired
    ApiMgmtProjectDao projectDao;
    @Autowired
    ApiMgmtProjectVersionService projectVersionService;

    public XSSFWorkbook createXSSFWorkbook() {
        try {
            File d = new File(ApiMgmtApplicationParameter._FILE_EXPORT_PATH);
            if (!d.exists()) {
                boolean mk = d.mkdir();
                log.info("\u521b\u5efa\u8def\u5f84\u6210\u529f" + mk);
            }
            return this.getExportTemplateFile();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean removeFile(String filePath) {
        try {
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                return new File(filePath).delete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void createXSSFSheet(XSSFWorkbook pXSSFWorkbook, StandardApiVersion pStandardApiVersion, Integer number) {
        StandardApi tStandardApi = pStandardApiVersion.getStandardApi();
        List<StandardApiDataName> tStandardApiDataNames = this.standardApiDataNameDao.getByApiVerId(pStandardApiVersion.getId(), true);
        tStandardApiDataNames = tStandardApiDataNames.stream().distinct().collect(Collectors.toList());
        Map<Integer, List<StandardApiDataName>> tMsgTypeMap = StandardApiMessageUtil.getMsgTypeMap(tStandardApiDataNames);
        int tRequestCount = tMsgTypeMap.get(1).size();
        int tResponseSuccessCount = tMsgTypeMap.get(2).size();
        int tResponseFalseCount = tMsgTypeMap.get(3).size();
        XSSFSheet tDataSheet = pXSSFWorkbook.getSheetAt(1);
        XSSFSheet tTemplateSheet = pXSSFWorkbook.getSheetAt(4);
        XSSFSheet tNewSheet = pXSSFWorkbook.createSheet(number + 1 + "." + tStandardApi.getName());
        this.setSheetWidthAndHight(tTemplateSheet, tNewSheet);
        this.createDropDownMenu(tDataSheet, tTemplateSheet, tNewSheet, tRequestCount, tResponseSuccessCount, tResponseFalseCount);
        this.writeStandardAPI(pXSSFWorkbook, tTemplateSheet, tNewSheet, tStandardApi, pStandardApiVersion);
        this.writeStandardAPIDataName(pXSSFWorkbook, tTemplateSheet, tNewSheet, tMsgTypeMap, tStandardApiDataNames);
        int tNewSheetIdx = pXSSFWorkbook.getSheetIndex(tNewSheet.getSheetName());
        pXSSFWorkbook.setActiveSheet(tNewSheetIdx);
        pXSSFWorkbook.setSheetHidden(4, true);
    }

    private void createDropDownMenu(XSSFSheet pDataSheet, XSSFSheet pTemplateSheet, XSSFSheet pNewSheet, int pRequestCount, int pResponseSuccessCount, int pResponseFalseCount) {
        int tApiTypeCol = 24;
        int tRequestMethodCol = 26;
        int tSyncTypeCol = 6;
        int tPagingCol = 7;
        int tIsBtachCol = 10;
        int tGroupCol = 11;
        int tCategoryCol = 12;
        int tMsgFormatCol = 13;
        int tRequestFirstRow = 6;
        int tRequestLastRow = pRequestCount == 0 ? tRequestFirstRow + pRequestCount : tRequestFirstRow + pRequestCount - 1;
        int tResponseSuccessFirstRow = tRequestLastRow + 4;
        int tResponseSuccessLastRow = pResponseSuccessCount == 0 ? tResponseSuccessFirstRow + pResponseSuccessCount : tResponseSuccessFirstRow + pResponseSuccessCount - 1;
        int tResponseFalseFirstRow = tResponseSuccessLastRow + 4;
        int tResponseFalseLastRow = pResponseFalseCount == 0 ? tResponseFalseFirstRow + pResponseFalseCount : tResponseFalseFirstRow + pResponseFalseCount - 1;
        int tColumnTypeCol = 1;
        int tDataTypeCol = 5;
        int tIsRequiredCol = 6;
        int tIsDatakeyCol = 7;
        int tIsArrayCol = 8;
        int tCFCol = 4;
        CellRangeAddressList tApiTypeRegions = new CellRangeAddressList(2, 2, tApiTypeCol, tApiTypeCol);
        CellRangeAddressList tRequestMethodRegions = new CellRangeAddressList(2, 2, tRequestMethodCol, tRequestMethodCol);
        CellRangeAddressList tSyncTypeRegions = new CellRangeAddressList(2, 2, tSyncTypeCol, tSyncTypeCol);
        CellRangeAddressList tPagingRegions = new CellRangeAddressList(2, 2, tPagingCol, tPagingCol);
        CellRangeAddressList tIsBatchRegions = new CellRangeAddressList(2, 2, tIsBtachCol, tIsBtachCol);
        CellRangeAddressList tGroupRegions = new CellRangeAddressList(2, 2, tGroupCol, tGroupCol);
        CellRangeAddressList tCategoryRegions = new CellRangeAddressList(2, 2, tCategoryCol, tCategoryCol);
        CellRangeAddressList tMsgFormatRegions = new CellRangeAddressList(2, 2, tMsgFormatCol, tMsgFormatCol);
        CellRangeAddressList tRequestColumnTypeRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tColumnTypeCol, tColumnTypeCol);
        CellRangeAddressList tResponseSuccessColumnTypeRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tColumnTypeCol, tColumnTypeCol);
        CellRangeAddressList tResponseFalseColumnTypeRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tColumnTypeCol, tColumnTypeCol);
        CellRangeAddressList tRequestDataTypeRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tDataTypeCol, tDataTypeCol);
        CellRangeAddressList tResponseSuccessDataTypeRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tDataTypeCol, tDataTypeCol);
        CellRangeAddressList tResponseFalseDataTypeRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tDataTypeCol, tDataTypeCol);
        CellRangeAddressList tRequestIsRequiredRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tIsRequiredCol, tIsRequiredCol);
        CellRangeAddressList tResponseSuccessIsRequiredRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tIsRequiredCol, tIsRequiredCol);
        CellRangeAddressList tResponseFalseIsRequiredRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tIsRequiredCol, tIsRequiredCol);
        CellRangeAddressList tRequestIsDatakeyRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tIsDatakeyCol, tIsDatakeyCol);
        CellRangeAddressList tResponseSuccessIsDatakeyRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tIsDatakeyCol, tIsDatakeyCol);
        CellRangeAddressList tResponseFalseIsDatakeyRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tIsDatakeyCol, tIsDatakeyCol);
        CellRangeAddressList tRequestIsArrayRegions = new CellRangeAddressList(tRequestFirstRow, tRequestLastRow, tIsArrayCol, tIsArrayCol);
        CellRangeAddressList tResponseSuccessIsArrayRegions = new CellRangeAddressList(tResponseSuccessFirstRow, tResponseSuccessLastRow, tIsArrayCol, tIsArrayCol);
        CellRangeAddressList tResponseFalseIsArrayRegions = new CellRangeAddressList(tResponseFalseFirstRow, tResponseFalseLastRow, tIsArrayCol, tIsArrayCol);
        CellRangeAddressList tCFRegions = new CellRangeAddressList();
        tCFRegions.addCellRangeAddress(tRequestFirstRow, tCFCol, tRequestLastRow, tCFCol);
        tCFRegions.addCellRangeAddress(tResponseSuccessFirstRow, tCFCol, tResponseSuccessLastRow, tCFCol);
        tCFRegions.addCellRangeAddress(tResponseFalseFirstRow, tCFCol, tResponseFalseLastRow, tCFCol);
        XSSFDataValidationHelper helper = new XSSFDataValidationHelper(pNewSheet);
        String[] tApiTypeList = ApiTypeConstants.API_TYPE_ARRAY;
        DataValidationConstraint tApiTypeConstraint = helper.createExplicitListConstraint(tApiTypeList);
        String[] tRequestMethodList = RequestMethodConstants.REQUEST_METHOD_ARRAY;
        DataValidationConstraint tRequestMethodConstraint = helper.createExplicitListConstraint(tRequestMethodList);
        String[] tIsSyncTypeList = SyncTypeConstants.SYNC_TYPE_ARRAY;
        DataValidationConstraint tSyncTypeConstraint = helper.createExplicitListConstraint(tIsSyncTypeList);
        List tStandardApiPagingList = this.standardApiPagingDao.getAll();
        String[] tPagingList = new String[tStandardApiPagingList.size()];
        for (int i = 0; i < tStandardApiPagingList.size(); ++i) {
            tPagingList[i] = ((StandardApiPaging)tStandardApiPagingList.get(i)).getId() + "." + ((StandardApiPaging)tStandardApiPagingList.get(i)).getNameZhTw();
        }
        DataValidationConstraint tPagingConstraint = helper.createExplicitListConstraint(tPagingList);
        String[] tIsBatchList = new String[]{"Y", "N"};
        DataValidationConstraint tIsBatchConstraint = helper.createExplicitListConstraint(tIsBatchList);
        String[] tGroupList = this.getDropDownData(pDataSheet, 0);
        DataValidationConstraint tGroupConstraint = helper.createExplicitListConstraint(tGroupList);
        List tStandardApiCategoryList = this.standardApiCategoryDao.getAll();
        String[] tCategoryList = new String[tStandardApiCategoryList.size()];
        for (int i = 0; i < tStandardApiCategoryList.size(); ++i) {
            tCategoryList[i] = ((StandardApiCategory)tStandardApiCategoryList.get(i)).getId() + "." + ((StandardApiCategory)tStandardApiCategoryList.get(i)).getNameZhTw();
        }
        DataValidationConstraint tCategoryConstraint = helper.createExplicitListConstraint(tCategoryList);
        String[] tMsgFormatlist = this.getDropDownData(pDataSheet, 2);
        DataValidationConstraint tMsgFormatConstraint = helper.createExplicitListConstraint(tMsgFormatlist);
        String[] tColumnTypelist = this.getDropDownData(pDataSheet, 3);
        DataValidationConstraint tColumnTypeConstraint = helper.createExplicitListConstraint(tColumnTypelist);
        String[] tDataTypelist = this.getDropDownData(pDataSheet, 4);
        DataValidationConstraint tDataTypeConstraint = helper.createExplicitListConstraint(tDataTypelist);
        String[] tIsRequiredlist = this.getDropDownData(pDataSheet, 5);
        DataValidationConstraint tIsRequiredConstraint = helper.createExplicitListConstraint(tIsRequiredlist);
        String[] tIsDatakeyList = new String[]{"Y"};
        DataValidationConstraint tIsDatakeyConstraint = helper.createExplicitListConstraint(tIsDatakeyList);
        String[] tIsArrayList = new String[]{"Y", "N"};
        DataValidationConstraint tIsArrayConstraint = helper.createExplicitListConstraint(tIsArrayList);
        DataValidation tApiTypeValidation = helper.createValidation(tApiTypeConstraint, tApiTypeRegions);
        DataValidation tRequestMethodValidation = helper.createValidation(tRequestMethodConstraint, tRequestMethodRegions);
        DataValidation tSyncTypeValidation = helper.createValidation(tSyncTypeConstraint, tSyncTypeRegions);
        DataValidation tPagingValidation = helper.createValidation(tPagingConstraint, tPagingRegions);
        DataValidation tIsBatchValidation = helper.createValidation(tIsBatchConstraint, tIsBatchRegions);
        DataValidation tGroupValidation = helper.createValidation(tGroupConstraint, tGroupRegions);
        DataValidation tCategoryValidation = helper.createValidation(tCategoryConstraint, tCategoryRegions);
        DataValidation tMsgFormatValidation = helper.createValidation(tMsgFormatConstraint, tMsgFormatRegions);
        DataValidation tRequestColumnTypeValidation = helper.createValidation(tColumnTypeConstraint, tRequestColumnTypeRegions);
        DataValidation tResponseSuccessColumnTypeValidation = helper.createValidation(tColumnTypeConstraint, tResponseSuccessColumnTypeRegions);
        DataValidation tResponseFalseColumnTypeValidation = helper.createValidation(tColumnTypeConstraint, tResponseFalseColumnTypeRegions);
        DataValidation tRequestDataTypeValidation = helper.createValidation(tDataTypeConstraint, tRequestDataTypeRegions);
        DataValidation tResponseSuccessDataTypeValidation = helper.createValidation(tDataTypeConstraint, tResponseSuccessDataTypeRegions);
        DataValidation tResponseFalseDataTypeValidation = helper.createValidation(tDataTypeConstraint, tResponseFalseDataTypeRegions);
        DataValidation tRequestIsRequiredValidation = helper.createValidation(tIsRequiredConstraint, tRequestIsRequiredRegions);
        DataValidation tResponseSuccessIsRequiredValidation = helper.createValidation(tIsRequiredConstraint, tResponseSuccessIsRequiredRegions);
        DataValidation tResponseFalseIsRequiredValidation = helper.createValidation(tIsRequiredConstraint, tResponseFalseIsRequiredRegions);
        DataValidation tRequestIsDatakeyValidation = helper.createValidation(tIsDatakeyConstraint, tRequestIsDatakeyRegions);
        DataValidation tResponseSuccessIsDatakeyValidation = helper.createValidation(tIsDatakeyConstraint, tResponseSuccessIsDatakeyRegions);
        DataValidation tResponseFalseDatakeyValidation = helper.createValidation(tIsDatakeyConstraint, tResponseFalseIsDatakeyRegions);
        DataValidation tRequestIsArrayValidation = helper.createValidation(tIsArrayConstraint, tRequestIsArrayRegions);
        DataValidation tResponseSuccessIsArrayValidation = helper.createValidation(tIsArrayConstraint, tResponseSuccessIsArrayRegions);
        DataValidation tResponseFalseArrayValidation = helper.createValidation(tIsArrayConstraint, tResponseFalseIsArrayRegions);
        pNewSheet.addValidationData(tApiTypeValidation);
        pNewSheet.addValidationData(tRequestMethodValidation);
        pNewSheet.addValidationData(tSyncTypeValidation);
        pNewSheet.addValidationData(tPagingValidation);
        pNewSheet.addValidationData(tIsBatchValidation);
        pNewSheet.addValidationData(tGroupValidation);
        pNewSheet.addValidationData(tCategoryValidation);
        pNewSheet.addValidationData(tMsgFormatValidation);
        pNewSheet.addValidationData(tRequestColumnTypeValidation);
        pNewSheet.addValidationData(tResponseSuccessColumnTypeValidation);
        pNewSheet.addValidationData(tResponseFalseColumnTypeValidation);
        pNewSheet.addValidationData(tRequestDataTypeValidation);
        pNewSheet.addValidationData(tResponseSuccessDataTypeValidation);
        pNewSheet.addValidationData(tResponseFalseDataTypeValidation);
        pNewSheet.addValidationData(tRequestIsRequiredValidation);
        pNewSheet.addValidationData(tResponseSuccessIsRequiredValidation);
        pNewSheet.addValidationData(tResponseFalseIsRequiredValidation);
        pNewSheet.addValidationData(tRequestIsDatakeyValidation);
        pNewSheet.addValidationData(tResponseSuccessIsDatakeyValidation);
        pNewSheet.addValidationData(tResponseFalseDatakeyValidation);
        pNewSheet.addValidationData(tRequestIsArrayValidation);
        pNewSheet.addValidationData(tResponseSuccessIsArrayValidation);
        pNewSheet.addValidationData(tResponseFalseArrayValidation);
        pNewSheet.getSheetConditionalFormatting().addConditionalFormatting(tCFRegions.getCellRangeAddresses(), (ConditionalFormattingRule)pTemplateSheet.getSheetConditionalFormatting().getConditionalFormattingAt(0).getRule(0));
    }

    private String[] getDropDownData(XSSFSheet pDataSheet, int pRowNumber) {
        XSSFRow Row2 = pDataSheet.getRow(pRowNumber);
        int tCellCount = Row2.getPhysicalNumberOfCells();
        String[] tCellList = new String[tCellCount - 1];
        for (int tCellNumber = 1; tCellNumber < tCellCount; ++tCellNumber) {
            tCellList[tCellNumber - 1] = Row2.getCell(tCellNumber).getStringCellValue();
        }
        return tCellList;
    }

    public XSSFWorkbook getExportTemplateFile() {
        XSSFWorkbook tXSSFWorkbook;
        try {
            String tTemplateFilePath = ApiMgmtApplicationParameter._FILE_TEMPLATE_PATH + "/" + ApiMgmtApplicationParameter._EXPORT_TEMPLATE_FILE_NAME;
            log.info("file path: " + tTemplateFilePath);
            tXSSFWorkbook = new XSSFWorkbook(ResourceUtil.getStream((String)tTemplateFilePath));
        }
        catch (Exception e) {
            log.error("Catch exception when export Get Template file.");
            log.error(e.getMessage());
            return null;
        }
        return tXSSFWorkbook;
    }

    public void setEasyApiInfo(XSSFSheet pDataNameSheet, Map<String, Object> pObjectMap) {
        XSSFRow tRow = pDataNameSheet.createRow(Integer.parseInt(pObjectMap.get("numeric").toString()) + 1);
        int tColumnNumber = 0;
        XSSFCell tCell = tRow.createCell(tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("name")));
        tColumnNumber = 1;
        tCell = tRow.createCell(tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("description")));
        tColumnNumber = 2;
        tCell = tRow.createCell(tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("version")));
        tColumnNumber = 3;
        tCell = tRow.createCell(tColumnNumber);
        tCell.setCellValue(ApiTypeConstants.getNameByCode((String)String.valueOf(pObjectMap.get("apiType"))));
        tColumnNumber = 4;
        tCell = tRow.createCell(tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("projectName")));
        tColumnNumber = 5;
        tCell = tRow.createCell(tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("projectVersionNameListStr")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("approvedStatus")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get(ApiAttributeEnum.approvedTime.toString())));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("remark")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("syncType")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("msgFormat")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("categoryName")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("requester")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("provider")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("firstApplicant")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("lastApplicant")));
        tCell = tRow.createCell(++tColumnNumber);
        tCell.setCellValue(String.valueOf(pObjectMap.get("tenantId")));
    }

    private void writeStandardAPI(XSSFWorkbook pXSSFWorkbook, XSSFSheet pTemplateSheet, XSSFSheet pNewSheet, StandardApi pStandardApi, StandardApiVersion pStandardApiVersion) {
        XSSFRow tNewRow;
        for (int tRowNum = 0; tRowNum < 2; ++tRowNum) {
            tNewRow = pNewSheet.createRow(tRowNum);
            XSSFRow tTemplateStandardAPI = pTemplateSheet.getRow(tRowNum);
            this.copyRow(pXSSFWorkbook, tTemplateStandardAPI, tNewRow, null, true);
        }
        tNewRow = pNewSheet.createRow(2);
        this.copyRow(pXSSFWorkbook, pTemplateSheet.getRow(2), tNewRow, null, false);
        tNewRow.getCell(1).setCellValue(pStandardApi.getName());
        tNewRow.getCell(2).setCellValue(pStandardApi.getDescriptionZhTw());
        tNewRow.getCell(3).setCellValue(pStandardApi.getDescriptionZhCn());
        tNewRow.getCell(4).setCellValue(pStandardApi.getDescriptionEnUs());
        tNewRow.getCell(5).setCellValue(pStandardApiVersion.getVersion());
        tNewRow.getCell(6).setCellValue(SyncTypeConstants.getNameByCode((Long)pStandardApi.getStandardApiSyncType().getId()));
        tNewRow.getCell(7).setCellValue(pStandardApi.getStandardApiPaging().getId() + "." + pStandardApi.getStandardApiPaging().getNameZhTw());
        tNewRow.getCell(8).setCellValue(pStandardApi.getRequester());
        tNewRow.getCell(9).setCellValue(pStandardApi.getProvider());
        if (pStandardApi.getIsBatch().booleanValue()) {
            tNewRow.getCell(10).setCellValue("Y");
        } else {
            tNewRow.getCell(10).setCellValue("N");
        }
        tNewRow.getCell(11).setCellValue(pStandardApi.getStandardApiGroup().getId() + "." + pStandardApi.getStandardApiGroup().getNameZhTw());
        tNewRow.getCell(12).setCellValue(pStandardApi.getStandardApiCategory().getId() + "." + pStandardApi.getStandardApiCategory().getNameZhTw());
        tNewRow.getCell(13).setCellValue(pStandardApi.getMsgFormat());
        tNewRow.getCell(14).setCellValue(pStandardApi.getTagZhTw());
        tNewRow.getCell(15).setCellValue(pStandardApi.getTagZhCn());
        tNewRow.getCell(16).setCellValue(pStandardApi.getTagEnUs());
        tNewRow.getCell(17).setCellValue(pStandardApi.getRemarkZhTw());
        tNewRow.getCell(18).setCellValue(pStandardApi.getRemarkZhCn());
        tNewRow.getCell(19).setCellValue(pStandardApi.getRemarkEnUs());
        tNewRow.getCell(20).setCellValue(pStandardApi.getTenantId());
        tNewRow.getCell(21).setCellValue(pStandardApi.getPackageName());
        if (pStandardApiVersion.getIdempotency() != null) {
            if (pStandardApiVersion.getIdempotency().booleanValue()) {
                tNewRow.getCell(22).setCellValue("Y");
            } else {
                tNewRow.getCell(22).setCellValue("N");
            }
        } else {
            tNewRow.getCell(22).setCellValue("N");
        }
        if (pStandardApiVersion.getUpdateHistory() == null) {
            tNewRow.getCell(23).setCellValue("");
        } else {
            tNewRow.getCell(23).setCellValue(pStandardApiVersion.getUpdateHistory());
        }
        int tColumnNumber = 24;
        tNewRow.getCell(tColumnNumber).setCellValue(ApiTypeConstants.getNameByCode((String)pStandardApi.getApiType()));
        if ("openapi".equals(pStandardApi.getApiType())) {
            tNewRow.getCell(++tColumnNumber).setCellValue(pStandardApi.getApiPath());
            tNewRow.getCell(++tColumnNumber).setCellValue(RequestMethodConstants.getNameByCode((String)pStandardApi.getRequestMethod()));
        }
        tColumnNumber = 27;
        if (CollUtil.isEmpty(pStandardApi.getProjectVersionRelations())) {
            tNewRow.getCell(tColumnNumber).setCellValue("Athena");
            tNewRow.getCell(tColumnNumber + 1).setCellValue("");
        } else {
            Long projectId = pStandardApi.getProjectVersionRelations().get(0).getProjectId();
            Project project = (Project)this.projectDao.get(projectId);
            tNewRow.getCell(tColumnNumber).setCellValue(project.getProjectName());
            List<Long> idList = pStandardApi.getProjectVersionRelations().stream().map(ProjectVersionRelation::getProjectVersionId).distinct().collect(Collectors.toList());
            List<ProjectVersion> projectVersionList = this.projectVersionService.queryProjectVersionByIdList(idList);
            List nameList = projectVersionList.stream().map(ProjectVersion::getProjectVersionName).collect(Collectors.toList());
            String joinedString = String.join((CharSequence)",", nameList);
            tNewRow.getCell(tColumnNumber + 1).setCellValue(joinedString);
        }
    }

    private void writeStandardAPIDataName(XSSFWorkbook pXSSFWorkbook, XSSFSheet pTemplateSheet, XSSFSheet pNewSheet, Map<Integer, List<StandardApiDataName>> pMsgTypeMap, List<StandardApiDataName> pStandardApiDataNames) {
        int tRequestTitleRow = 3;
        int tRequestRow = 6;
        int tResponseSuccessTitleRow = 6 + pMsgTypeMap.get(1).size();
        int tResponseSuccessRow = tResponseSuccessTitleRow + 3;
        int tResponseFalseTitleRow = tResponseSuccessRow + pMsgTypeMap.get(2).size();
        int tResponseFalseRow = tResponseFalseTitleRow + 3;
        int tTemplateRequestTitleRow = 3;
        int tTemplateResponseSuccessTitleRow = 36;
        int tTemplateResponseFalseTitleRow = 54;
        int tTemplateStandardApiDataNameRow = 6;
        TreeSet<String> tTreeSet = this.collectPrdNames(pStandardApiDataNames);
        Object[] tArray = tTreeSet.toArray();
        int tStartTitleRow = 0;
        int tStartContentRow = 0;
        int tTemplateTitleRow = 0;
        for (Integer tInteger : pMsgTypeMap.keySet()) {
            XSSFRow tNewRow;
            List<StandardApiDataName> tStandardApiDataNames = pMsgTypeMap.get(tInteger);
            switch (tInteger) {
                case 1: {
                    tStartTitleRow = 3;
                    tStartContentRow = 6;
                    tTemplateTitleRow = tTemplateRequestTitleRow;
                    break;
                }
                case 2: {
                    tStartTitleRow = tResponseSuccessTitleRow;
                    tStartContentRow = tResponseSuccessRow;
                    tTemplateTitleRow = tTemplateResponseSuccessTitleRow;
                    break;
                }
                case 3: {
                    tStartTitleRow = tResponseFalseTitleRow;
                    tStartContentRow = tResponseFalseRow;
                    tTemplateTitleRow = tTemplateResponseFalseTitleRow;
                    break;
                }
            }
            int tStartRow = tStartTitleRow;
            while (tStartRow < tStartContentRow) {
                tNewRow = pNewSheet.createRow(tStartRow);
                XSSFRow tTemplateStandardAPI = pTemplateSheet.getRow(tTemplateTitleRow);
                this.copyRow(pXSSFWorkbook, tTemplateStandardAPI, tNewRow, null, true);
                if (tStartRow + 1 == tStartContentRow) {
                    int tSize = tArray.length;
                    for (int ii = 0; ii < tSize; ++ii) {
                        if (null == tNewRow.getCell(22 + ii)) {
                            tNewRow.createCell(22 + ii);
                        }
                        tNewRow.getCell(22 + ii).setCellValue((String)tArray[ii]);
                    }
                }
                ++tStartRow;
                ++tTemplateTitleRow;
            }
            pNewSheet.addMergedRegion(new CellRangeAddress(tStartTitleRow, tStartTitleRow, 1, 2));
            pNewSheet.addMergedRegion(new CellRangeAddress(tStartTitleRow + 1, tStartTitleRow + 1, 1, 3));
            XSSFCellStyle tAPIDataNameStyle = this.newAPIDataNameStyle(pXSSFWorkbook, pTemplateSheet.getRow(tTemplateStandardApiDataNameRow));
            tStartRow = tStartContentRow;
            for (int tIndex = 0; tIndex < tStandardApiDataNames.size(); ++tIndex) {
                tNewRow = pNewSheet.createRow(tStartRow);
                this.copyRow(pXSSFWorkbook, pTemplateSheet.getRow(tTemplateStandardApiDataNameRow), tNewRow, tAPIDataNameStyle, false);
                StandardApiDataName tStandardApiDataName = tStandardApiDataNames.get(tIndex);
                if (tStandardApiDataName.getIsBusinesskey() != null && tStandardApiDataName.getIsBusinesskey().booleanValue()) {
                    tNewRow.getCell(0).setCellValue("Y");
                }
                tNewRow.getCell(1).setCellValue(tStandardApiDataName.getColumnType());
                if (tStandardApiDataName.getParent() != null) {
                    tNewRow.getCell(2).setCellValue(tStandardApiDataName.getParent().getStandardDataName());
                }
                String tDataNameSheetName = pXSSFWorkbook.getSheetAt(2).getSheetName();
                int tCheckRow = tStartRow + 1;
                String tFormulaFormat = "IF(ISBLANK(E%2$d),\"NEW\",IF(OR(SUMPRODUCT(--(EXACT(%1$s!A:A,E%2$d))),AND(OR(E%2$d=\"EntId\",E%2$d=\"CompanyId\",E%2$d=\"PlantId\"),B%2$d=\"datakey\"),B%2$d=\"H\"),\"\",\"NEW\"))";
                String tCheckDataNameFormula = String.format(tFormulaFormat, tDataNameSheetName, tCheckRow);
                tNewRow.getCell(3).setCellFormula(tCheckDataNameFormula);
                tNewRow.getCell(4).setCellValue(tStandardApiDataName.getStandardDataName());
                tNewRow.getCell(5).setCellValue(tStandardApiDataName.getDataType());
                if (tStandardApiDataName.getIsRequired().booleanValue()) {
                    tNewRow.getCell(6).setCellValue(IsRequiredEnum.Y.toString());
                } else {
                    tNewRow.getCell(6).setCellValue(IsRequiredEnum.N.toString());
                }
                if (tStandardApiDataName.getIsDatakey() != null && tStandardApiDataName.getIsDatakey().booleanValue()) {
                    tNewRow.getCell(7).setCellValue("Y");
                }
                if (tStandardApiDataName.getIsArray() != null && tStandardApiDataName.getIsArray().booleanValue()) {
                    tNewRow.getCell(8).setCellValue("Y");
                }
                if (tStandardApiDataName.getCanSort() != null && tStandardApiDataName.getCanSort().booleanValue()) {
                    tNewRow.getCell(9).setCellValue("Y");
                }
                if (tStandardApiDataName.getCanFilter() != null && tStandardApiDataName.getCanFilter().booleanValue()) {
                    tNewRow.getCell(10).setCellValue("Y");
                }
                tNewRow.getCell(11).setCellValue(tStandardApiDataName.getDescriptionZhTw());
                tNewRow.getCell(12).setCellValue(tStandardApiDataName.getDescriptionZhCn());
                tNewRow.getCell(13).setCellValue(tStandardApiDataName.getDescriptionEnUs());
                tNewRow.getCell(14).setCellValue(tStandardApiDataName.getValue());
                if (tStandardApiDataName.getRemarkZhTw() != null) {
                    tNewRow.getCell(15).setCellValue(tStandardApiDataName.getRemarkZhTw());
                }
                if (tStandardApiDataName.getRemarkZhCn() != null) {
                    tNewRow.getCell(16).setCellValue(tStandardApiDataName.getRemarkZhCn());
                }
                if (tStandardApiDataName.getRemarkEnUs() != null) {
                    tNewRow.getCell(17).setCellValue(tStandardApiDataName.getRemarkEnUs());
                }
                if (tStandardApiDataName.getListEnumZhTw() != null) {
                    tNewRow.getCell(18).setCellValue(tStandardApiDataName.getListEnumZhTw());
                }
                if (tStandardApiDataName.getListEnumZhTw() != null) {
                    tNewRow.getCell(19).setCellValue(tStandardApiDataName.getListEnumZhCn());
                }
                if (tStandardApiDataName.getListEnumZhTw() != null) {
                    tNewRow.getCell(20).setCellValue(tStandardApiDataName.getListEnumEn());
                }
                if (tStandardApiDataName.getUpdateHistory() == null) {
                    tNewRow.getCell(21).setCellValue("");
                } else {
                    tNewRow.getCell(21).setCellValue(tStandardApiDataName.getUpdateHistory());
                }
                for (int ii = 0; ii < tArray.length; ++ii) {
                    ProductApiDataName[] tProductApiDataNames = this.filterProductApiDataName(tStandardApiDataName.getProductApiDataNames(), (String)tArray[ii]);
                    if (0 >= tProductApiDataNames.length || null == tProductApiDataNames[0].getLength()) continue;
                    String tStrLi = "";
                    if ("string".equals(tStandardApiDataName.getDataType())) {
                        tStrLi = tProductApiDataNames[0].getLength().toString();
                    } else if ("numeric".equals(tStandardApiDataName.getDataType())) {
                        tStrLi = tProductApiDataNames[0].getLength() + "," + tProductApiDataNames[0].getPrecision();
                    }
                    if (null == tNewRow.getCell(22 + ii)) {
                        tNewRow.createCell(22 + ii);
                    }
                    tNewRow.getCell(22 + ii).setCellValue(tStrLi);
                }
                ++tStartRow;
            }
        }
    }

    private void setSheetWidthAndHight(XSSFSheet pTemplateSheet, XSSFSheet pNewSheet) {
        for (int tColumnNumber = 0; tColumnNumber <= 22; ++tColumnNumber) {
            pNewSheet.setColumnWidth(tColumnNumber, pTemplateSheet.getColumnWidth(tColumnNumber));
        }
    }

    private void copyRow(XSSFWorkbook pWorkbook, XSSFRow pTemplateRow, XSSFRow pNewRow, XSSFCellStyle pNewstyle, boolean pCopyValueFlag) {
        Iterator tCellIt = pTemplateRow.cellIterator();
        while (tCellIt.hasNext()) {
            XSSFCell tTemplateCell = (XSSFCell)tCellIt.next();
            XSSFCell tNewCell = pNewRow.createCell(tTemplateCell.getColumnIndex());
            this.copyCell(pWorkbook, tTemplateCell, tNewCell, pNewstyle, pCopyValueFlag);
        }
    }

    private void copyCell(XSSFWorkbook pXSSFWorkbook, XSSFCell pTemplateCell, XSSFCell pNewCell, XSSFCellStyle pNewstyle, boolean copyValueFlag) {
        if (pNewstyle != null) {
            if (pNewCell.getColumnIndex() < 22) {
                pNewCell.setCellStyle((CellStyle)pNewstyle);
            }
        } else {
            XSSFCellStyle tNewstyle = pXSSFWorkbook.createCellStyle();
            tNewstyle.cloneStyleFrom((CellStyle)pTemplateCell.getCellStyle());
            tNewstyle.setWrapText(true);
            pNewCell.setCellStyle((CellStyle)tNewstyle);
        }
        if (pTemplateCell.getHyperlink() != null) {
            pNewCell.setHyperlink((Hyperlink)pTemplateCell.getHyperlink());
        }
        if (copyValueFlag) {
            pNewCell.setCellValue((RichTextString)pTemplateCell.getRichStringCellValue());
        }
    }

    private TreeSet<String> collectPrdNames(List<StandardApiDataName> pStandardApiDataNames) {
        TreeSet tPrdNms = Sets.newTreeSet();
        for (StandardApiDataName tStandardApiDataName : pStandardApiDataNames) {
            List<ProductApiDataName> tProductApiDataNames = tStandardApiDataName.getProductApiDataNames();
            for (ProductApiDataName tProductApiDataName : tProductApiDataNames) {
                String tPrdNm = tProductApiDataName.getProduct().getName();
                tPrdNms.add(tPrdNm);
            }
        }
        return tPrdNms;
    }

    private ProductApiDataName[] filterProductApiDataName(List<ProductApiDataName> pList, String pPrdName) {
        return (ProductApiDataName[])CollUtil.emptyIfNull(pList).stream().filter(tProductApiDataName -> pPrdName.equals(tProductApiDataName.getProduct().getName())).toArray(ProductApiDataName[]::new);
    }

    private XSSFCellStyle newAPIDataNameStyle(XSSFWorkbook pXSSFWorkbook, XSSFRow pTemplateRow) {
        XSSFCellStyle tNewstyle = pXSSFWorkbook.createCellStyle();
        XSSFCell tCell = pTemplateRow.getCell(0);
        tNewstyle.cloneStyleFrom((CellStyle)tCell.getCellStyle());
        tNewstyle.setWrapText(true);
        return tNewstyle;
    }
}

