package com.digiwin.athena.apimgmt.apiservice;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardDataNameDao;
import com.digiwin.athena.apimgmt.exception.BaseException;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.StandardDataName;

import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 词典导出(用于词典审核，无页面展示用处)
 * /restful/standard/apimgmt/StandardDate/Export
 */
@Slf4j
@Service
public class ApiMgmtStandardDataExportService {


	@Autowired
    ApiMgmtStandardDataNameDao standardDataNameDao;

	public ApiMgmtStandardDataExportService() {
		super();
	}

	/**
	 * 词典导出
	 * @throws BaseException BaseException
	 */
	public synchronized void execute(OutputStream out) throws BaseException {
		List<Map<String, Object>> sheetsList = new ArrayList<>();
		try {
			List<StandardDataName> unApprovedList = standardDataNameDao.getDataNameByApprovedStatus(ApimgmtConstant.APPROVED_STATUS_DRAFT,false);
			export(unApprovedList, sheetsList);
			Workbook workBook = ExcelExportUtil.exportExcel(sheetsList, ExcelType.HSSF);
			workBook.write(out);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
	}

	private <T> void export(List<T> list, List<Map<String, Object>> sheetsList) {
		// 创建参数对象（用来设定excel得sheet得内容等信息）
		ExportParams deptExportParams = new ExportParams();
		// 设置sheet得名称
		deptExportParams.setSheetName(ApimgmtConstant.SHEET_DATA_NAME);
		// 创建sheet1使用得map
		Map<String, Object> deptExportMap = new HashMap<>();
		// title的参数为ExportParams类型，目前仅仅在ExportParams中设置了sheetName
		deptExportMap.put("title", deptExportParams);
		// 模版导出对应得实体类型
		deptExportMap.put("entity", StandardDataName.class);
		// sheet中要填充得数据
		deptExportMap.put("data", list);
		// 将sheet使用得map进行包装
		sheetsList.add(deptExportMap);
	}
}
