package com.digiwin.athena.apimgmt.facade;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetOtherService;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiInfoDTO;
import com.digiwin.athena.apimgmt.facade.dto.ApiMgmtApiKeyDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ApiInfoFacadeService implements IApiInfoFacadeService {

    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;

    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public List<ApiMgmtApiInfoDTO> queryByKey(List<ApiMgmtApiKeyDTO> apiKeys) throws Exception {
        if (CollUtil.isEmpty(apiKeys)) {
            return new ArrayList<>();
        }

        String queryJson = buildQueryJson(apiKeys);
        log.info("Query API by keys, json: {}", queryJson);

        Map<String, Object> resultMap = advanceSearchApiListGetOtherService.execute(queryJson);

        return convertToApiInfoDTOList(resultMap);
    }

    private String buildQueryJson(List<ApiMgmtApiKeyDTO> apiKeys) {
        ObjectNode rootNode = mapper.createObjectNode();
        ArrayNode conditionList = mapper.createArrayNode();

        int order = 0;
        for (int i = 0; i < apiKeys.size(); i++) {
            ApiMgmtApiKeyDTO key = apiKeys.get(i);
            String mark = i == 0 ? ApimgmtConstant.MARK_AND : ApimgmtConstant.MARK_OR;
            String openBracket = "(";
            String closeBracket = ")";

            ObjectNode apiNameNode = mapper.createObjectNode();
            apiNameNode.put(ApimgmtConstant.CONDITION, "apiName");
            apiNameNode.put(ApimgmtConstant.EQUATION, "=");
            apiNameNode.put(ApimgmtConstant.CONTENT, key.getApiName());
            apiNameNode.put(ApimgmtConstant.MARK, mark);
            apiNameNode.put(ApimgmtConstant.ORDER, order++);
            apiNameNode.put(ApimgmtConstant.BRACKET, openBracket);
            conditionList.add(apiNameNode);

            if (key.getBranch() != null) {
                ObjectNode apiVersionNode = mapper.createObjectNode();
                apiVersionNode.put(ApimgmtConstant.CONDITION, "apiBranch");
                apiVersionNode.put(ApimgmtConstant.EQUATION, "=");
                apiVersionNode.put(ApimgmtConstant.CONTENT, key.getBranch());
                apiVersionNode.put(ApimgmtConstant.MARK, ApimgmtConstant.MARK_AND);
                apiVersionNode.put(ApimgmtConstant.ORDER, order++);
                apiVersionNode.put(ApimgmtConstant.BRACKET, "");
                conditionList.add(apiVersionNode);
            }

            if (key.getApplication() != null) {
                ObjectNode tenantIdNode = mapper.createObjectNode();
                tenantIdNode.put(ApimgmtConstant.CONDITION, "tenantId");
                tenantIdNode.put(ApimgmtConstant.EQUATION, "=");
                tenantIdNode.put(ApimgmtConstant.CONTENT, key.getApplication());
                tenantIdNode.put(ApimgmtConstant.MARK, ApimgmtConstant.MARK_AND);
                tenantIdNode.put(ApimgmtConstant.ORDER, order++);
                tenantIdNode.put(ApimgmtConstant.BRACKET, closeBracket);
                conditionList.add(tenantIdNode);
            } else {
                if (key.getBranch() != null) {
                    ObjectNode lastNode = (ObjectNode) conditionList.get(conditionList.size() - 1);
                    lastNode.put(ApimgmtConstant.BRACKET, closeBracket);
                } else {
                    apiNameNode.put(ApimgmtConstant.BRACKET, "");
                }
            }
        }

        rootNode.set(ApimgmtConstant.CONDITION_LIST, conditionList);
        rootNode.put(ApimgmtConstant.TYPE_STRING, false);
        rootNode.put("statusId", "");
        rootNode.put(ApimgmtConstant.PAGE_SIZE, apiKeys.size());
        rootNode.put(ApimgmtConstant.PAGE_NUM, 1);

        return rootNode.toString();
    }

    @SuppressWarnings("unchecked")
    private List<ApiMgmtApiInfoDTO> convertToApiInfoDTOList(Map<String, Object> resultMap) {
        List<ApiMgmtApiInfoDTO> result = new ArrayList<>();

        if (resultMap == null || !resultMap.containsKey(ApimgmtConstant.VALUE)) {
            return result;
        }

        List<Map<String, Object>> valueList = (List<Map<String, Object>>) resultMap.get(ApimgmtConstant.VALUE);
        if (CollUtil.isEmpty(valueList)) {
            return result;
        }

        for (Map<String, Object> map : valueList) {
            ApiMgmtApiInfoDTO dto = ApiMgmtApiInfoDTO.builder()
                    .apiId(getLong(map, ApimgmtConstant.API_ID))
                    .name(getString(map, ApimgmtConstant.NAME))
                    .version(getString(map, ApimgmtConstant.VERSION))
                    .approvedStatus(getString(map, ApimgmtConstant.APPROVED_STATUS))
                    .approvedTime(getString(map, ApiAttributeEnum.approvedTime.toString()))
                    .approvedStatusCode(getLong(map, ApimgmtConstant.APPROVED_STATUS_CODE))
                    .description(getString(map, ApimgmtConstant.DESCRIPTION))
                    .remark(getString(map, ApimgmtConstant.REMARK))
                    .syncType(getString(map, ApimgmtConstant.SYNC_TYPE))
                    .categoryId(getLong(map, ApimgmtConstant.CATEGORY_ID))
                    .categoryName(getString(map, ApimgmtConstant.CATEGORY_NAME))
                    .msgFormat(getString(map, ApimgmtConstant.MSG_FORMAT))
                    .requester(getString(map, ApimgmtConstant.REQUESTER))
                    .provider(getString(map, ApimgmtConstant.PROVIDER))
                    .tenantId(getString(map, ApimgmtConstant.TENANT_ID))
                    .apiBuildAcct(getString(map, ApimgmtConstant.API_BUILD_ACCT))
                    .apiBuildTime(getString(map, ApimgmtConstant.API_BUILD_TIME))
                    .designTenantId(getString(map, ApimgmtConstant.DESIGN_TENANT_ID))
                    .teamId(getString(map, ApimgmtConstant.TEAM_ID))
                    .statusId(getLong(map, ApimgmtConstant.STATUS_ID))
                    .apiType(getString(map, ApimgmtConstant.API_TYPE))
                    .projectName(getString(map, ApimgmtConstant.PROJECT_NAME))
                    .projectHasVersions(getBoolean(map, ApimgmtConstant.PROJECT_HAS_VERSIONS))
                    .projectVersionNameList(getList(map, ApimgmtConstant.PROJECT_VERSION_NAME_LIST))
                    .projectVersionNameListStr(getString(map, ApimgmtConstant.PROJECT_VERSION_NAME_LIST_STR))
                    .firstApplicant(getString(map, ApimgmtConstant.FIRST_APPLICANT))
                    .lastApplicant(getString(map, ApimgmtConstant.LAST_APPLICANT))
                    .build();

            result.add(dto);
        }

        return result;
    }

    private String getString(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return value != null ? value.toString() : null;
    }

    private Long getLong(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number) value).longValue();
        }
        try {
            return Long.parseLong(value.toString());
        } catch (NumberFormatException e) {
            return null;
        }
    }

    private Boolean getBoolean(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean) value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    @SuppressWarnings("unchecked")
    private List<String> getList(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof List) {
            return (List<String>) value;
        }
        return null;
    }
}
