package com.digiwin.athena.apimgmt.facade.dto;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.service.util.ApiVersionServiceUtil;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApiMgmtApiKeyDTO {

    private String apiName;

    private String application;

    private String version;

    public String getBranch() {
        if (StrUtil.isNotBlank(version)) {
            return ApiVersionServiceUtil.getBranchFromVersion(version);
        }

        return null;
    }

}
