package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import jakarta.annotation.Nonnull;

import java.beans.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * The persistent class for the standard_api database table.
 */
@TableName(value = "standard_api", resultMap = "StandardApiResultMap")
public class StandardApi implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
	private Long id;

    @TableField("build_acct")
	private String buildAcct;

    @TableField("build_time")
    private LocalDateTime buildTime;

    @TableField("description_en_us")
	private String descriptionEnUs;

    @TableField("description_zh_cn")
	private String descriptionZhCn;

    @TableField("description_zh_tw")
	private String descriptionZhTw;

	private String name;

	private String provider;

    @TableField("remark_en_us")
	private String remarkEnUs;

    @TableField("remark_zh_cn")
	private String remarkZhCn;

    @TableField("remark_zh_tw")
	private String remarkZhTw;

	private String requester;

    @TableField("tag_en_us")
	private String tagEnUs;

    @TableField("tag_zh_cn")
	private String tagZhCn;

    @TableField("tag_zh_tw")
	private String tagZhTw;

    @TableField("is_batch")
	private Boolean isBatch;

	// [S00-20200422001]增加欄位用以標記某些舊申請的API，XML範例中M節點的parameter key不要加_data
    @TableField("msg_m_data")
	private Boolean msgMdata;

    @TableField("msg_format")
	private String msgFormat;

    @TableField("tenant_id")
	private String tenantId;

    @TableField("package_name")
	private String packageName;

	// bi-directional many-to-one association to ApprovedStatus
    @TableField(exist = false)
	private StandardApiGroup standardApiGroup;

	// bi-directional many-to-one association to ApprovedStatus
    @TableField(exist = false)
	private StandardApiSyncType standardApiSyncType;

	// bi-directional many-to-one association to ApprovedStatus
    @TableField(exist = false)
	private StandardApiPaging standardApiPaging;

	// bi-directional many-to-one association to StandardApiCategory
    @TableField(exist = false)
	private StandardApiCategory standardApiCategory;

    @TableField(exist = false)
	private List<StandardApiVersion> standardApiVersions = new ArrayList<>();

    @TableField(exist = false)
	private Long projectId;

    @TableField(exist = false)
	private List<Long> projectVersion;

	/**
	 * 设计租户ID
	 * by songwq 20230625 新增设计租户ID用于对进版功能进行限制
	 */
    @TableField("design_tenant_id")
	private String designTenantId;

	/**
	 * by songwq 20230705 新增teamId 1：鼎捷租户类型 2 外部租户类型 3 其他
	 */
    @TableField("team_id")
	private String teamId;

	/**
	 * by songwq 20230718 新增teamType 1：鼎捷租户类型 2 外部租户类型
	 */
    @TableField("team_type")
	private String teamType;

	/**
	 * 父类API名称
	 */
    @TableField("parent_api_name")
	private String parentApiName;

	/**
	 * 父类API名称
	 */
    @TableField("parent_branch")
	private String parentBranch;

	/**
	 * 父类API租户Id
	 */
    @TableField("parent_api_tenant_id")
	private String parentApiTenantId;

	/**
	 * 扩展字段
	 */
    @TableField("api_extend")
	private String apiExtend;

	/**
	 * 扩展字段
	 */
    @TableField("first_applicant")
	private String firstApplicant;

	/**
	 * API类型
	 */
    @TableField("api_type")
	private String apiType;

	/**
	 * 协议选择
	 */
    @TableField("protocol")
	private String protocol;

	/**
	 * 请求方法
	 */
    @TableField("request_method")
	private String requestMethod;

	/**
	 * 分支
	 */
    @TableField("branch")
	private String branch;

	/**
	 * 分支
	 */
    @TableField("api_path")
	private String apiPath;

    @TableField(exist = false)
	private List<ProjectVersionRelation> projectVersionRelations = new ArrayList<>();

    @TableField(exist = false)
	private String projectName;

    @TableField(exist = false)
	private List<String> projectVersionNameList;
    @TableField(exist = false)
	private Boolean hasVersions=false;

	public StandardApi() {
		msgMdata = true;
		tenantId = "";
	}

	public Boolean getBatch() {
		return isBatch;
	}

	public void setBatch(Boolean batch) {
		isBatch = batch;
	}

	public Boolean getHasVersions() {
		return hasVersions;
	}

	public void setHasVersions(Boolean hasVersions) {
		this.hasVersions = hasVersions;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public List<String> getProjectVersionNameList() {
		return projectVersionNameList;
	}

	public void setProjectVersionNameList(List<String> projectVersionNameList) {
		this.projectVersionNameList = projectVersionNameList;
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getBuildAcct() {
		return this.buildAcct;
	}

	public void setBuildAcct(String buildAcct) {
		this.buildAcct = buildAcct;
	}

    public LocalDateTime getBuildTime() {
		return this.buildTime;
	}

    public void setBuildTime(LocalDateTime buildTime) {
		this.buildTime = buildTime;
	}

	public String getDescriptionEnUs() {
		return this.descriptionEnUs;
	}

	public void setDescriptionEnUs(String descriptionEnUs) {
		this.descriptionEnUs = descriptionEnUs;
	}

	public String getDescriptionZhCn() {
		return this.descriptionZhCn;
	}

	public void setDescriptionZhCn(String descriptionZhCn) {
		this.descriptionZhCn = descriptionZhCn;
	}

	public String getDescriptionZhTw() {
		return this.descriptionZhTw;
	}

	public void setDescriptionZhTw(String descriptionZhTw) {
		this.descriptionZhTw = descriptionZhTw;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getMsgFormat() {
		return this.msgFormat;
	}

	public void setMsgFormat(String msgFormat) {
		this.msgFormat = msgFormat;
	}

	public String getProvider() {
		return this.provider;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public String getRemarkEnUs() {
		return this.remarkEnUs;
	}

	public void setRemarkEnUs(String remarkEnUs) {
		this.remarkEnUs = remarkEnUs;
	}

	public String getRemarkZhCn() {
		return this.remarkZhCn;
	}

	public void setRemarkZhCn(String remarkZhCn) {
		this.remarkZhCn = remarkZhCn;
	}

	public String getRemarkZhTw() {
		return this.remarkZhTw;
	}

	public void setRemarkZhTw(String remarkZhTw) {
		this.remarkZhTw = remarkZhTw;
	}

	public String getRequester() {
		return this.requester;
	}

	public void setRequester(String requester) {
		this.requester = requester;
	}

	public String getTagEnUs() {
		return this.tagEnUs;
	}

	public void setTagEnUs(String tagEnUs) {
		this.tagEnUs = tagEnUs;
	}

	public String getTagZhCn() {
		return this.tagZhCn;
	}

	public void setTagZhCn(String tagZhCn) {
		this.tagZhCn = tagZhCn;
	}

	public String getTagZhTw() {
		return this.tagZhTw;
	}

	public void setTagZhTw(String tagZhTw) {
		this.tagZhTw = tagZhTw;
	}

	public Boolean getIsBatch() {
		return isBatch;
	}

	public void setIsBatch(Boolean isBatch) {
		this.isBatch = isBatch;
	}

	public Boolean getMsgMdata() {
		return msgMdata;
	}

	public void setMsgMdata(Boolean msgMdata) {
		this.msgMdata = msgMdata;
	}

	public StandardApiCategory getStandardApiCategory() {
		return this.standardApiCategory;
	}

	public void setStandardApiCategory(StandardApiCategory standardApiCategory) {
		this.standardApiCategory = standardApiCategory;
	}

	public StandardApiGroup getStandardApiGroup() {
		return this.standardApiGroup;
	}

	public void setStandardApiGroup(StandardApiGroup standardApiGroup) {
		this.standardApiGroup = standardApiGroup;
	}

	public StandardApiSyncType getStandardApiSyncType() {
		return standardApiSyncType;
	}

	public void setStandardApiSyncType(StandardApiSyncType standardApiSyncType) {
		this.standardApiSyncType = standardApiSyncType;
	}

	public StandardApiPaging getStandardApiPaging() {
		return standardApiPaging;
	}

	public void setStandardApiPaging(StandardApiPaging standardApiPaging) {
		this.standardApiPaging = standardApiPaging;
	}

	public List<StandardApiVersion> getStandardApiVersions() {
		return this.standardApiVersions;
	}

	public void setStandardApiVersions(List<StandardApiVersion> standardApiVersions) {
		this.standardApiVersions = standardApiVersions;
	}

	public StandardApiVersion addStandardApiVersion(StandardApiVersion standardApiVersion) {
		getStandardApiVersions().add(standardApiVersion);
		standardApiVersion.setStandardApi(this);

		return standardApiVersion;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenant_id) {
		this.tenantId = tenant_id;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String package_name) {
		this.packageName = package_name;
	}

	public String getDesignTenantId() {
		return designTenantId;
	}

	public void setDesignTenantId(String designTenantId) {
		this.designTenantId = designTenantId;
	}

	public String getTeamId() {
		return teamId;
	}

	public void setTeamId(String teamId) {
		this.teamId = teamId;
	}

	public String getTeamType() {
		return teamType;
	}

	public void setTeamType(String teamType) {
		this.teamType = teamType;
	}

	public String getParentApiName() {
		return parentApiName;
	}

	public void setParentApiName(String parentApiName) {
		this.parentApiName = parentApiName;
	}

	public String getParentApiTenantId() {
		return parentApiTenantId;
	}

	public void setParentApiTenantId(String parentApiTenantId) {
		this.parentApiTenantId = parentApiTenantId;
	}

	public String getApiExtend() {
		return apiExtend;
	}

	public void setApiExtend(String apiExtend) {
		this.apiExtend = apiExtend;
	}

	public String getFirstApplicant() {
		return firstApplicant;
	}

	public void setFirstApplicant(String firstApplicant) {
		this.firstApplicant = firstApplicant;
	}

	public String getApiType() {
		return apiType;
	}

	public void setApiType(String apiType) {
		this.apiType = apiType;
	}

	public String getProtocol() {
		return protocol;
	}

	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	public String getRequestMethod() {
		return requestMethod;
	}

	public void setRequestMethod(String requestMethod) {
		this.requestMethod = requestMethod;
	}

	public String getBranch() {
		return branch;
	}

	public void setBranch(String branch) {
		this.branch = branch;
	}

	public String getApiPath() {
		return apiPath;
	}

	public void setApiPath(String apiPath) {
		this.apiPath = apiPath;
	}

	public List<ProjectVersionRelation> getProjectVersionRelations() {
		return projectVersionRelations;
	}

	public void setProjectVersionRelations(List<ProjectVersionRelation> projectVersionRelations) {
		this.projectVersionRelations = projectVersionRelations;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public List<Long> getProjectVersion() {
		return projectVersion;
	}

	public void setProjectVersion(List<Long> projectVersion) {
		this.projectVersion = projectVersion;
	}

	public String getParentBranch() {
		return parentBranch;
	}

	public void setParentBranch(String parentBranch) {
		this.parentBranch = parentBranch;
	}

    @Transient
    public String getApiTypeOrDefault() {
        String apiType = getApiType();
        if (StrUtil.isBlank(apiType)) {
            return ApiTypeConstants.DEFAULT_CODE;
        }

        return apiType;
    }

    public boolean validateName() {
        return validateName(getApiTypeOrDefault(), getName());
    }

    public static boolean validateName(@Nonnull String apiType, String apiName) {
        if (StrUtil.isBlank(apiName)) {
            return false;
        }

        if (ApiTypeConstants.ESP_CODE.equals(apiType)) {
            return ApimgmtConstant.PATTERN_API_NAME.matcher(apiName).matches();
        } else if (ApiTypeConstants.OPENAPI_CODE.equals(apiType)) {
            return ApimgmtConstant.PATTERN_OPEN_API_NAME.matcher(apiName).matches();
        } else {
            return false;
        }
    }

    public boolean validateBranch() {
        return ApimgmtConstant.PATTERN_BRANCH.matcher(getBranch()).matches();
    }
}