package com.digiwin.athena.apimgmt.service.util;

import java.util.List;
import java.util.Map;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.digiwin.athena.apimgmt.services.ApiMgmtStandardApiSpecAnalyzeService;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * API解析处理类util
 */
@Service
public class StandardApiSpecAnalyzeServiceUtil implements InitializingBean, ApplicationContextAware {

	private static Map<String, ApiMgmtStandardApiSpecAnalyzeService> serviceMap;

	private static ApplicationContext applicationContext;
	
	public static List<Map<String, String>> setStandardApi(StandardApi pStandardApi, JsonNode pRequestJsonNode, String pLocale) throws Exception {
		String apiType = ObjectUtil.isNotNull(pRequestJsonNode.get(ApiAttributeEnum.apiType.toString())) ?
				pRequestJsonNode.get(ApiAttributeEnum.apiType.toString()).asText() : ApimgmtConstant.DEFAULT_API_TYPE;
		pStandardApi.setApiType(apiType);
		return getService(apiType).setStandardApi(pStandardApi, pRequestJsonNode, pLocale);
	}
	
	public static List<Map<String, String>> setStandardApiDataName(StandardApi pStandardApi, JsonNode pRequestJsonNode, Map<String, StandardApiDataName> pAddDataName, String pLocale) throws Exception {
		String apiType = ObjectUtil.isNotNull(pRequestJsonNode.get(ApiAttributeEnum.apiType.toString())) ?
				pRequestJsonNode.get(ApiAttributeEnum.apiType.toString()).asText() : ApimgmtConstant.DEFAULT_API_TYPE;
		return getService(apiType).setStandardApiDataName(pStandardApi, pRequestJsonNode, pAddDataName, pLocale);
	}

	private static ApiMgmtStandardApiSpecAnalyzeService getService(String apiType) {
        // TODO bean 添加前缀
		return serviceMap.getOrDefault(apiType, serviceMap.get("esp"));
	}

	@Override
	public void afterPropertiesSet() {
		Map<String, ApiMgmtStandardApiSpecAnalyzeService> services = applicationContext.getBeansOfType(ApiMgmtStandardApiSpecAnalyzeService.class);
		serviceMap = services;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		StandardApiSpecAnalyzeServiceUtil.applicationContext = applicationContext;
	}
	
}
